#include "Config.h"

Config::Config()
{
  //default settings:
  simpleView=false;
  random=false;
  volume=1.0;
  useTags=true;
  updateOnPlay=false;
  savePlaylistOnQuit=true;
  musicFolder=QDesktopServices::storageLocation(QDesktopServices::MusicLocation);
  //musicFolder="";
  showHidden=false;
  
  //config Directory
  configDir.setPath(QDir::homePath() + "/.config/necroplayer");
  if (!configDir.exists())
    configDir.mkdir(QDir::homePath() + "/.config/necroplayer");
  
  //ID's
  simpleViewID="SimpleView = ";
  randomID="Random = ";
  volumeID="Volume = ";
  useTagsID="UseTags = ";
  updateOnPlayID="UpdateOnPlay = ";
  savePlaylistOnQuitID="SavePlaylist = ";
  musicFolderID="MisicFolder = ";
  showHiddenID="ShowHidden = ";
}
void Config::save()
{

  QFile file(configDir.path() + "/necroplayerrc");
  QTextStream out(&file);
  if (file.open(QIODevice::WriteOnly | QIODevice::Text))
  {
    
    out<<"#UI settings:\n";
    
    out<<simpleViewID;
    if (simpleView)
      out << "true" <<"\n";
    else
      out << "false" <<"\n";
    
    out<<"#Play:\n";
    
    out<<randomID;
    if(random)
      out << "true" <<"\n";
    else
      out << "false" <<"\n";
    
    out<<volumeID<<volume<<"\n";
    
    out<<"#Playlist settings:\n";
    
    out<<useTagsID;
    if(useTags)
     out << "true" <<"\n";
    else
     out << "false" <<"\n";
  
    out<<updateOnPlayID;
    if(updateOnPlay)
      out << "true" <<"\n";
    else
     out << "false" <<"\n";
    
    out<<savePlaylistOnQuitID;
    if(savePlaylistOnQuit)
      out << "true" <<"\n";
    else
     out << "false" <<"\n";
    
    out<<"#FileBrowser:\n";
    
    out <<musicFolderID<<musicFolder<<"\n";
    
    out<<showHiddenID;
    if(showHidden)
      out << "true" <<"\n";
    else
     out << "false" <<"\n";
    
    file.close();

  }
  
}
 void Config::read()
{
  QFile file(configDir.path() + "/necroplayerrc");
  QTextStream in(&file);
  if (file.open(QIODevice::ReadOnly | QIODevice::Text))
  {
    //QString line;// = in.readLine();
    for (QString line=in.readLine();!line.isNull();line=in.readLine())
    {
      if(line.startsWith("#"))
	continue;
      //qDebug()<<line;
      
      if(line.startsWith(simpleViewID))
      {
	line.remove(simpleViewID);
	if (line=="true")
	  simpleView=true;
	else
	  simpleView=false;
	continue;
      }
      
      if(line.startsWith(randomID))
      {
	line.remove(randomID);
	if (line=="true")
	  random=true;
	else
	  random=false;
	continue;
      }
      
      if(line.startsWith(volumeID))
      {
	line.remove(volumeID);
	volume=(line.toFloat());
	continue;
      }
      
      if(line.startsWith(useTagsID))
      {
	line.remove(useTagsID);
	if (line=="true")
	  useTags=true;
	else
	  useTags=false;
	continue;
      }
      
      if(line.startsWith(updateOnPlayID))
      {
	line.remove(updateOnPlayID);
	if (line=="true")
	  updateOnPlay=true;
	else
	  updateOnPlay=false;
	continue;
      }
      
      if(line.startsWith(savePlaylistOnQuitID))
      {
	line.remove(savePlaylistOnQuitID);
	if (line=="true")
	  savePlaylistOnQuit=true;
	else
	  savePlaylistOnQuit=false;
	continue;
      }
      
      if(line.startsWith(musicFolderID))
      {
	line.remove(musicFolderID);
	musicFolder=line;
	continue;
      }
      
      if(line.startsWith(showHiddenID))
      {
	line.remove(showHiddenID);
	if (line=="true")
	  showHidden=true;
	else
	  showHidden=false;
	continue;
      }
      
     // line = in.readLine();
    }
    file.close();
  }
  
}