#include <iostream>
#include "UPlay.h"
#include "UI.h"
#include "Engine.h"



UPlay::UPlay(int & argc, char** argv) : QApplication(argc,argv)
{
	
	setApplicationName("uplay");
	musicPath = "/"; // default path : root
	engine = new Engine(this);
	ui = new UI(this,musicPath);
	restoreConf();
	restorePlaylist();
	if(argc>1)
	{
	  QStringList files;
	  for(int i=1;i<argc;i++)
	    files.append(argv[i]);
	  addMedia(files);
	}
	
	connect(this, SIGNAL(aboutToQuit()), SLOT(onQuit()));
}

UPlay::~UPlay()
{
	if (engine)
		delete engine;
	if (ui)
		delete ui;
}

void
UPlay::addMedia(QStringList ss)
{
	engine->addMedia(ss);
}

void
UPlay::onQuit()
{
	saveConf();
	if (ui->getSettings().getSavePlaylistOnQuitState())
	  ui->getPlaylist().savePlaylist();
}

void
UPlay::restorePlaylist()
{
	QStringList files;
	QFile file(QDir::homePath() + "/.config/necroplayer_list");
	if (file.open(QIODevice::ReadOnly | QIODevice::Text))
	{
		QTextStream in(&file);
		QString line = in.readLine();
		while (!line.isNull())
		{
			files.append(line);	
			line = in.readLine();
		}
	}
	ui->playlistAdd(files);
}

void
UPlay::restoreConf()
{
	QFile file(QDir::homePath() + "/.config/necroplayerrc");
	if (file.open(QIODevice::ReadOnly | QIODevice::Text))
	{
		int l = 0;
		QTextStream in(&file);
		QString line = in.readLine();
		while (!line.isNull())
		{
			switch (l)
			{
				case 0: // music path
					ui->refreshFolderWith(line);
					break;
				case 1: // random enabled ?
					if (ui)
					{
						bool b = false;
						if (line == "true")
						{
							b = true;
						}
						ui->getControls().setRandom(b);
					}
					break;
				case 2: //volume state
					engine->setVolume(line.toFloat());
					break;
				case 3: //save playlist on quit
					if(ui)
					{
					  bool save = false;
					  if (line == "true")
					      save = true;
					  ui->getSettings().setSavePlaylistOnQuitState(save);
					} 
					break;
				  
			}
			// line index
			l++;

			line = in.readLine();
		}
	}
}

void
UPlay::play(int row)
{
	switch (engine->getReadingState())
	{
		case Phonon::PlayingState:
			engine->play(row);
			break;
		case Phonon::PausedState:
			engine->play(row);
			break;
		default:
			int n = row;
			if (n == -1)
			{
				n = ui->playlistCurrentRow();
				if (n == -1) { n = 0; }
			}
			if (n > -1 && n < ui->playlistCount())
			{
				ui->setSelectedRow(n);
				engine->play(n);
			}
			break;
	}
}

void
UPlay::stop()
{
	engine->stop();
}

void
UPlay::next()
{
	int n = engine->getCurrentPlayedMedia();
	int n_next=n;
	int nPlaylistCount=ui->playlistCount();
	if (ui->random)
	{
		if ( nPlaylistCount > 1)
		{
			while (n_next == n )
			{
				n_next = qrand()%nPlaylistCount;
				//qDebug()<<qrand();
				//qDebug()<<qrand()%nPlaylistCount;
			}
		}
		else
		{ // <=1
			n_next = 0;
		}	  
	}
	else
	{
		n_next++;
		if (n_next >= nPlaylistCount)
		{
			n_next = 0;
		}
	}
	if(nPlaylistCount>0) // if not empty playlist
	{
	  engine->play(n_next);
	  ui->setSelectedRow(n_next);
	}
	else
	{
	  engine->stop();
	}
}

void
UPlay::prev()
{
	if(ui->random)
	{
	  next();
	}
	else
	{
	  int n = engine->getCurrentPlayedMedia();
	  int n_prev=n;
	  int nPlaylistCount=ui->playlistCount();
	  n_prev--;
	  if (n_prev < 0)
	  {
		n_prev = nPlaylistCount-1;
	  }
	  
	  if(nPlaylistCount>0) //not epty playlist
	  {
	    engine->play(n_prev);
	    ui->setSelectedRow(n_prev);
	  }
	  else
	  {
	    engine->stop();
	  }
	}
}

void
UPlay::saveConf()
{
	if (ui)
	{
		QFile file(QDir::homePath() + "/.config/necroplayerrc");
		QTextStream out(&file);
		if (file.open(QIODevice::WriteOnly | QIODevice::Text))
		{
			// First, the directory music
			QString dir = ui->getSettings().getDirectory();
			if (dir == "")
			{
				dir = "/";
			}
			out << dir << '\n';
			ui->refreshFolderWith(dir);

			// Then the random state
			bool randomState = ui->getControls().getRandomState();
			if (randomState)
			{
				out << "true" << '\n';
			}
			else
			{
				out << "false" << '\n';
			}
			//volume state
			out<<engine->getVolume()<<'\n';
			//save playlis on quit state
			bool savePlaylist = ui->getSettings().getSavePlaylistOnQuitState();
			if (savePlaylist)
			{
				out << "true" << '\n';
			}
			else
			{
				out << "false" << '\n';
			}			  

			file.close();
		}
	}
}
