#ifndef UISETTINGS_H
#define UISETTINGS_H

#include <QtCore>
#include <QtGui>

class UPlay;

class UISettings : public QWidget
{
		Q_OBJECT
	public:
		/*
		 * Constructor
		 */
		UISettings(UPlay* parent, QString& musicPath);
		~UISettings();

		/**
		 * Return the dir music
		 */
		QString
		getDirectory()
		{
			return directory->text();
		}

		/*
		 * Set the label for the music directory editbox
		 */
		void setDirectory(QString s)
		{
			directory->setText(s);
		}
		bool getSavePlaylistOnQuitState()
		{
		  return savePlaylistOnQuit->isChecked();
		}
		void setSavePlaylistOnQuitState(bool save)
		{
		  if(save)
		    savePlaylistOnQuit->setCheckState(Qt::Checked);
		  else
		    savePlaylistOnQuit->setCheckState(Qt::Unchecked);
		}
		
	public slots:
		void saveConf();
		void selectDir();
	
	private:
		QLineEdit* directory;
		QPushButton* buttonSave;
		QPushButton* buttonDir;
		QHBoxLayout* Hlayout;
		QVBoxLayout* layout;
		QHBoxLayout* saveHlayout;
		QLabel* labelDirectory;
		QCheckBox *savePlaylistOnQuit;

		UPlay* parent;
};

#endif // UIPLAYLIST_H
