#include <iostream>
#include <QtGui>

#include "UPlay.h"

UISettings::UISettings(UPlay* parent, QString& musicPath)
{
	this->parent = parent;
	
	directory = new QLineEdit(musicPath);
	buttonSave = new QPushButton("Save");
	buttonDir = new QPushButton("Browse");
	labelDirectory = new QLabel("Music directory :");
	savePlaylistOnQuit = new QCheckBox("Save playlist on quit");
	//buttonSave->setFixedHeight(30);

	layout = new QVBoxLayout;
	layout->addWidget(labelDirectory);
	Hlayout = new QHBoxLayout;
	Hlayout->addWidget(directory);
	Hlayout->addWidget(buttonDir);
	layout->addLayout(Hlayout);
	layout->addWidget(savePlaylistOnQuit);
	saveHlayout = new QHBoxLayout;
	saveHlayout->addWidget(buttonSave);
	saveHlayout->addStretch();
	layout->addStretch();
	layout->addLayout(saveHlayout);
	layout->setAlignment(Qt::AlignCenter);

	connect(buttonSave, SIGNAL(clicked()), SLOT(saveConf()));
	connect(buttonDir, SIGNAL(clicked()), SLOT(selectDir()));

	setLayout(layout);
}

UISettings::~UISettings()
{
  if (buttonSave)
	delete buttonSave;
  if (directory)
	delete directory;
  if (savePlaylistOnQuit)
	 delete savePlaylistOnQuit;
  if (labelDirectory)
	  delete labelDirectory;
  if (Hlayout)
	  delete Hlayout;
  if (saveHlayout)
	  delete saveHlayout;
  if (layout)
	  delete layout;

}

void
UISettings::saveConf()
{
	parent->saveConf();
}

void
UISettings::selectDir()
{
	QString res = QFileDialog::getExistingDirectory ( this, "Select your music directory", directory->text(), QFileDialog::ShowDirsOnly );
	if (!res.isNull())
	{
		parent->ui->refreshFolderWith(res);
		directory->setText(res);
	}
}
