#include <iostream>
#include <QtGui>

#include "UPlay.h"
#include "UI.h"

UI::UI(UPlay* parent, QString& musicPath)
{
	this->parent = parent;

	//QStyle* style = this->style();

	// Initialize the random
	qsrand(time(NULL));
	random = false;
	
	infosArea = new QScrollArea();
	infosArea->setWidgetResizable(true);
	infosArea->setAlignment(Qt::AlignCenter);
// 	infosLayout=new QVBoxLayout;
	
	infosSong = new QLabel("\n");
	//infosSong->setText("\n");
	infosSong->setAlignment(Qt::AlignCenter);
	//infosSong->setFrameStyle(QFrame::StyledPanel);
	infosLayout=new QVBoxLayout;
	infosLayout->addWidget(infosSong);
	infosArea->setLayout(infosLayout);
	//infosSong->setWordWrap(true);
	
	// Controls
	controls = new UIControl(parent);
	// Playlist
	playlist = new UIPlaylist(parent);
	// Folder
	folder = new UIFolder(parent,musicPath);
	// Settings
	settings = new UISettings(parent, musicPath);

	// Tab
	tab = new QTabWidget;
	tab->addTab(playlist, "Playlist");
	tab->addTab(folder, "Folder");
	tab->addTab(settings,"Settings");

	// Layouts
	mainLayout = new QHBoxLayout;
	ctrlLayout = new QVBoxLayout;
//	mainLayout->addWidget(infosSong);
//	mainLayout->addLayout(parent->engine->getSeekLayout());
//	mainLayout->addWidget(controls);
	//
	inf_seek=new QVBoxLayout;
	inf_seek->addSpacing(10);
	inf_seek->addWidget(infosArea);
	inf_seek->addLayout(parent->engine->getSeekLayout());

	inf_seek_volume=new QHBoxLayout;
	inf_seek_volume->addLayout(inf_seek);
	inf_seek_volume->addLayout(parent->engine->getVolLayout());

	ctrlLayout->addLayout(inf_seek_volume);
	ctrlLayout->addWidget(controls);
	ctrlLayout->addStretch();

	mainLayout->addLayout(ctrlLayout);
//	mainLayout->addLayout(parent->engine->getVolLayout());
	mainLayout->addWidget(tab);

	mainLayout->setSpacing(0);

	// Accept drag'n'drop
	setAcceptDrops(false);

	// UI
	//setMinimumSize(250,80);
	setLayout(mainLayout);
	setWindowTitle("NecroPlayer");
	show();
}
UI::~UI()
{
	//qDebug()<<"UI destructor";
	if (infosSong)
		delete infosSong;
	if (infosLayout)
		delete infosLayout;
	if (infosArea)
		delete infosArea;
	if (controls)
		delete controls; controls = NULL;
	if (folder)
		delete folder; folder = NULL;
	if (settings)
		delete settings; settings = NULL;
	if (tab)
		delete tab;
	if (inf_seek)
		delete inf_seek;
	if (inf_seek_volume)
		delete inf_seek_volume;
	if (ctrlLayout)
		delete ctrlLayout;
	if (mainLayout)
		delete mainLayout;
	
	
}

void
UI::toggleInterface()
{
	tab->setVisible(!tab->isVisible());
	adjustSize();
}
	
// void
// UI::dragEnterEvent(QDragEnterEvent *event)
// {
// 	event->acceptProposedAction();
// }

void
UI::clearPlaylist()
{
	playlist->clearPlaylist(); 
}

// void
// UI::dropEvent(QDropEvent* event)
// {
// 	QList<QUrl> urlList;
// 	QStringList files;
// 
// 	// if dropped data = url
// 	if (event->mimeData()->hasUrls())
// 	{
// 		event->acceptProposedAction();
// 		// we retrieve data
// 		urlList = event->mimeData()->urls();
// 
// 		for (int i = 0; i < urlList.size(); i++)
// 		{
// 			files.append(urlList[i].toString());
// 		}
// 		playlistAdd(files);
// 	}	
// }

void
UI::playlistAdd(QStringList ss)
{
	parent->engine->addMedia(ss);
}

void
UI::addItem(QString s)
{
	playlist->addItem(s);
}

void
UI::play()
{
	parent->play(-1);
}

void
UI::stop()
{
	parent->stop();
}

void
UI::next()
{
	parent->next();
}

void
UI::prev()
{
	parent->prev();
}

void
UI::tQuit()
{
	parent->exit();
}

void
UI::setInfos(QString s,QString totalTime)
{
	infosSong->setText(s);
}

void
UI::switchHide()
{
	hiden = !hiden;
	if (hiden)
	{
		hide();
	}
	else
	{
		show();
	}
}
