#include <iostream>
#include "UPlay.h"
#include "UI.h"
#include "Engine.h"



UPlay::UPlay(int & argc, char** argv) : QApplication(argc,argv)
{
	
	setApplicationName("uplay");
	musicPath = "/"; // default path : root
	engine = new Engine(this);
	ui = new UI(this,musicPath);
	restoreConf();
	restorePlaylist();
	if(argc>1)
	{
	  QStringList files;
	  for(int i=1;i<argc;i++)
	    files.append(argv[i]);
	  addMedia(files);
	}
	
	connect(this, SIGNAL(aboutToQuit()), SLOT(onQuit()));
}

UPlay::~UPlay()
{
	if (engine)
		delete engine;
	if (ui)
		delete ui;
}

void
UPlay::addMedia(QStringList ss)
{
	engine->addMedia(ss);
}

void
UPlay::onQuit()
{
	saveConf();
}

void
UPlay::restorePlaylist()
{
	QStringList files;
	QFile file(QDir::homePath() + "/.config/necroplayer_list");
	if (file.open(QIODevice::ReadOnly | QIODevice::Text))
	{
		QTextStream in(&file);
		QString line = in.readLine();
		while (!line.isNull())
		{
			files.append(line);	
			line = in.readLine();
		}
	}
	ui->playlistAdd(files);
}

void
UPlay::restoreConf()
{
	QFile file(QDir::homePath() + "/.config/necroplayerrc");
	if (file.open(QIODevice::ReadOnly | QIODevice::Text))
	{
		int l = 0;
		QTextStream in(&file);
		QString line = in.readLine();
		while (!line.isNull())
		{
			switch (l)
			{
				case 0: // music path
					ui->refreshFolderWith(line);
					break;
				case 1: // random enabled ?
					if (ui)
					{
						bool b = false;
						if (line == "true")
						{
							b = true;
						}
						ui->getControls().setRandom(b);
					}
					break;
				case 2: //volume state
					engine->setVolume(line.toFloat());
					break;
			}
			// line index
			l++;

			line = in.readLine();
		}
	}
}

void
UPlay::play(int row)
{
	switch (engine->getReadingState())
	{
		case Phonon::PlayingState:
			engine->play(row);
			break;
		case Phonon::PausedState:
			engine->play(row);
			break;
		default:
			int n = row;
			if (n == -1)
			{
				n = ui->playlistCurrentRow();
				if (n == -1) { n = 0; }
			}
			if (n > -1 && n < ui->playlistCount())
			{
				ui->setSelectedRow(n);
				engine->play(n);
			}
			break;
	}
}

void
UPlay::stop()
{
	engine->stop();
}

void
UPlay::next()
{
	int n = engine->getCurrentPlayedMedia();
	if (ui->random)
	{
		n = qrand()%ui->playlistCount();
	}
	else
	{
		n++;
		if (n >= ui->playlistCount())
		{
			n = 0;
		}
	}
	engine->play(n);
	ui->setSelectedRow(n);
}

void
UPlay::prev()
{
	int n = engine->getCurrentPlayedMedia();
	n--;
	if (n < 0)
	{
		n = ui->playlistCount()-1;
	}
	engine->play(n);
	ui->setSelectedRow(n);
}

void
UPlay::saveConf()
{
	if (ui)
	{
		QFile file(QDir::homePath() + "/.config/necroplayerrc");
		QTextStream out(&file);
		if (file.open(QIODevice::WriteOnly | QIODevice::Text))
		{
			// First, the directory music
			QString dir = ui->getSettings().getDirectory();
			if (dir == "")
			{
				dir = "/";
			}
			out << dir << '\n';
			ui->refreshFolderWith(dir);

			// Then the random state
			bool randomState = ui->getControls().getRandomState();
			if (randomState)
			{
				out << "true" << '\n';
			}
			else
			{
				out << "false" << '\n';
			}
			//volume state
			out<<engine->getVolume()<<'\n';
			

			file.close();
		}
	}
}
