#include <iostream>
#include <QtGui>
#include "UPlay.h"

UIFolder::UIFolder(UPlay* parent, QString musicPath)
{
	this->parent = parent;

	listWidget = new QListWidget;

	layout = new QVBoxLayout;
	
	layout->addWidget(listWidget);

	buttonAdd = new QPushButton("Add");
	buttonRepl = new QPushButton("Replace");
	layoutControlF = new QHBoxLayout;
	layoutControlF ->addWidget(buttonAdd);
	layoutControlF ->addStretch();
	layoutControlF ->addWidget(buttonRepl);
	
	layout->addLayout(layoutControlF);



	this->musicPath = musicPath;

	connect(listWidget, SIGNAL(itemDoubleClicked(QListWidgetItem*)), SLOT(folderListDoubleClicked(QListWidgetItem*)));
	
	// Menus
		// Folder menu
	folderMenu = new QMenu;
	actAddFolder = new QAction("Add to playlist", this);
	connect(actAddFolder, SIGNAL(triggered()), this, SLOT(slotAddFolder()));
	actReplFolder = new QAction("Replace in playlist", this);
	connect(actReplFolder, SIGNAL(triggered()), this, SLOT(slotReplFolder()));
	folderMenu->addAction(actAddFolder);
	folderMenu->addAction(actReplFolder);
	
        connect(buttonAdd, SIGNAL(clicked()), SLOT(slotAddFolder()));
	connect(buttonRepl, SIGNAL(clicked()), SLOT(slotReplFolder()));



	// Filters
		// Audios
	filters << "*.mp3" << "*.wav" << "*.wma" << "*.mpc" << "*.m4a" << "*.ogg";
		// Videos
//	filters << "*.avi" << "*.mpg";
		// System
	filters << "..";

	refreshDirContent();
	setLayout(layout);
}

UIFolder::~UIFolder()
{
	//qDebug()<<"UIFolder destructor";
	if (actAddFolder)
		delete actAddFolder;
	if (actReplFolder)
		delete actReplFolder;
	if (folderMenu)
		delete folderMenu; folderMenu = NULL;
	if (buttonAdd)
		delete buttonAdd;
	if (buttonRepl)
		delete buttonRepl;
	if (layoutControlF)
		delete layoutControlF;
	if (listWidget)
		delete listWidget;
	if(layout)
		delete layout;
	
}

void
UIFolder::refreshDirContent()
{
	int i;
	QDir tmp(musicPath);
	QListWidgetItem* item = NULL;
	QStyle * style = parent->style();
	QStyle::StandardPixmap icon;
	QFileInfo fi;

	tmp.setSorting(QDir::DirsFirst | QDir::IgnoreCase);
	tmp.setFilter(QDir::AllDirs | QDir::Files);
	tmp.setNameFilters(filters);

	listWidget->clear();
	dirContent = tmp.entryList();

	for (i=1; i < dirContent.count(); i++) // start to 1 cause the first one is .
	{
		fi.setFile(musicPath+"/"+dirContent[i]);
		if (fi.isDir())
		{
			icon = QStyle::SP_DirIcon;
		}
		else
		{
			icon = QStyle::SP_FileIcon;
		}
				
		item = new QListWidgetItem(style->standardIcon(icon),dirContent[i]);
		if (item)
		{
			listWidget->addItem(item);
		}
	}
}

void
UIFolder::folderListDoubleClicked(QListWidgetItem* item)
{
	QString s = musicPath + "/" + item->text();
	QFileInfo fi;

	fi.setFile(s);

	if (fi.isDir())
	{ // directory
		musicPath += "/" + item->text();
		musicPath = QDir::cleanPath(musicPath);
		refreshDirContent();
	}
	else
	{
		addFile(s);
	}
}

void
UIFolder::addFile(QString uri)
{
  if (fileIsGood(uri))
  {
    QStringList files;
    files.append(uri);
    parent->ui->playlistAdd(files);
  }
}

void
UIFolder::contextMenuEvent(QContextMenuEvent * event)
{
	QFileInfo fi;
	QString fname;

	QListWidgetItem* item = listWidget->currentItem();
	if (item)
	{
		fname = listWidget->currentItem()->text();
		fi.setFile(musicPath + "/" + fname);
		
		folderMenu->exec(event->globalPos());
	}
}

void
UIFolder::slotAddFolder()
{
	// add the content of the dir
	if ((listWidget->currentItem()->text() != "..")&&(listWidget->currentItem()->text() != "."))
	{
		QString uri = musicPath + "/" + listWidget->currentItem()->text();
		QFileInfo fi;
		fi.setFile(uri);
		if (fi.isDir())
		{
			addFolder(uri);
		}
		else
		{	
			addFile(uri);
		}
	}
}

void
UIFolder::slotReplFolder()
{
	// add the content of the dir
	if ((listWidget->currentItem()->text() != "..")&&(listWidget->currentItem()->text() != "."))
	{
		// clear the current playlist
		parent->engine->clearPlayList();
		QString uri = musicPath + "/" + listWidget->currentItem()->text();
		QFileInfo fi;
		fi.setFile(uri);
		if (fi.isDir())
		{
			addFolder(uri);
		}
		else
		{	
			addFile(uri);
		}
	}
}

void UIFolder::addFolder(QString uri)
{
  QStringList files;
  files=getMediaFilesInDir(uri);
   parent->ui->playlistAdd(files);
}


QStringList UIFolder::getMediaFilesInDir(QString uri)
{
  QDir tmp(uri);
  QString s;
  QFileInfo fi;
  QStringList tmpDirContent = tmp.entryList();
  QStringList mFileList;
  int count = tmpDirContent.count();
//   qDebug()<<tmpDirContent;
//   return mFileList;
  
  for(int i=0;i<count;i++)
  {
    if((tmpDirContent[i]=="..")||(tmpDirContent[i]=="."))
      continue;
    s = uri + "/" + tmpDirContent[i];
    fi.setFile(s);
    if(fi.isDir())
    {
      mFileList.append(getMediaFilesInDir(s));
    }
    else
    {
      if (fileIsGood(s))
	{
	  mFileList.append(s);
	}     
    }  
    
  }
  return mFileList;
}

bool UIFolder::fileIsGood(QString uri)
{
  int nbFilters = filters.count();
  bool isGood = false;
  
//  qDebug()<<uri;
  QString filter="";
  for (int i = 0; i < nbFilters;i++)
  {
    //qDebug()<<filters[i];
    filter=filters[i];
    
    if ((uri.endsWith(filter.remove(QRegExp("^[*]")),Qt::CaseInsensitive)) && (filters[i] != ".."))
    {
	isGood = true;
	break;
    }

  } 
  return isGood;
}

void
UIFolder::refreshWithNewMusicPath(QString& s)
{
	musicPath = s;
	refreshDirContent();
}

