#ifndef UI_H
#define UI_H

#include <QtGui>
//#include <Phonon/VolumeSlider>

#include "UIFolder.h"
#include "UIPlaylist.h"
#include "UISettings.h"
#include "UIControl.h"

class UPlay;

class UI : public QWidget
{
		Q_OBJECT
	public:
		UI(UPlay* parent,QString& musicPath);
		~UI();

		/*
		 * Add a file in the playlist
		 */
		void playlistAdd(QStringList ss);
		/*
		 * Clear the playlist
		 */
		void clearPlaylist();

		bool random;
		
		void addItem(QString s);

		void setInfos(QString s, QString totalTime);

		/*
		 * Return the current selected row in the playlist
		 */
		int playlistCurrentRow()
		{
			return playlist->currentRow();
		}
		/*
		 * Return how many files in the playlist
		 */
		int playlistCount()
		{
			return playlist->getWidget()->count();
		}
		/*
		 * Change the selected row in the playlist
		 */
		void setSelectedRow(unsigned int row)
		{
			playlist->getWidget()->setCurrentRow(row);
		}

		/*
		 * Refresh the content of the folder list with a new folder string
		 */
		void refreshFolderWith(QString s)
		{
			if (settings)
				settings->setDirectory(s);
			if (folder)
				folder->refreshWithNewMusicPath(s);
		}

		bool
		isHide()
		{
			return hiden;
		}

		void
		switchHide();

		UIControl& getControls()
		{
			return *controls;
		}

		UISettings& getSettings()
		{
			return *settings;
		}

		UIPlaylist& getPlaylist()
		{
			return *playlist;
		}
	

	public slots:
		/*
		 * Switch between big/small interface
		 */	
		void toggleInterface();
		/*
		 * Controls
		 */
		void play();
		void next();
		void prev();
		void stop();

		// Tray quit
		void tQuit();


	private:
		QTabWidget* tab;
		UIPlaylist* playlist;
		UIFolder* folder;
		UIControl* controls;
		UISettings* settings;
		
//		Phonon::VolumeSlider *volumeSlider;	
		
		QHBoxLayout* mainLayout;
		QVBoxLayout* inf_seek;
		QHBoxLayout* inf_seek_volume;
		QVBoxLayout* ctrlLayout;
		QScrollArea *infosArea;
		
		//QWidget *areaW;
		QVBoxLayout* infosLayout;
		QLabel* infosSong;

//		QSystemTrayIcon* trayIcon;
//		QMenu* trayMenu;
//		QAction* trayPrev;
//		QAction* trayNext;
//		QAction* trayStop;
//		QAction* trayPlay;
//		QAction* trayQuit;

		bool hiden;
		
// 		void dragEnterEvent(QDragEnterEvent* event);
// 		void dropEvent(QDropEvent* event);

		UPlay* parent;
};

#endif // UI_H
