#include <iostream>
#include <QtGui>

#include "Player.h"

UIPlaylist::UIPlaylist(Player* parent)
{
    this->parent = parent;

    widgetPlaylist = new QListWidget;
        widgetPlaylist->setSpacing(0);
        widgetPlaylist->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
        //widgetPlaylist->setGridSize(QSize(500,50));

    QStyle * s = parent->style();

//    buttonDel = new QPushButton("-");
//    buttonDel->setFixedWidth(buttonDel->height());
//    buttonDel->setStyleSheet("font-size: 40pt;font-weight: bold;");
    buttonDel = new QPushButton(s->standardIcon(QStyle::SP_BrowserStop),"");
    buttonMoveUp = new QPushButton(s->standardIcon(QStyle::SP_ArrowUp),"");
    buttonMoveDown = new QPushButton(s->standardIcon(QStyle::SP_ArrowDown),"");
    buttonMoveAfterCurrent = new QPushButton(s->standardIcon(QStyle::SP_DialogResetButton),"");
    buttonGoToCurrent = new QPushButton(s->standardIcon(QStyle::SP_FileDialogContentsView),"");
        buttonPlsSearch = new QPushButton(s->standardIcon(QStyle::SP_BrowserStop),"");

    // Layout
    layout = new QBoxLayout (QBoxLayout::LeftToRight);
        layout->setSpacing(0);
        layout->setMargin(0);

    layoutControlPL = new QBoxLayout (QBoxLayout::Down);
        layoutControlPL->setSpacing(0);
        layoutControlPL->setMargin(0);
    layoutControlPL->addWidget(buttonDel);
    layoutControlPL->addWidget(buttonMoveUp);
    layoutControlPL->addWidget(buttonMoveAfterCurrent);
    layoutControlPL->addWidget(buttonMoveDown);
    layoutControlPL->addWidget(buttonGoToCurrent);
        //layoutControlPL->addWidget(buttonPlsSearch);
        //layoutControlPL->addStretch();
        layoutControlPL->setAlignment(Qt::AlignTop);

    connect(buttonDel, SIGNAL(clicked()), SLOT(delItem()));
    connect(widgetPlaylist, SIGNAL(itemDoubleClicked(QListWidgetItem*)), SLOT(playlistDoubleClicked()));
    connect(buttonMoveUp, SIGNAL(clicked()), SLOT(moveUp()));
    connect(buttonMoveDown, SIGNAL(clicked()), SLOT(moveDown()));
    connect(buttonMoveAfterCurrent, SIGNAL(clicked()), SLOT(moveAfterCurrent()));
    connect(buttonGoToCurrent, SIGNAL(clicked()), SLOT(goToCurrent()));
        connect(buttonPlsSearch, SIGNAL(clicked()), SLOT(plsSearch()));

    layout->addWidget(widgetPlaylist);
    layout->addLayout(layoutControlPL);
    setLayout(layout);

}

UIPlaylist::~UIPlaylist(){

  if (buttonDel)                delete buttonDel;
  if (buttonMoveUp)             delete buttonMoveUp;
  if (buttonMoveDown)           delete buttonMoveDown;
  if (buttonMoveAfterCurrent)   delete buttonMoveAfterCurrent;
  if (buttonGoToCurrent)        delete buttonGoToCurrent;
    if (buttonPlsSearch)        delete buttonPlsSearch;
  if (widgetPlaylist)           delete widgetPlaylist;
  if (layoutControlPL)          delete layoutControlPL;
  if (layout)                   delete layout;
}

void UIPlaylist::playlistDoubleClicked(){
    parent->play(widgetPlaylist->currentRow());
}

void UIPlaylist::addItem(QString s){
    QListWidgetItem* item = new QListWidgetItem(s);
    QSize sz(800, 30);      //list&fontsize
    item->setSizeHint(sz);
    widgetPlaylist->addItem(item);
}

void UIPlaylist::encItem(QString s,int row){
    QListWidgetItem* item = new QListWidgetItem(s);
    QSize sz(800, 30);      //list&fontsize
    item->setSizeHint(sz);
    int currentMedia = parent->engine->getCurrentPlayedMedia();
    widgetPlaylist->insertItem(currentMedia + row, item);
}

void UIPlaylist::delItem(){
    int row = widgetPlaylist->currentRow();
    QListWidgetItem* item = widgetPlaylist->takeItem(row);
    if (item){
        delete item;
        parent->engine->delMedia(row);
    }
}

void UIPlaylist::changeItem(QString s,int row){
    QListWidgetItem* item = widgetPlaylist->item(row);
    if (item){
        item->setText(s);
    }
}

void UIPlaylist::setBold(unsigned int row, bool b){
    QListWidgetItem* item = widgetPlaylist->item(row);
    if (item){
        QFont tmp;
        tmp.setBold(b);
        item->setFont(tmp);
    }
}

void UIPlaylist::goToCurrent(){
    parent->ui->setSelectedRow(parent->engine->getCurrentPlayedMedia());
}

void UIPlaylist::clearPlaylist(){
    parent->engine->clearEnginePlayList();
    widgetPlaylist->clear();
}

void UIPlaylist::moveUp(){
    int currentRow = widgetPlaylist->currentRow();
    if (currentRow <= 0 || widgetPlaylist->count() == 0) return;

    parent->engine->moveMedia(currentRow-1,currentRow);

    QListWidgetItem * currentItem = widgetPlaylist->takeItem(currentRow);
    widgetPlaylist->insertItem(currentRow - 1, currentItem);
    widgetPlaylist->setCurrentRow(currentRow - 1);
}

void UIPlaylist::moveDown(){
    int currentRow = widgetPlaylist->currentRow();
    if (currentRow < 0 || currentRow > widgetPlaylist->count()-2) return;

    parent->engine->moveMedia(currentRow + 2,currentRow);

    QListWidgetItem * currentItem = widgetPlaylist->takeItem(currentRow);
    widgetPlaylist->insertItem(currentRow + 1, currentItem);
    widgetPlaylist->setCurrentRow(currentRow + 1);
}

void UIPlaylist::moveAfterCurrent(){
    int currentRow = widgetPlaylist->currentRow();
    int currentMedia = parent->engine->getCurrentPlayedMedia();
    if (   currentRow < 0
        || currentRow == currentMedia
        || currentRow == currentMedia+1
        || widgetPlaylist->count() == 0) return;

    QListWidgetItem * currentItem = widgetPlaylist->takeItem(currentRow);
    parent->engine->moveMedia(currentMedia+1,currentRow);
    if (currentMedia < currentRow){
        widgetPlaylist->insertItem(currentMedia + 1, currentItem);

        //widgetPlaylist->setCurrentRow(currentMedia + 1);
        widgetPlaylist->setCurrentRow(- 1);
    }else{
        widgetPlaylist->insertItem(currentMedia, currentItem);

        //widgetPlaylist->setCurrentRow(currentMedia);
        widgetPlaylist->setCurrentRow(- 1);
    }
}

void UIPlaylist::plsSearch(){
    //not ready yet

}

void UIPlaylist::setPlaylistH(){
    layoutControlPL->setDirection(QBoxLayout::Down);
    layout->setDirection(QBoxLayout::LeftToRight);
}

void UIPlaylist::setPlaylistV(){
    layoutControlPL->setDirection(QBoxLayout::LeftToRight);
    layout->setDirection(QBoxLayout::Down);
}
