#ifndef UICONTROL_H
#define UICONTROL_H

#include <QtGui>
#include <phonon/mediaobject.h>


class Player;

class UIControl : public QWidget{
        Q_OBJECT
    public:
        /* Constructor */
        UIControl(Player* parent);
        ~UIControl();

        void setPlayIcon(Phonon::State s);  // Set the play/pause icon

        void setControlH();
        void setControlV();

    public slots:
        void toggleList();
        void play();
        void next();
        void prev();
        void stop();

    private:

        QBoxLayout* ctrlLayout_HV;

        QPushButton *buttonPrev,
                    *buttonStop,
                    *buttonPlay,
                    *buttonNext,
                    *buttonToggleList;

        Player* parent;
};

#endif // UICONTROL_H
