#include "UIControl.h"
#include "Player.h"

UIControl::UIControl(Player* parent)
{
    this->parent = parent;

    // Control buttons
    QStyle * s = parent->style();
    buttonPrev = new QPushButton(s->standardIcon(QStyle::SP_MediaSkipBackward),"");
    buttonStop = new QPushButton(s->standardIcon(QStyle::SP_MediaStop),"");
    buttonPlay = new QPushButton(s->standardIcon(QStyle::SP_MediaPlay),"");
    buttonNext = new QPushButton(s->standardIcon(QStyle::SP_MediaSkipForward),"");
    buttonToggleList = new QPushButton(s->standardIcon(QStyle::SP_FileDialogNewFolder),"");

    // Insert control in their layout
    ctrlLayout_HV = new QBoxLayout (QBoxLayout::Down);
        ctrlLayout_HV->setMargin(0);
        ctrlLayout_HV->setSpacing(0);
    ctrlLayout_HV->addWidget(buttonPlay);
    ctrlLayout_HV->addWidget(buttonNext);
    ctrlLayout_HV->addWidget(buttonToggleList);
    //ctrlLayout_HV->addWidget(buttonPrev);
    //ctrlLayout_HV->addWidget(buttonStop);

    // Signals
    connect(buttonPlay, SIGNAL(clicked()), SLOT(play()));
    connect(buttonStop, SIGNAL(clicked()), SLOT(stop()));
    connect(buttonPrev, SIGNAL(clicked()), SLOT(prev()));
    connect(buttonNext, SIGNAL(clicked()), SLOT(next()));
    connect(buttonToggleList, SIGNAL(clicked()), SLOT(toggleList()));

    this->setLayout(ctrlLayout_HV);

}

UIControl::~UIControl(){
    if (buttonPrev)           delete buttonPrev;
    if (buttonStop)           delete buttonStop;
    if (buttonPlay)           delete buttonPlay;
    if (buttonNext)           delete buttonNext;
    if (buttonToggleList)     delete buttonToggleList;
}

void UIControl::play(){
    parent->play(-1);
}

void UIControl::stop(){
    parent->stop();
}

void UIControl::next(){
    parent->next();
}

void UIControl::prev(){
    parent->prev();
}

void UIControl::setPlayIcon(Phonon::State state){
    QStyle* s= parent->style();
    switch (state){
        case Phonon::PlayingState:
            buttonPlay->setIcon(s->standardIcon(QStyle::SP_MediaPlay));
            break;
        case Phonon::PausedState:
            buttonPlay->setIcon(s->standardIcon(QStyle::SP_MediaPause));
            break;
        default:
            break;
    }
}

void UIControl::toggleList(){
        parent->ui->toggleList();
}

void UIControl::setControlH(){
    ctrlLayout_HV->setDirection(QBoxLayout::Down);
}

void UIControl::setControlV(){
    ctrlLayout_HV->setDirection(QBoxLayout::LeftToRight);
}
