#include "SettingsDialog.h"

SettingsDialog::SettingsDialog()
{
    scrArea = new QScrollArea(this);
    scrollW = new QWidget(scrArea);
    scrArea->setWidgetResizable(true);
    scrollLayout = new QVBoxLayout(scrollW);
    #ifdef Q_WS_MAEMO_5
        configLayout = new QHBoxLayout(this);
    #else
        configLayout = new QVBoxLayout(this);
    #endif

    orientationBox = new QGroupBox(scrollW);
    orientationBox->setTitle(tr("Orientation"));
    orientationBox->setObjectName(tr("Orientation Box"));
        orientationLayout = new QVBoxLayout(orientationBox);
        orientationGroup = new QButtonGroup(this);
            orientationH = new QRadioButton(scrollW);
            orientationH->setText(tr("Landscape"));
            orientationA = new QRadioButton(scrollW);
            orientationA->setText(tr("Auto"));
            orientationV = new QRadioButton(scrollW);
            orientationV->setText(tr("Portrait"));
        orientationGroup->addButton(orientationH);
        orientationGroup->addButton(orientationA);
        orientationGroup->addButton(orientationV);
        orientationButtonLayout = new QHBoxLayout();
        orientationButtonLayout->addWidget(orientationH);
        orientationButtonLayout->addWidget(orientationA);
        orientationButtonLayout->addWidget(orientationV);
        orientationLayout->addLayout(orientationButtonLayout);
    orientationBox->setLayout(orientationLayout);
    scrollLayout->addWidget(orientationBox);

    playlistBox = new QGroupBox(scrollW);
    playlistBox->setTitle(tr("Playlist"));
    playlistBox->setObjectName("Playlist Box");
        playlistLayout = new QVBoxLayout(playlistBox);
        savePositionOnQuit = new QCheckBox(scrollW);
        savePositionOnQuit->setText(tr("Save playing position on quit"));
        playlistLayout->addWidget(savePositionOnQuit);
    playlistBox->setLayout(playlistLayout);
    scrollLayout->addWidget(playlistBox);

    directoryBox = new QGroupBox(scrollW);
    directoryBox->setTitle(tr("Music Directory"));
    directoryBox->setObjectName("Music Directory Box");
        directoryLayoutV = new QVBoxLayout(directoryBox);
        directoryLayout1 = new QHBoxLayout();
        directoryLayout2 = new QHBoxLayout();
            labelDirectory1 = new QLabel(scrollW);
            labelDirectory1->setText(tr("Directory 1:"));
            labelDirectory2 = new QLabel(scrollW);
            labelDirectory2->setText(tr("Directory 2:"));
            directoryLayout1->addWidget(labelDirectory1);
            directoryLayout2->addWidget(labelDirectory2);
        directory1 = new QLineEdit(scrollW);
        directory2 = new QLineEdit(scrollW);
        directoryLayout1->addWidget(directory1);
        directoryLayout2->addWidget(directory2);
            buttonDir1 = new QPushButton(scrollW);
            buttonDir1->setText(tr("Browse"));
            buttonDir2 = new QPushButton(scrollW);
            buttonDir2->setText(tr("Browse"));
        directoryLayout1->addWidget(buttonDir1);
        directoryLayout2->addWidget(buttonDir2);
        directoryLayoutV->addLayout(directoryLayout1);
        //directoryLayoutV->addLayout(directoryLayout2);
            showHiddenFiles = new QCheckBox(scrollW);
            showHiddenFiles->setText(tr("Show hidden files"));
        directoryLayoutV->addWidget(showHiddenFiles);
    directoryBox->setLayout(directoryLayoutV);
    scrollLayout->addWidget(directoryBox);

    scrArea->setWidget(scrollW);

    dialogButtons = new QDialogButtonBox(this);
    dialogButtons->setStandardButtons(QDialogButtonBox::Ok|QDialogButtonBox::Cancel);
    #ifdef Q_WS_MAEMO_5
    dialogButtons->setOrientation(Qt::Vertical);
    #endif

    configLayout->addWidget(scrArea);
    configLayout->addWidget(dialogButtons);

    setWindowTitle(tr("Settings"));

    connect(buttonDir1,SIGNAL(clicked()),this,SLOT(browseDir1()));
    connect(buttonDir2,SIGNAL(clicked()),this,SLOT(browseDir2()));
    connect(dialogButtons,SIGNAL(accepted()),this,SLOT(accept()));
    connect(dialogButtons,SIGNAL(rejected()),this,SLOT(reject()));
}

SettingsDialog::~SettingsDialog(){
    if(orientationBox)          delete orientationBox;
    if(orientationLayout)       delete orientationLayout;
    if(orientationH)            delete orientationH;
    if(orientationA)            delete orientationA;
    if(orientationV)            delete orientationV;
    if(dialogButtons)		delete dialogButtons;
    if(showHiddenFiles)		delete showHiddenFiles;
    if(buttonDir1)		delete buttonDir1;
    if(buttonDir2)		delete buttonDir2;
    if(directory1)		delete directory1;
    if(directory2)		delete directory2;
    if(labelDirectory1)		delete labelDirectory1;
    if(labelDirectory2)		delete labelDirectory2;
    if(directoryBox)		delete directoryBox;
    if(savePositionOnQuit)	delete savePositionOnQuit;
    if(directoryLayout1)	delete directoryLayout1;
    if(directoryLayout2)	delete directoryLayout2;
    if(directoryLayoutV)	delete directoryLayoutV;
    if(playlistLayout)		delete playlistLayout;
    if(playlistBox)		delete playlistBox;
    if(configLayout)		delete configLayout;
    if(scrollLayout)		delete scrollLayout;
    if(scrollW)			delete scrollW;
    if(scrArea)			delete scrArea;
}

void SettingsDialog::setConfig(Config* inputConfig){
    switch (inputConfig->orientation){
        case 0:
            orientationH->setChecked(true); break;
        case 1:
            orientationA->setChecked(true); break;
        case 2:
            orientationV->setChecked(true); break;
        default:
            break;
    }
    savePositionOnQuit->setChecked(inputConfig->savePosition);
    directory1->setText(inputConfig->musicFolder1);
    directory2->setText(inputConfig->musicFolder2);
    showHiddenFiles->setChecked(inputConfig->showHidden);
}

void SettingsDialog::getConfig(Config* outputConfig){
    if (orientationH->isChecked()) outputConfig->orientation=0;
    else if (orientationA->isChecked()) outputConfig->orientation=1;
    else if (orientationV->isChecked()) outputConfig->orientation=2;
    outputConfig->savePosition=savePositionOnQuit->isChecked();
    outputConfig->musicFolder1=directory1->text();
    outputConfig->musicFolder2=directory2->text();
    outputConfig->showHidden=showHiddenFiles->isChecked();
}

void SettingsDialog::browseDir1(){
    QString res = QFileDialog::getExistingDirectory
        (this,tr("Select music directory"),directory1->text(),QFileDialog::ShowDirsOnly);
    if (!res.isNull()){directory1->setText(res);}
}

void SettingsDialog::browseDir2(){
    QString res = QFileDialog::getExistingDirectory
        (this,tr("Select music directory"),directory2->text(),QFileDialog::ShowDirsOnly);
    if (!res.isNull()){directory2->setText(res);}
}
