#ifndef PLAYER_H
#define PLAYER_H

#include <QtCore>
#include <QtGui>

#include "Engine.h"
#include "UI.h"
#include "Config.h"

class Player : public QApplication{
        Q_OBJECT
    public:
        Player(int& argc, char** argv);
        /*Destructor*/
        ~Player();

        /*The media engine*/
        Engine* engine;
        /*The ui*/
        UI* ui;
        Config* config;

        /*To restore from a file the content of the playlist*/
        void restorePlaylist(QString filename="");
        void savePlaylist(QString filename="");
        void openPlaylist_pls(QString filename);

        void addMedia(QStringList ss);

        void saveConf();
        void restoreConf();

    public slots:
        void onQuit();
        void play(int row);
        void stop();
        void next();
        void prev();

    private:
        QString musicPath;
};
#endif
