#ifndef ENGINE_H
#define ENGINE_H

#include <QtGui>

#include <phonon/seekslider.h>
#include <phonon/audiooutput.h>
#include <phonon/mediaobject.h>
#include <phonon/mediasource.h>
//#include <phonon/volumeslider.h>

#include <QtDBus>

class Player;

class Engine : public QObject{
        Q_OBJECT
    public:
        Engine(Player *parent);

        ~Engine();

        int play(int row);  // Return the row played, or -1 if an error occured
        void stop();        // Stop playing

        QVBoxLayout* getSeekLayout(){return seekLayout;}    //Content of seekbar
        QVBoxLayout* getTimeLayout(){return timeLayout;}
        //QVBoxLayout* getVolLayout(){return volLayout;}

        qreal getVolume(){return audioOutput->volume();}
        void setVolume(qreal vol){audioOutput->setVolume(vol);}

        qint64 getCurrentTime(){return mediaObject->currentTime();}
        void restoreState(int row, qint64 time);

        void addMedia(QStringList files);   // Add media
        void encMedia(QStringList files);   // Enc media
        void moveMedia(int i, int j);       // swap media
        int delMedia(int row);              // Delete media

        // Return the index of the currently played media
        int getCurrentPlayedMedia();
        void setCurrentPlayedMedia(int current){currentPlayedMedia=current;}

        QString getUri(unsigned int row);   // Return the uri index 'row'
        int getNUris();

        void clearEnginePlayList();         // Clear playlist, uris & sources list

        // Return the state of the player (is it playing ? paused ?)
        Phonon::State getReadingState(){
            Phonon::State ret = Phonon::ErrorState;
            if (mediaObject){
                    ret = mediaObject->state();
            }
            return ret;
        }

        void setSliderH();
        void setSliderV();

    public slots:
        void refreshPlayedTime();
        void refreshTotalTime();
        void playEnded();
        void setInitialPosition(Phonon::State state);
        void headphoneEvent(QString, QString);

    private:
        int currentPlayedMedia;

        Phonon::AudioOutput* audioOutput;
        Phonon::MediaObject* mediaObject;
        Phonon::SeekSlider* seekSlider;
//        Phonon::VolumeSlider *volumeSlider;

        QVBoxLayout* seekLayout;
//        QVBoxLayout* volLayout;
        QVBoxLayout* timeLayout;

        QLabel *currentTime, *totalTime;

        QVector<Phonon::MediaSource> listSources;
        QVector<QString> listUris;

        Player* parent;

        qint64 init_position;
        bool initial;
};

#endif
