#include <iostream>
#include <QtGui>

#include "Player.h"

Engine::Engine(Player* parent)
{
    this->parent = parent;

    // Phonon init
    audioOutput = new Phonon::AudioOutput(Phonon::MusicCategory);
    mediaObject = new Phonon::MediaObject();
    Phonon::createPath(mediaObject,audioOutput);
    mediaObject->setTickInterval(1000);
    mediaObject->setTransitionTime(1000);

    // seekslider
    seekLayout = new QVBoxLayout;
        seekLayout->setSpacing(0);
        seekLayout->setMargin(0);
    seekSlider = new Phonon::SeekSlider();
        seekSlider->setIconVisible(false);
        seekSlider->setOrientation(Qt::Vertical);
    seekLayout->addWidget(seekSlider);

    // volume
        //volLayout=new QVBoxLayout;
            //volumeSlider = new Phonon::VolumeSlider();
            //volumeSlider->setAudioOutput(audioOutput);
            ////volumeSlider->setSizePolicy(QSizePolicy::Maximum,QSizePolicy::Expanding);
            //volumeSlider->setOrientation(Qt::Vertical);
            //volumeSlider->setMuteVisible(false);
        //volLayout->addWidget(volumeSlider);

    // time
    timeLayout = new QVBoxLayout;
        currentTime = new QLabel("00:00");
        totalTime = new QLabel("00:00");
    timeLayout->addWidget(currentTime);
    timeLayout->addWidget(totalTime);
    timeLayout->setSpacing(0); timeLayout->setMargin(0);
        //QFont font; font.setPointSize(12); font.setBold(true);
        //totalTime->setFont(font); currentTime->setFont(font);
    timeLayout->setAlignment(Qt::AlignCenter);

    // media
    connect(mediaObject,SIGNAL(finished()),SLOT(playEnded()));
    connect(mediaObject,SIGNAL(tick(qint64)),SLOT(refreshPlayedTime()));
    connect(mediaObject,SIGNAL(totalTimeChanged(qint64)), this, SLOT(refreshTotalTime()));
    connect(mediaObject,SIGNAL(stateChanged(Phonon::State,Phonon::State)),
            this,SLOT(setInitialPosition(Phonon::State)));

    QDBusConnection::systemBus().connect(QString(),
        "/org/freedesktop/Hal/devices/platform_headphone",
        "org.freedesktop.Hal.Device", "Condition", this,
        SLOT(headphoneEvent(QString,QString)));

    // default value
    currentPlayedMedia  = -1;
    init_position       = 0;
    initial             = false;
}

Engine::~Engine(){	
    //qDebug()<<"Engine destructor";
    if (seekSlider)     delete seekSlider; seekSlider = NULL;
    if (seekLayout)     delete seekLayout; seekLayout = NULL;
    //if (volumeSlider)   delete volumeSlider;
    //if (volLayout)      delete volLayout;
    if (timeLayout)     delete timeLayout;
    if (currentTime)    delete currentTime; currentTime = NULL;
    if (totalTime)      delete totalTime; totalTime = NULL;
    if (audioOutput)    delete audioOutput; audioOutput = NULL;
    if (mediaObject)    delete mediaObject; mediaObject = NULL;
}

void Engine::stop(){
    if (mediaObject){
        mediaObject->stop();
        parent->ui->getPlaylist().setBold(currentPlayedMedia,false);
        parent->ui->getControls().setPlayIcon(Phonon::PlayingState);
        currentTime->setText("00:00");
        totalTime->setText("00:00");
        parent->ui->setWindowTitle("necrolongplayer");
    }
}

/* Return the row played, or -1 if an error occured */
int Engine::play(int row){

    if(row>=0) initial=false;

    if (currentPlayedMedia != -1 && row == -1){
        switch (mediaObject->state()){
            case Phonon::PausedState:
                row = currentPlayedMedia;
                if (mediaObject){
                    mediaObject->play();
                    parent->ui->getControls().setPlayIcon(Phonon::PausedState);
                }
                break;
            case Phonon::PlayingState:
                mediaObject->pause();
                parent->ui->getControls().setPlayIcon(Phonon::PlayingState);
                row = currentPlayedMedia;
                break;
            default:
                break;
            }
    }else{
        if (row < listUris.count()){
            int prev_media_indx=listSources.indexOf(mediaObject->currentSource());
            if (prev_media_indx > -1){
                parent->ui->getPlaylist().setBold(prev_media_indx,false);
            }
            mediaObject->setCurrentSource(listSources[row]);
            seekSlider->setMediaObject(mediaObject);
            currentPlayedMedia = row;
            parent->ui->getPlaylist().setBold(row,true);
            mediaObject->play(); // go
            parent->ui->getControls().setPlayIcon(Phonon::PausedState);
        }else{
            row = -1;
        }
    }
return row;
}

void Engine::addMedia(QStringList files){
    if (files.isEmpty()) return;
    //int index = listSources.size();
    QFileInfo fi;

    foreach (QString string, files){
        Phonon::MediaSource source(string);
        listSources.append(source);
        listUris.append(string);
        fi.setFile(string);
        parent->ui->addItem(fi.baseName()); //show filename w/o extension //fi.fileName()
    }
}

void Engine::encMedia(QStringList files){
    if (files.isEmpty()) return;
    QFileInfo fi;
    int currentMedia = -1;
    currentMedia = getCurrentPlayedMedia();
    int i=1;

    foreach (QString string, files){
        Phonon::MediaSource source(string);
        listSources.insert(currentMedia+i,source);
        listUris.insert(currentMedia+i,string);
        fi.setFile(string);
        parent->ui->encItem(fi.baseName(), i); //show filename without extension
        i++;
    }
}

void Engine::moveMedia(int i, int j){
    if ((i && j) < listUris.count()){
        listSources.insert(i,listSources.value(j));
        listUris.insert(i,listUris.value(j));
        if (j<=i){
            listSources.remove(j);
            listUris.remove(j);
        }else{
            listSources.remove(j+1);
            listUris.remove(j+1);
        }
    }
}

void Engine::refreshPlayedTime(){
    int time = mediaObject->currentTime();
    QTime displayTime(0, (time / 60000) % 60, (time / 1000) % 60);
    currentTime->setText(displayTime.toString("mm:ss"));
}

void Engine::refreshTotalTime(){
    int time = mediaObject->totalTime();
    QTime displayTime(0, (time / 60000) % 60, (time / 1000) % 60);
    totalTime->setText(displayTime.toString("mm:ss")); //" / " +
}

QString Engine::getUri(unsigned int row){
    QString ret = "";
    if (row < (unsigned int)listUris.count()){
        ret = listUris.at(row);
    }
    return ret;
}

void Engine::playEnded(){
    parent->next();
}

int Engine::delMedia(int row){
    int ret = 0;
    if (row < listUris.count()){
        listSources.remove(row);
        listUris.remove(row);
        ret = 1;
    }
    return ret;
}

void Engine::clearEnginePlayList(){
    //if (parent && parent->ui) parent->ui->clearPlaylist();
    listSources.clear();
    listUris.clear();
}

void Engine::setInitialPosition(Phonon::State state){
 // qDebug()<<"State: "<<state;
    if(initial){
        if(state==Phonon::PlayingState){
            initial=false;
            mediaObject->seek(init_position);
        }
        if(state==Phonon::PausedState){
            mediaObject->seek(init_position);
        }
    }
    // Set Window Title // not the best position atm
    if (currentPlayedMedia < listUris.count() ){
        QFileInfo fi(listUris[currentPlayedMedia]);
        parent->ui->setWindowTitle(fi.baseName() );
    }
}

void Engine::restoreState(int row, qint64 time){
  //qDebug()<<row<<" :::: "<<time;
  if(row < listUris.count()){
    //qDebug()<<listSources.size();
    mediaObject->setCurrentSource(listSources[row]);
    seekSlider->setMediaObject(mediaObject);

    currentPlayedMedia=row;
    parent->ui->getPlaylist().setBold(row,true);

    mediaObject->pause();
    parent->ui->getControls().setPlayIcon(Phonon::PlayingState);

    initial=true;
    init_position=time;
  }
}

int Engine::getCurrentPlayedMedia(){
    int media_indx=listSources.indexOf(mediaObject->currentSource());
    return media_indx;
    //return currentPlayedMedia;
}

int Engine::getNUris(){
  return listUris.size();
}

void Engine::headphoneEvent(QString what,QString how){
    //qDebug() << what.toAscii() << how.toAscii();
    if (what != "ButtonPressed" || how != "connection") return;
    bool present = QDBusInterface ("org.freedesktop.Hal",
                    "/org/freedesktop/Hal/devices/platform_headphone",
                    "org.freedesktop.Hal.Device",
                    QDBusConnection::systemBus()).call ("GetProperty",
                    "button.state.value").arguments().at(0).toBool();

    if (!present){                  // headphone disconnect
        if (mediaObject->state() == Phonon::PlayingState) {play(-1);}
    }
    if (present){                   // headphone connected
        if (mediaObject->state() == Phonon::PausedState) {
            usleep(1250000);        // will go to hell, but silent :)
            play(-1);
        }
    }
}

void Engine::setSliderH(){
    seekSlider->setOrientation(Qt::Vertical);
}

void Engine::setSliderV(){
    seekSlider->setOrientation(Qt::Horizontal);
}
