#include "Config.h"

Config::Config()
{
    //default settings:
    random=false;
    volume=1.0;
    lastPlayed=0;
    savePosition=true;
    position=0;
    musicFolder1=QDesktopServices::storageLocation(QDesktopServices::MusicLocation);
    musicFolder2="";
    showHidden=false;
    orientation=2;

    //config Directory
    configDir.setPath(QDir::homePath() + "/.config/necrolongplayer");
    if (!configDir.exists())
      configDir.mkdir(QDir::homePath() + "/.config/necrolongplayer");

    //ID's
    randomID="Random = ";
    volumeID="Volume = ";
    lastPlayedID="LastPlayed = ";
    savePositionID="SavePosition = ";
    positionID="Position = ";
    musicFolderID="MusicFolder = ";
    musicFolder2ID="MusicFolder2 = ";
    showHiddenID="ShowHidden = ";
    orientationID="Orientation = ";
}

void Config::save(){
    QFile file(configDir.path() + "/necrolongplayerrc");
    QTextStream out(&file);

    if (file.open(QIODevice::WriteOnly | QIODevice::Text)){

        out<<randomID;
        if(random) out << "true" <<"\n";
        else out << "false" <<"\n";

        out<<volumeID<<volume<<"\n";

        out<<savePositionID;
        if(savePosition) out << "true" <<"\n";
        else out << "false" <<"\n";

        out<<lastPlayedID<<lastPlayed<<"\n";
        out<<positionID<<position<<"\n";

        out <<musicFolderID<<musicFolder1<<"\n";
        out <<musicFolder2ID<<musicFolder2<<"\n";

        out<<showHiddenID;
        if(showHidden) out << "true" <<"\n";
        else out << "false" <<"\n";

        out<<orientationID<<orientation<<"\n";

        file.close();
    }
}

void Config::read(){
    QFile file(configDir.path() + "/necrolongplayerrc");
    QTextStream in(&file);
    if (file.open(QIODevice::ReadOnly | QIODevice::Text)){
        //QString line;// = in.readLine();
        for (QString line=in.readLine();!line.isNull();line=in.readLine()){
            if(line.startsWith("#")) continue;
            //qDebug()<<line;

            if(line.startsWith(randomID)){
                line.remove(randomID);
                if (line=="true") random=true;
                else random=false;
            continue;
            }

            if(line.startsWith(volumeID)){
                line.remove(volumeID);
                volume=(line.toFloat());
                continue;
            }

            if(line.startsWith(lastPlayedID)){
                 line.remove(lastPlayedID);
                 lastPlayed=(line.toInt());
                 continue;
               }

            if(line.startsWith(savePositionID)){
              line.remove(savePositionID);
              if (line=="true") savePosition=true;
              else savePosition=false;
              continue;
            }

            if(line.startsWith(positionID)){
              line.remove(positionID);
              position=(line.toLongLong());
              continue;
            }

            if(line.startsWith(musicFolderID)){
                line.remove(musicFolderID);
                musicFolder1=line;
                continue;
            }

            if(line.startsWith(musicFolder2ID)){
                line.remove(musicFolder2ID);
                musicFolder2=line;
                continue;
            }

            if(line.startsWith(showHiddenID)){
                line.remove(showHiddenID);
                if (line=="true") showHidden=true;
                else showHidden=false;
                continue;
            }

            if(line.startsWith(orientationID)){
                 line.remove(orientationID);
                 orientation=(line.toLongLong());
                 continue;
               }
            // line = in.readLine();
        }
        file.close();
    }

}
