/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.test;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import org.smslib.AGateway;
import org.smslib.GatewayException;
import org.smslib.InboundMessage;
import org.smslib.Message;
import org.smslib.OutboundMessage;
import org.smslib.TimeoutException;

public class TestGateway
extends AGateway {
    private int refCounter = 0;
    private int counter = 0;
    protected int failCycle;
    protected int receiveCycle;
    Thread incomingMessagesThread;

    public TestGateway(String id) {
        super(id);
        this.attributes = 1;
        this.outbound = true;
        this.inbound = true;
        this.receiveCycle = 2000;
    }

    @Override
    public boolean deleteMessage(InboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return true;
    }

    private InboundMessage generateIncomingMessage() {
        this.incInboundMessageCount();
        return new InboundMessage(new Date(), "+1234567890", "Hello World! #" + this.getInboundMessageCount(), 0, null);
    }

    @Override
    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        super.startGateway();
        this.incomingMessagesThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!TestGateway.this.incomingMessagesThread.isInterrupted()) {
                    Thread thread = TestGateway.this.incomingMessagesThread;
                    synchronized (thread) {
                        try {
                            TestGateway.this.incomingMessagesThread.wait(TestGateway.this.receiveCycle);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                    if (TestGateway.this.incomingMessagesThread.isInterrupted() || TestGateway.this.getInboundNotification() == null) continue;
                    TestGateway.this.logInfo("Detecting incoming message");
                    TestGateway.this.getInboundNotification().process(TestGateway.this.getGatewayId(), Message.MessageTypes.INBOUND, new InboundMessage(Message.MessageTypes.INBOUND, 0, ""));
                }
            }
        }, "IncomingMessagesThread");
        this.incomingMessagesThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        super.stopGateway();
        if (this.incomingMessagesThread != null) {
            Thread thread = this.incomingMessagesThread;
            synchronized (thread) {
                this.incomingMessagesThread.interrupt();
            }
        }
    }

    @Override
    public InboundMessage readMessage(String memLoc, int memIndex) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.generateIncomingMessage();
    }

    @Override
    public void readMessages(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        msgList.add(this.generateIncomingMessage());
    }

    @Override
    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        Thread.sleep(500L);
        ++this.counter;
        if (this.failCycle > 0 && this.counter >= this.failCycle) {
            msg.setFailureCause(OutboundMessage.FailureCauses.GATEWAY_FAILURE);
            this.failCycle = 0;
            return false;
        }
        msg.setDispatchDate(new Date());
        msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
        msg.setRefNo(Integer.toString(++this.refCounter));
        msg.setGatewayId(this.getGatewayId());
        this.logInfo("Send to: " + msg.getRecipient() + " via: " + msg.getGatewayId());
        return true;
    }

    public int getFailCycle() {
        return this.failCycle;
    }

    public void setFailCycle(int failCycle) {
        this.failCycle = failCycle;
    }
}

