/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.smsserver.interfaces;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.smslib.InboundMessage;
import org.smslib.OutboundMessage;
import org.smslib.smsserver.AInterface;
import org.smslib.smsserver.SMSServer;

public class SimpleInboundFileLogger
extends AInterface<Void> {
    private BufferedWriter out;

    public SimpleInboundFileLogger(String infId, Properties props, SMSServer server, AInterface.InterfaceTypes type) {
        super(infId, props, server, type);
        this.description = "Simple file logger for inbound messages.";
    }

    @Override
    public void start() throws Exception {
        this.out = new BufferedWriter(new FileWriter(this.getProperty("filename", ""), true));
    }

    @Override
    public void stop() throws Exception {
        if (this.out != null) {
            this.out.close();
        }
    }

    @Override
    public void CallReceived(String gtwId, String callerId) {
    }

    @Override
    public void MessagesReceived(Collection<InboundMessage> msgList) throws Exception {
        for (InboundMessage msg : msgList) {
            this.out.write(msg.getDate() + "|" + msg.getOriginator() + "|" + msg.getText());
            this.out.flush();
        }
    }

    @Override
    public Collection<OutboundMessage> getMessagesToSend() throws Exception {
        return new ArrayList<OutboundMessage>();
    }

    @Override
    public void markMessage(OutboundMessage msg) throws Exception {
    }
}

