/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.smsserver.gateways;

import java.util.Properties;
import org.smslib.AGateway;
import org.smslib.modem.SerialModemGateway;
import org.smslib.smsserver.AGateway;
import org.smslib.smsserver.SMSServer;

public class SerialModem
extends AGateway {
    public SerialModem(String gtwId, Properties props, SMSServer server) {
        super(gtwId, props, server);
        this.description = "Default Serial Modem Gateway.";
    }

    @Override
    public void create() throws Exception {
        String propName = this.gtwId + ".";
        this.gtw = new SerialModemGateway(this.gtwId, this.props.getProperty(propName + "port"), Integer.parseInt(this.props.getProperty(propName + "baudrate")), this.props.getProperty(propName + "manufacturer"), this.props.getProperty(propName + "model"));
        if (this.props.getProperty(propName + "protocol").equalsIgnoreCase("pdu")) {
            this.gtw.setProtocol(AGateway.Protocols.PDU);
        } else if (this.props.getProperty(propName + "protocol").equalsIgnoreCase("text")) {
            this.gtw.setProtocol(AGateway.Protocols.TEXT);
        } else {
            throw new Exception("Incorrect parameter: " + propName + "protocol");
        }
        ((SerialModemGateway)this.gtw).setSimPin(this.props.getProperty(propName + "pin"));
        if (this.props.getProperty(propName + "inbound").equalsIgnoreCase("yes")) {
            this.gtw.setInbound(true);
        } else if (this.props.getProperty(propName + "inbound").equalsIgnoreCase("no")) {
            this.gtw.setInbound(false);
        } else {
            throw new Exception("Incorrect parameter: " + propName + "inbound");
        }
        if (this.props.getProperty(propName + "outbound").equalsIgnoreCase("yes")) {
            this.gtw.setOutbound(true);
        } else if (this.props.getProperty(propName + "outbound").equalsIgnoreCase("no")) {
            this.gtw.setOutbound(false);
        } else {
            throw new Exception("Incorrect parameter: " + propName + "outbound");
        }
        this.gtw.setInboundNotification(this.server.getInboundNotification());
        this.gtw.setOutboundNotification(this.server.getOutboundNotification());
        this.gtw.setCallNotification(this.server.getCallNotification());
    }
}

