/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.smsserver;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.smslib.InboundMessage;
import org.smslib.OutboundMessage;
import org.smslib.Service;
import org.smslib.smsserver.SMSServer;

public abstract class AInterface<T> {
    protected String infId;
    protected Properties props;
    protected SMSServer server;
    protected InterfaceTypes type;
    protected String description;
    protected Map<Long, T> messageIdCache;

    public AInterface(String infId, Properties props, SMSServer server, InterfaceTypes type) {
        this.infId = infId;
        this.props = props;
        this.server = server;
        this.type = type;
        this.messageIdCache = new HashMap<Long, T>();
    }

    public abstract void CallReceived(String var1, String var2) throws Exception;

    public final String getDescription() {
        return this.description;
    }

    public abstract Collection<OutboundMessage> getMessagesToSend() throws Exception;

    public final String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public final String getProperty(String key, String defaultValue) {
        defaultValue = this.props.getProperty(this.infId + "." + key, defaultValue);
        return defaultValue;
    }

    public final InterfaceTypes getType() {
        return this.type;
    }

    public final boolean isInbound() {
        return InterfaceTypes.INBOUND == this.type || InterfaceTypes.INOUTBOUND == this.type;
    }

    public final boolean isOutbound() {
        return InterfaceTypes.OUTBOUND == this.type || InterfaceTypes.INOUTBOUND == this.type;
    }

    public final void logDebug(String message) {
        this.logDebug(message, null);
    }

    public final void logDebug(String message, Exception e) {
        if (this.server != null) {
            this.server.srv.logDebug(message + (e == null ? "" : " (" + e.getMessage() + ")"));
        }
    }

    public final void logError(String message) {
        this.logError(message, null);
    }

    public final void logError(String message, Exception e) {
        if (this.server != null) {
            this.server.srv.logError(message, e);
        } else {
            System.err.println(message + (e == null ? "" : " (" + e.getMessage() + ")"));
        }
    }

    public final void logInfo(String message) {
        this.logInfo(message, null);
    }

    public final void logInfo(String message, Exception e) {
        if (this.server != null) {
            this.server.srv.logInfo(message + (e == null ? "" : " (" + e.getMessage() + ")"));
        } else {
            System.out.println(message + (e == null ? "" : " (" + e.getMessage() + ")"));
        }
    }

    public final void logWarn(String message) {
        this.logWarn(message, null);
    }

    public final void logWarn(String message, Exception e) {
        if (this.server != null) {
            this.server.srv.logWarn(message + (e == null ? "" : " (" + e.getMessage() + ")"));
        } else {
            System.err.println(message + (e == null ? "" : " (" + e.getMessage() + ")"));
        }
    }

    public abstract void markMessage(OutboundMessage var1) throws Exception;

    public void markMessages(Collection<OutboundMessage> msgList) throws Exception {
        for (OutboundMessage msg : msgList) {
            this.markMessage(msg);
        }
    }

    public abstract void MessagesReceived(Collection<InboundMessage> var1) throws Exception;

    public abstract void start() throws Exception;

    public abstract void stop() throws Exception;

    protected Service getService() {
        return this.server.srv;
    }

    public static enum InterfaceTypes {
        INBOUND,
        OUTBOUND,
        INOUTBOUND;

    }
}

