/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.modem.athandler;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.smslib.AGateway;
import org.smslib.GatewayException;
import org.smslib.TimeoutException;
import org.smslib.modem.CNMIDetector;
import org.smslib.modem.ModemGateway;
import org.smslib.modem.athandler.ATHandler;

public class ATHandler_Telit
extends ATHandler {
    public ATHandler_Telit(ModemGateway gateway) {
        super(gateway);
        System.out.println("TELIT AT-HANDLER! ");
    }

    @Override
    public boolean setIndications() throws TimeoutException, GatewayException, IOException, InterruptedException {
        while (true) {
            this.modemDriver.write("AT+CNMI=?\r");
            try {
                CNMIDetector c = new CNMIDetector(this.modemDriver.getResponse(), this.gateway);
                this.modemDriver.write(c.getATCommand());
                this.modemDriver.getResponse();
                this.modemDriver.write("AT#STIA=1\r");
                this.modemDriver.getResponse();
                return this.modemDriver.isOk();
            }
            catch (Exception e) {
                this.gateway.logWarn("Retrying the detection of CNMI, modem busy?", e);
                Thread.sleep(this.gateway.getService().S.AT_WAIT_CNMI);
                continue;
            }
            break;
        }
    }

    @Override
    public int sendMessage(int size, String pdu, String phone, String text) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int refNo;
        block14: {
            refNo = -1;
            this.modemDriver.write("AT#STIA=0\r");
            this.modemDriver.getResponse();
            if (this.gateway.getProtocol() == AGateway.Protocols.PDU) {
                int errorRetries = 0;
                while (true) {
                    int responseRetries = 0;
                    this.modemDriver.write("AT+CMGS=\"_1_\"\r".replaceAll("\"_1_\"", "" + size));
                    Thread.sleep(this.gateway.getService().S.AT_WAIT_CGMS);
                    while (!this.modemDriver.dataAvailable()) {
                        if (++responseRetries == this.gateway.getService().S.OUTBOUND_RETRIES) {
                            throw new GatewayException("Gateway is not responding, max number of retries reached.");
                        }
                        this.gateway.logWarn("ATHandler().SendMessage(): Still waiting for response (I) (" + responseRetries + ")...");
                        Thread.sleep(this.gateway.getService().S.OUTBOUND_RETRY_WAIT);
                    }
                    responseRetries = 0;
                    this.modemDriver.clearBuffer();
                    this.modemDriver.write(pdu);
                    this.modemDriver.write('\u001a');
                    String response = this.modemDriver.getResponse();
                    while (response.length() == 0) {
                        if (++responseRetries == this.gateway.getService().S.OUTBOUND_RETRIES) {
                            throw new GatewayException("Gateway is not responding, max number of retries reached.");
                        }
                        this.gateway.logWarn("ATHandler().SendMessage(): Still waiting for response (II) (" + responseRetries + ")...");
                        Thread.sleep(this.gateway.getService().S.OUTBOUND_RETRY_WAIT);
                        response = this.modemDriver.getResponse();
                    }
                    if (this.modemDriver.getLastError() == 0) {
                        Matcher m = Pattern.compile("\\s*\\+CMGS: *(\\d+)").matcher(response);
                        refNo = m.find() ? Integer.parseInt(m.group(1)) : -1;
                        break block14;
                    }
                    if (this.modemDriver.getLastError() > 0) {
                        if (++errorRetries == this.gateway.getService().S.OUTBOUND_RETRIES) {
                            this.gateway.logError(this.modemDriver.getLastErrorText() + ": Quit retrying, message lost...");
                            refNo = -1;
                            break block14;
                        }
                        this.gateway.logWarn(this.modemDriver.getLastErrorText() + ": Retrying...");
                        Thread.sleep(this.gateway.getService().S.OUTBOUND_RETRY_WAIT);
                        continue;
                    }
                    refNo = -1;
                }
            }
            if (this.gateway.getProtocol() == AGateway.Protocols.TEXT) {
                this.modemDriver.write("AT+CMGS=\"_1_\"\r".replaceAll("_1_", phone));
                this.modemDriver.clearBuffer();
                this.modemDriver.write(text);
                Thread.sleep(this.gateway.getService().S.AT_WAIT_CGMS);
                this.modemDriver.write('\u001a');
                String response = this.modemDriver.getResponse();
                if (response.indexOf("OK\r") >= 0) {
                    String tmp = "";
                    int i = response.indexOf(":");
                    while (!Character.isDigit(response.charAt(i))) {
                        ++i;
                    }
                    while (Character.isDigit(response.charAt(i))) {
                        tmp = tmp + response.charAt(i);
                        ++i;
                    }
                    refNo = Integer.parseInt(tmp);
                } else {
                    refNo = -1;
                }
            }
        }
        return refNo;
    }
}

