/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.modem.athandler;

import java.io.IOException;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.smslib.AGateway;
import org.smslib.GatewayException;
import org.smslib.InboundMessage;
import org.smslib.TimeoutException;
import org.smslib.modem.AModemDriver;
import org.smslib.modem.CNMIDetector;
import org.smslib.modem.ModemGateway;
import org.smslib.modem.athandler.AATHandler;

public class ATHandler
extends AATHandler {
    protected AModemDriver modemDriver;

    public ATHandler(ModemGateway gateway) {
        super(gateway);
        this.modemDriver = gateway.getModemDriver();
        this.terminators = new String[13];
        this.terminators[0] = "OK\\s";
        this.terminators[1] = "\\s*[\\p{ASCII}]*\\s+OK\\s";
        this.terminators[2] = "ERROR\\s";
        this.terminators[3] = "ERROR:\\s*\\d+\\s";
        this.terminators[4] = "\\+CM[ES]\\s+ERROR:\\s*\\d+\\s";
        this.terminators[5] = "\\+CPIN:\\s*READY\\s";
        this.terminators[6] = "\\+CPIN:\\s*SIM\\s*BUSY\\s";
        this.terminators[7] = "\\+CPIN:\\s*SIM\\s*PIN\\s";
        this.terminators[8] = "\\+CPIN:\\s*SIM\\s*PIN2\\s";
        this.terminators[9] = "\\+CMTI:\\s*\\p{Punct}[\\p{ASCII}]+\\p{Punct}\\p{Punct}\\s*\\d+\\s";
        this.terminators[10] = "\\+CDSI:\\s*\\p{Punct}[\\p{ASCII}]+\\p{Punct}\\p{Punct}\\s*\\d+\\s";
        this.terminators[11] = "RING\\s";
        this.terminators[12] = "\\+CLIP:\\s*\\p{Punct}[\\p{ASCII}]*\\p{Punct}\\p{Punct}\\s*\\d+[\\p{ASCII}]*\\s";
    }

    @Override
    public void sync() throws IOException, InterruptedException {
        this.modemDriver.write("ATZ\r");
        Thread.sleep(this.gateway.getService().S.AT_WAIT);
    }

    @Override
    public void reset() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.modemDriver.write("\u001b");
        Thread.sleep(this.gateway.getService().S.AT_WAIT);
        this.modemDriver.write("+++");
        Thread.sleep(this.gateway.getService().S.AT_WAIT);
        this.modemDriver.write("ATZ");
        Thread.sleep(this.gateway.getService().S.AT_WAIT);
        this.modemDriver.clearBuffer();
    }

    @Override
    public void echoOff() throws IOException, InterruptedException {
        this.modemDriver.write("ATE0\r");
        Thread.sleep(this.gateway.getService().S.AT_WAIT);
        this.modemDriver.clearBuffer();
    }

    @Override
    public void init() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.modemDriver.write("AT+CLIP=1\r");
        this.modemDriver.getResponse();
        this.modemDriver.write("AT+COPS=0\r");
        this.modemDriver.getResponse();
    }

    @Override
    public boolean isAlive() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.modemDriver.write("AT\r");
        this.modemDriver.getResponse();
        return this.modemDriver.isOk();
    }

    @Override
    public String getSimStatus() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.modemDriver.write("AT+CPIN?\r");
        return this.modemDriver.getResponse();
    }

    @Override
    public boolean enterPin(String pin) throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.modemDriver.write("AT+CPIN=\"_1_\"\r".replaceAll("_1_", pin));
        this.modemDriver.getResponse();
        return this.modemDriver.isOk();
    }

    @Override
    public boolean setVerboseErrors() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.modemDriver.write("AT+CMEE=1\r");
        this.modemDriver.getResponse();
        return this.modemDriver.isOk();
    }

    @Override
    public boolean setPduProtocol() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.modemDriver.write("AT+CMGF=0\r");
        this.modemDriver.getResponse();
        return this.modemDriver.isOk();
    }

    @Override
    public boolean setTextProtocol() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.modemDriver.write("AT+CMGF=1\r");
        this.modemDriver.getResponse();
        return this.modemDriver.isOk();
    }

    @Override
    public boolean setIndications() throws TimeoutException, GatewayException, IOException, InterruptedException {
        while (true) {
            this.modemDriver.write("AT+CNMI=?\r");
            try {
                CNMIDetector c = new CNMIDetector(this.modemDriver.getResponse(), this.gateway);
                this.modemDriver.write(c.getATCommand());
                this.modemDriver.getResponse();
                return this.modemDriver.isOk();
            }
            catch (Exception e) {
                this.gateway.logWarn("Retrying the detection of CNMI, modem busy?", e);
                Thread.sleep(this.gateway.getService().S.AT_WAIT_CNMI);
                continue;
            }
            break;
        }
    }

    @Override
    public String getManufacturer() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.modemDriver.write("AT+CGMI\r");
        return this.modemDriver.getResponse();
    }

    @Override
    public String getModel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.modemDriver.write("AT+CGMM\r");
        return this.modemDriver.getResponse();
    }

    @Override
    public String getSerialNo() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.modemDriver.write("AT+CGSN\r");
        return this.modemDriver.getResponse();
    }

    @Override
    public String getImsi() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.modemDriver.write("AT+CIMI\r");
        return this.modemDriver.getResponse();
    }

    @Override
    public String getSwVersion() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.modemDriver.write("AT+CGMR\r");
        return this.modemDriver.getResponse();
    }

    @Override
    public String getBatteryLevel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.modemDriver.write("AT+CBC\r");
        return this.modemDriver.getResponse();
    }

    @Override
    public String getSignalLevel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.modemDriver.write("AT+CSQ\r");
        return this.modemDriver.getResponse();
    }

    @Override
    public boolean setStorageLocation(String mem) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (mem.equalsIgnoreCase("--")) {
            return true;
        }
        this.modemDriver.write("AT+CPMS=\"" + mem + "\"\r");
        this.modemDriver.getResponse();
        return this.modemDriver.isOk();
    }

    @Override
    public void switchToCmdMode() throws IOException {
        this.modemDriver.write("+++");
        Date start = new Date();
        while (new Date().getTime() - start.getTime() <= (long)this.gateway.getService().S.AT_WAIT_CMD) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public boolean keepGsmLinkOpen() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.modemDriver.write("AT+CMMS=1\r");
        this.modemDriver.getResponse();
        return this.modemDriver.isOk();
    }

    @Override
    public int sendMessage(int size, String pdu, String phone, String text) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int refNo;
        block14: {
            refNo = -1;
            if (this.gateway.getProtocol() == AGateway.Protocols.PDU) {
                int errorRetries = 0;
                while (true) {
                    int responseRetries = 0;
                    this.modemDriver.write("AT+CMGS=\"_1_\"\r".replaceAll("\"_1_\"", "" + size));
                    Thread.sleep(this.gateway.getService().S.AT_WAIT_CGMS);
                    while (!this.modemDriver.dataAvailable()) {
                        if (++responseRetries == this.gateway.getService().S.OUTBOUND_RETRIES) {
                            throw new GatewayException("Gateway is not responding, max number of retries reached.");
                        }
                        this.gateway.logWarn("ATHandler().SendMessage(): Still waiting for response (I) (" + responseRetries + ")...");
                        Thread.sleep(this.gateway.getService().S.OUTBOUND_RETRY_WAIT);
                    }
                    responseRetries = 0;
                    this.modemDriver.clearBuffer();
                    this.modemDriver.write(pdu);
                    this.modemDriver.write('\u001a');
                    String response = this.modemDriver.getResponse();
                    while (response.length() == 0) {
                        if (++responseRetries == this.gateway.getService().S.OUTBOUND_RETRIES) {
                            throw new GatewayException("Gateway is not responding, max number of retries reached.");
                        }
                        this.gateway.logWarn("ATHandler().SendMessage(): Still waiting for response (II) (" + responseRetries + ")...");
                        Thread.sleep(this.gateway.getService().S.OUTBOUND_RETRY_WAIT);
                        response = this.modemDriver.getResponse();
                    }
                    if (this.modemDriver.getLastError() == 0) {
                        Matcher m = Pattern.compile("\\s*\\+CMGS: *(\\d+)").matcher(response);
                        refNo = m.find() ? Integer.parseInt(m.group(1)) : -1;
                        break block14;
                    }
                    if (this.modemDriver.getLastError() > 0) {
                        if (++errorRetries == this.gateway.getService().S.OUTBOUND_RETRIES) {
                            this.gateway.logError(this.modemDriver.getLastErrorText() + ": Quit retrying, message lost...");
                            refNo = -1;
                            break block14;
                        }
                        this.gateway.logWarn(this.modemDriver.getLastErrorText() + ": Retrying...");
                        Thread.sleep(this.gateway.getService().S.OUTBOUND_RETRY_WAIT);
                        continue;
                    }
                    refNo = -1;
                }
            }
            if (this.gateway.getProtocol() == AGateway.Protocols.TEXT) {
                this.modemDriver.write("AT+CMGS=\"_1_\"\r".replaceAll("_1_", phone));
                this.modemDriver.clearBuffer();
                this.modemDriver.write(text);
                Thread.sleep(this.gateway.getService().S.AT_WAIT_CGMS);
                this.modemDriver.write('\u001a');
                String response = this.modemDriver.getResponse();
                if (response.indexOf("OK\r") >= 0) {
                    String tmp = "";
                    int i = response.indexOf(":");
                    while (!Character.isDigit(response.charAt(i))) {
                        ++i;
                    }
                    while (Character.isDigit(response.charAt(i))) {
                        tmp = tmp + response.charAt(i);
                        ++i;
                    }
                    refNo = Integer.parseInt(tmp);
                } else {
                    refNo = -1;
                }
            }
        }
        return refNo;
    }

    @Override
    public String listMessages(InboundMessage.MessageClasses messageClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.gateway.getProtocol() == AGateway.Protocols.PDU) {
            if (messageClass == InboundMessage.MessageClasses.ALL) {
                this.modemDriver.write("AT+CMGL=4\r");
            } else if (messageClass == InboundMessage.MessageClasses.UNREAD) {
                this.modemDriver.write("AT+CMGL=0\r");
            } else if (messageClass == InboundMessage.MessageClasses.READ) {
                this.modemDriver.write("AT+CMGL=1\r");
            }
        } else if (this.gateway.getProtocol() == AGateway.Protocols.TEXT) {
            if (messageClass == InboundMessage.MessageClasses.ALL) {
                this.modemDriver.write("AT+CMGL=\"ALL\"\r");
            } else if (messageClass == InboundMessage.MessageClasses.UNREAD) {
                this.modemDriver.write("AT+CMGL=\"REC UNREAD\"\r");
            } else if (messageClass == InboundMessage.MessageClasses.READ) {
                this.modemDriver.write("AT+CMGL=\"REC READ\"\r");
            }
        }
        return this.modemDriver.getResponse();
    }

    @Override
    public boolean deleteMessage(int memIndex, String memLocation) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (!this.setStorageLocation(memLocation)) {
            return false;
        }
        this.modemDriver.write("AT+CMGD=_1_\r".replaceAll("_1_", "" + memIndex));
        this.modemDriver.getResponse();
        return this.modemDriver.isOk();
    }

    @Override
    public String getGprsStatus() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.modemDriver.write("AT+CGATT?\r");
        return this.modemDriver.getResponse();
    }

    @Override
    public String send(String s) throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.modemDriver.write(s);
        return this.modemDriver.getResponse();
    }

    @Override
    public String getNetworkRegistration() throws GatewayException, TimeoutException, IOException {
        this.modemDriver.write("AT+CREG?\r");
        return this.modemDriver.getResponse();
    }

    @Override
    public void readStorageLocations() throws Exception {
        this.modemDriver.write("AT+CPMS?\r");
        String response = this.modemDriver.getResponse();
        if (response.indexOf("+CPMS:") >= 0) {
            response = response.replaceAll("\\s*\\+CPMS:\\s*", "");
            StringTokenizer tokens = new StringTokenizer(response, ",");
            while (tokens.hasMoreTokens()) {
                String loc = tokens.nextToken().replaceAll("\"", "");
                if (this.storageLocations.indexOf(loc) < 0) {
                    this.storageLocations = this.storageLocations + loc;
                }
                tokens.nextToken();
                tokens.nextToken();
            }
        }
    }

    @Override
    public AGateway.AsyncEvents processUnsolicitedEvents(String response) throws IOException {
        AGateway.AsyncEvents event = AGateway.AsyncEvents.NOTHING;
        if (response.indexOf("+CMTI") >= 0) {
            event = AGateway.AsyncEvents.INBOUNDMESSAGE;
        } else if (response.indexOf("+CDSI") >= 0) {
            event = AGateway.AsyncEvents.INBOUNDSTATUSREPORTMESSAGE;
        } else if (response.indexOf("RING") >= 0) {
            event = AGateway.AsyncEvents.NOTHING;
        } else if (response.indexOf("+CLIP") >= 0) {
            event = AGateway.AsyncEvents.INBOUNDCALL;
        }
        return event;
    }
}

