/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.modem;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.smslib.AGateway;
import org.smslib.GatewayException;
import org.smslib.InboundMessage;
import org.smslib.OutboundMessage;
import org.smslib.StatusReportMessage;
import org.smslib.TimeoutException;
import org.smslib.UnknownMessage;
import org.smslib.helper.GSMAlphabet;
import org.smslib.modem.AModemDriver;
import org.smslib.modem.IPModemDriver;
import org.smslib.modem.SerialModemDriver;
import org.smslib.modem.athandler.AATHandler;

public class ModemGateway
extends AGateway {
    private AModemDriver driver;
    private AATHandler atHandler;
    private String modemDevice;
    private int modemParms;
    private String manufacturer;
    private String model;
    private String simPin;
    private String simPin2;
    private int outMpRefNo;
    private List<List<InboundMessage>> mpMsgList;
    private String smscNumber;

    ModemGateway(ModemTypes type, String id, String modemDevice, int modemParms, String manufacturer, String model) {
        super(id);
        this.started = false;
        this.modemDevice = modemDevice;
        this.modemParms = modemParms;
        this.manufacturer = manufacturer;
        this.model = model;
        this.attributes = 251;
        this.driver = type == ModemTypes.SERIAL ? new SerialModemDriver(this, this.modemDevice + ":" + this.modemParms) : new IPModemDriver(this, this.modemDevice + ":" + this.modemParms);
        this.atHandler = AATHandler.load(this, this.manufacturer, this.model);
        this.simPin = "";
        this.simPin2 = "";
        this.outMpRefNo = new Random().nextInt();
        if (this.outMpRefNo < 0) {
            this.outMpRefNo *= -1;
        }
        this.outMpRefNo %= 65536;
        this.mpMsgList = new ArrayList<List<InboundMessage>>();
        this.smscNumber = "";
    }

    @Override
    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.logInfo("Starting gateway, using " + this.atHandler.getDescription() + " AT Handler.");
        this.driver.connect();
        super.startGateway();
        this.logInfo("Gateway started.");
    }

    @Override
    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.logInfo("Stopping gateway...");
        super.stopGateway();
        this.driver.disconnect();
        this.logInfo("Gateway stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readMessages(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.driver.SYNC_Commander;
        synchronized (object) {
            if (this.gatewayStatus != AGateway.GatewayStatuses.OK) {
                return;
            }
            if (this.protocol == AGateway.Protocols.PDU) {
                this.readMessagesPDU(msgList, msgClass, 0);
            } else if (this.protocol == AGateway.Protocols.TEXT) {
                this.readMessagesTEXT(msgList, msgClass, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InboundMessage readMessage(String memLoc, int memIndex) throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.driver.SYNC_Commander;
        synchronized (object) {
            if (this.gatewayStatus != AGateway.GatewayStatuses.OK) {
                return null;
            }
            ArrayList<InboundMessage> msgList = new ArrayList<InboundMessage>();
            this.readMessages(msgList, InboundMessage.MessageClasses.ALL);
            for (InboundMessage msg : msgList) {
                if (msg.getMemIndex() != memIndex || !msg.getMemLocation().equals(memLoc)) continue;
                return msg;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.driver.SYNC_Commander;
        synchronized (object) {
            if (this.gatewayStatus != AGateway.GatewayStatuses.OK) {
                return false;
            }
            if (this.protocol == AGateway.Protocols.PDU) {
                return this.sendMessagePDU(msg);
            }
            if (this.protocol == AGateway.Protocols.TEXT) {
                return this.sendMessageTEXT(msg);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteMessage(InboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.driver.SYNC_Commander;
        synchronized (object) {
            if (this.gatewayStatus != AGateway.GatewayStatuses.OK) {
                return false;
            }
            if (msg.getMemIndex() >= 0) {
                return this.deleteMessage(msg.getMemIndex(), msg.getMemLocation());
            }
            if (msg.getMemIndex() == -1 && msg.getMpMemIndex().length() != 0) {
                StringTokenizer tokens = new StringTokenizer(msg.getMpMemIndex(), ",");
                while (tokens.hasMoreTokens()) {
                    this.deleteMessage(Integer.parseInt(tokens.nextToken()), msg.getMemLocation());
                }
            }
            return true;
        }
    }

    private boolean deleteMessage(int memIndex, String memLocation) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.atHandler.deleteMessage(memIndex, memLocation);
    }

    private boolean sendMessagePDU(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        boolean ok = false;
        this.atHandler.keepGsmLinkOpen();
        if (!msg.isBig()) {
            String pdu = msg.getPDU(this.smscNumber, 0, 0);
            int j = pdu.length();
            j /= 2;
            if (this.smscNumber.length() == 0) {
                --j;
            } else if (this.smscNumber != null) {
                int smscNumberLen = this.smscNumber.length();
                if (this.smscNumber.charAt(0) == '+') {
                    --smscNumberLen;
                }
                if (smscNumberLen % 2 != 0) {
                    ++smscNumberLen;
                }
                int smscLen = (2 + smscNumberLen) / 2;
                j = j - smscLen - 1;
            }
            int refNo = this.atHandler.sendMessage(j, pdu, null, null);
            if (refNo >= 0) {
                msg.setGatewayId(this.gtwId);
                msg.setRefNo("" + refNo);
                msg.setDispatchDate(new Date());
                msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
                this.incOutboundMessageCount();
                ok = true;
            } else {
                msg.setRefNo(null);
                msg.setDispatchDate(null);
                msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                ok = false;
            }
        } else {
            for (int partNo = 1; partNo <= msg.getNoOfParts(); ++partNo) {
                String pdu = msg.getPDU(this.smscNumber, this.outMpRefNo, partNo);
                int j = pdu.length();
                j /= 2;
                if (this.smscNumber.length() == 0) {
                    --j;
                } else if (this.smscNumber != null) {
                    int smscNumberLen = this.smscNumber.length();
                    if (this.smscNumber.charAt(0) == '+') {
                        --smscNumberLen;
                    }
                    if (smscNumberLen % 2 != 0) {
                        ++smscNumberLen;
                    }
                    int smscLen = (2 + smscNumberLen) / 2;
                    j = j - smscLen - 1;
                }
                int refNo = this.atHandler.sendMessage(j, pdu, null, null);
                if (refNo >= 0) {
                    msg.setGatewayId(this.gtwId);
                    msg.setRefNo("" + refNo);
                    msg.setDispatchDate(new Date());
                    msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
                    this.incOutboundMessageCount();
                    ok = true;
                    continue;
                }
                msg.setRefNo(null);
                msg.setDispatchDate(null);
                msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
            }
            this.outMpRefNo = (this.outMpRefNo + 1) % 65536;
        }
        return ok;
    }

    private boolean sendMessageTEXT(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        boolean ok = false;
        int refNo = this.atHandler.sendMessage(0, "", msg.getRecipient(), msg.getText());
        if (refNo >= 0) {
            msg.setGatewayId(this.gtwId);
            msg.setRefNo("" + refNo);
            msg.setDispatchDate(new Date());
            msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
            this.incOutboundMessageCount();
            ok = true;
        } else {
            msg.setRefNo(null);
            msg.setDispatchDate(null);
            msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
        }
        return ok;
    }

    private void readMessagesTEXT(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass, int limit) throws TimeoutException, GatewayException, IOException, InterruptedException {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        if (limit < 0) {
            limit = 0;
        }
        for (int ml = 0; ml < this.atHandler.getStorageLocations().length() / 2; ++ml) {
            String line;
            if (!this.atHandler.setStorageLocation(this.atHandler.getStorageLocations().substring(ml * 2, ml * 2 + 2))) continue;
            String response = this.atHandler.listMessages(msgClass);
            response = response.replaceAll("\\s+OK\\s+", "\nOK");
            BufferedReader reader = new BufferedReader(new StringReader(response));
            while ((line = reader.readLine().trim()) != null && (line = line.trim()).length() <= 0) {
            }
            while (line != null && (line = line.trim()).length() > 0 && !line.equalsIgnoreCase("OK")) {
                InboundMessage msg;
                String dateStr;
                int i = line.indexOf(58);
                int j = line.indexOf(44);
                int memIndex = Integer.parseInt(line.substring(i + 1, j).trim());
                StringTokenizer tokens = new StringTokenizer(line, ",");
                tokens.nextToken();
                tokens.nextToken();
                if (Character.isDigit(tokens.nextToken().trim().charAt(0))) {
                    line = line.replaceAll(",,", ", ,");
                    tokens = new StringTokenizer(line, ",");
                    tokens.nextToken();
                    tokens.nextToken();
                    tokens.nextToken();
                    String refNo = tokens.nextToken();
                    tokens.nextToken();
                    dateStr = tokens.nextToken().replaceAll("\"", "");
                    cal1.set(1, 2000 + Integer.parseInt(dateStr.substring(0, 2)));
                    cal1.set(2, Integer.parseInt(dateStr.substring(3, 5)) - 1);
                    cal1.set(5, Integer.parseInt(dateStr.substring(6, 8)));
                    dateStr = tokens.nextToken().replaceAll("\"", "");
                    cal1.set(11, Integer.parseInt(dateStr.substring(0, 2)));
                    cal1.set(12, Integer.parseInt(dateStr.substring(3, 5)));
                    cal1.set(13, Integer.parseInt(dateStr.substring(6, 8)));
                    dateStr = tokens.nextToken().replaceAll("\"", "");
                    cal2.set(1, 2000 + Integer.parseInt(dateStr.substring(0, 2)));
                    cal2.set(2, Integer.parseInt(dateStr.substring(3, 5)) - 1);
                    cal2.set(5, Integer.parseInt(dateStr.substring(6, 8)));
                    dateStr = tokens.nextToken().replaceAll("\"", "");
                    cal2.set(11, Integer.parseInt(dateStr.substring(0, 2)));
                    cal2.set(12, Integer.parseInt(dateStr.substring(3, 5)));
                    cal2.set(13, Integer.parseInt(dateStr.substring(6, 8)));
                    msg = new StatusReportMessage(refNo, memIndex, this.atHandler.getStorageLocations().substring(ml * 2, ml * 2 + 2), cal1.getTime(), cal2.getTime());
                    msg.setGatewayId(this.gtwId);
                    this.logDebug("IN-DTLS: MI:" + msg.getMemIndex());
                    msgList.add(msg);
                    this.incInboundMessageCount();
                } else {
                    line = line.replaceAll(",,", ", ,");
                    tokens = new StringTokenizer(line, ",");
                    tokens.nextToken();
                    tokens.nextToken();
                    String originator = tokens.nextToken().replaceAll("\"", "");
                    tokens.nextToken();
                    dateStr = tokens.nextToken().replaceAll("\"", "");
                    cal1.set(1, 2000 + Integer.parseInt(dateStr.substring(0, 2)));
                    cal1.set(2, Integer.parseInt(dateStr.substring(3, 5)) - 1);
                    cal1.set(5, Integer.parseInt(dateStr.substring(6, 8)));
                    dateStr = tokens.nextToken().replaceAll("\"", "");
                    cal1.set(11, Integer.parseInt(dateStr.substring(0, 2)));
                    cal1.set(12, Integer.parseInt(dateStr.substring(3, 5)));
                    cal1.set(13, Integer.parseInt(dateStr.substring(6, 8)));
                    String msgText = reader.readLine().trim();
                    byte[] bytes = new byte[msgText.length() / 2];
                    j = 0;
                    for (i = 0; i < msgText.length(); i += 2) {
                        bytes[j] = Byte.parseByte(msgText.substring(i, i + 2), 16);
                        ++j;
                    }
                    msgText = GSMAlphabet.bytesToString(bytes);
                    msg = new InboundMessage(cal1.getTime(), originator, msgText, memIndex, this.atHandler.getStorageLocations().substring(ml * 2, ml * 2 + 2));
                    msg.setGatewayId(this.gtwId);
                    this.logDebug("IN-DTLS: MI:" + msg.getMemIndex());
                    msgList.add(msg);
                    this.incInboundMessageCount();
                }
                line = reader.readLine().trim();
                while (line.length() == 0) {
                    line = reader.readLine().trim();
                }
            }
            reader.close();
        }
    }

    private void readMessagesPDU(Collection<InboundMessage> msgList, InboundMessage.MessageClasses messageClass, int limit) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (limit < 0) {
            limit = 0;
        }
        for (int ml = 0; ml < this.atHandler.getStorageLocations().length() / 2; ++ml) {
            String line;
            if (!this.atHandler.setStorageLocation(this.atHandler.getStorageLocations().substring(ml * 2, ml * 2 + 2))) continue;
            String response = this.atHandler.listMessages(messageClass);
            response = response.replaceAll("\\s+OK\\s+", "\nOK");
            BufferedReader reader = new BufferedReader(new StringReader(response));
            while ((line = reader.readLine().trim()) != null && (line = line.trim()).length() <= 0) {
            }
            while (line != null && (line = line.trim()).length() > 0 && !line.equalsIgnoreCase("OK")) {
                int i = line.indexOf(58);
                int j = line.indexOf(44);
                int memIndex = Integer.parseInt(line.substring(i + 1, j).trim());
                String pdu = reader.readLine().trim();
                try {
                    InboundMessage msg;
                    if (this.isInboundMessage(pdu)) {
                        msg = new InboundMessage(pdu, memIndex, this.atHandler.getStorageLocations().substring(ml * 2, ml * 2 + 2));
                        msg.setGatewayId(this.gtwId);
                        this.logDebug("IN-DTLS: MI:" + msg.getMemIndex() + " REF:" + msg.getMpRefNo() + " MAX:" + msg.getMpMaxNo() + " SEQ:" + msg.getMpSeqNo());
                        if (msg.getMpRefNo() == 0) {
                            msgList.add(msg);
                            this.incInboundMessageCount();
                        } else {
                            List<InboundMessage> tmpList;
                            boolean found = false;
                            for (int k = 0; k < this.mpMsgList.size(); ++k) {
                                tmpList = this.mpMsgList.get(k);
                                InboundMessage listMsg = tmpList.get(0);
                                if (listMsg.getMpRefNo() != msg.getMpRefNo()) continue;
                                boolean duplicate = false;
                                for (int l = 0; l < tmpList.size(); ++l) {
                                    listMsg = tmpList.get(l);
                                    if (listMsg.getMpSeqNo() != msg.getMpSeqNo()) continue;
                                    duplicate = true;
                                    break;
                                }
                                if (!duplicate) {
                                    tmpList.add(msg);
                                }
                                found = true;
                                break;
                            }
                            if (!found) {
                                tmpList = new ArrayList<InboundMessage>();
                                tmpList.add(msg);
                                this.mpMsgList.add(tmpList);
                            }
                        }
                    } else if (this.isStatusReportMessage(pdu)) {
                        msg = new StatusReportMessage(pdu, memIndex, this.atHandler.getStorageLocations().substring(ml * 2, ml * 2 + 2));
                        msg.setGatewayId(this.gtwId);
                        msgList.add(msg);
                        this.incInboundMessageCount();
                    } else {
                        msg = new UnknownMessage(pdu, memIndex, this.atHandler.getStorageLocations().substring(ml * 2, ml * 2 + 2));
                        msg.setGatewayId(this.gtwId);
                        msgList.add(msg);
                        this.incInboundMessageCount();
                    }
                }
                catch (Exception e) {
                    UnknownMessage msg = new UnknownMessage(pdu, memIndex, this.atHandler.getStorageLocations().substring(ml * 2, ml * 2 + 2));
                    msg.setGatewayId(this.gtwId);
                    msgList.add(msg);
                    this.incInboundMessageCount();
                    this.logError("Unhandled SMS in inbox, skipping...", e);
                }
                line = reader.readLine().trim();
                while (line.length() == 0) {
                    line = reader.readLine().trim();
                }
                if (limit <= 0 || msgList.size() != limit) continue;
            }
            reader.close();
        }
        this.checkMpMsgList(msgList);
    }

    private void checkMpMsgList(Collection<InboundMessage> msgList) {
        InboundMessage mpMsg = null;
        this.logDebug("CheckMpMsgList(): MAINLIST: " + this.mpMsgList.size());
        for (int k = 0; k < this.mpMsgList.size(); ++k) {
            List<InboundMessage> tmpList = this.mpMsgList.get(k);
            this.logDebug("CheckMpMsgList(): SUBLIST[" + k + "]: " + tmpList.size());
            InboundMessage listMsg = tmpList.get(0);
            boolean found = false;
            if (listMsg.getMpMaxNo() == tmpList.size()) {
                found = true;
                block1: for (int l = 0; l < tmpList.size(); ++l) {
                    for (int m = 0; m < tmpList.size(); ++m) {
                        listMsg = tmpList.get(m);
                        if (listMsg.getMpSeqNo() != l + 1) continue;
                        if (listMsg.getMpSeqNo() == 1) {
                            mpMsg = listMsg;
                            mpMsg.setMpMemIndex(mpMsg.getMemIndex());
                            continue block1;
                        }
                        if (mpMsg == null) continue block1;
                        mpMsg.addText(listMsg.getText());
                        mpMsg.addPduUserData(listMsg.getPduUserData());
                        mpMsg.setMpSeqNo(listMsg.getMpSeqNo());
                        mpMsg.setMpMemIndex(listMsg.getMemIndex());
                        if (listMsg.getMpSeqNo() != listMsg.getMpMaxNo()) continue block1;
                        mpMsg.setMemIndex(-1);
                        msgList.add(mpMsg);
                        this.incInboundMessageCount();
                        mpMsg = null;
                        continue block1;
                    }
                }
                tmpList.clear();
                tmpList = null;
            }
            if (!found) continue;
            this.mpMsgList.remove(k);
            --k;
        }
    }

    private boolean isInboundMessage(String pdu) {
        int i = Integer.parseInt(pdu.substring(0, 2), 16);
        int index = (i + 1) * 2;
        return ((i = Integer.parseInt(pdu.substring(index, index + 2), 16)) & 3) == 0;
    }

    private boolean isStatusReportMessage(String pdu) {
        int i = Integer.parseInt(pdu.substring(0, 2), 16);
        int index = (i + 1) * 2;
        return ((i = Integer.parseInt(pdu.substring(index, index + 2), 16)) & 2) == 2;
    }

    public void setSimPin(String simPin) {
        this.simPin = simPin;
    }

    public void setSimPin2(String simPin) {
        this.simPin2 = simPin;
    }

    public String getSimPin() {
        return this.simPin;
    }

    public String getSimPin2() {
        return this.simPin2;
    }

    public AModemDriver getModemDriver() {
        return this.driver;
    }

    protected AATHandler getATHandler() {
        return this.atHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getManufacturer() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.driver.SYNC_Commander;
        synchronized (object) {
            String response = this.atHandler.getManufacturer();
            if (response.indexOf("ERROR") >= 0) {
                return "N/A";
            }
            response = response.replaceAll("\\s+OK\\s+", "");
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.driver.SYNC_Commander;
        synchronized (object) {
            String response = this.atHandler.getModel();
            if (response.indexOf("ERROR") >= 0) {
                return "N/A";
            }
            response = response.replaceAll("\\s+OK\\s+", "");
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSerialNo() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.driver.SYNC_Commander;
        synchronized (object) {
            String response = this.atHandler.getSerialNo();
            if (response.indexOf("ERROR") >= 0) {
                return "N/A";
            }
            response = response.replaceAll("\\s+OK\\s+", "");
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImsi() throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.srv.S.MASK_IMSI) {
            return "** MASKED **";
        }
        Object object = this.driver.SYNC_Commander;
        synchronized (object) {
            String response = this.atHandler.getImsi();
            if (response.indexOf("ERROR") >= 0) {
                return "N/A";
            }
            response = response.replaceAll("\\s+OK\\s+", "");
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSwVersion() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.driver.SYNC_Commander;
        synchronized (object) {
            String response = this.atHandler.getSwVersion();
            if (response.indexOf("ERROR") >= 0) {
                return "N/A";
            }
            response = response.replaceAll("\\s+OK\\s+", "");
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getGprsStatus() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.driver.SYNC_Commander;
        synchronized (object) {
            return this.atHandler.getGprsStatus().matches("\\+CGATT[\\p{ASCII}]*1\\sOK\\s");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBatteryLevel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.driver.SYNC_Commander;
        synchronized (object) {
            String response = this.atHandler.getBatteryLevel();
            if (response.indexOf("ERROR") >= 0) {
                return 0;
            }
            Matcher m = Pattern.compile("\\+CBC: (\\d+),\\s*(\\d+)").matcher(response);
            if (m.find()) {
                return Integer.parseInt(m.group(2));
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSignalLevel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.driver.SYNC_Commander;
        synchronized (object) {
            String response = this.atHandler.getSignalLevel();
            if (response.indexOf("ERROR") >= 0) {
                return 0;
            }
            response = response.replaceAll("\\s+OK\\s+", "");
            StringTokenizer tokens = new StringTokenizer(response, ":,");
            tokens.nextToken();
            return Integer.parseInt(tokens.nextToken().trim()) * 100 / 31;
        }
    }

    public String getSmscNumber() {
        return this.smscNumber;
    }

    public void setSmscNumber(String smscNumber) {
        this.smscNumber = smscNumber;
    }

    public static enum ModemTypes {
        SERIAL,
        IP;

    }
}

