/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.helper;

import java.util.BitSet;

public class GSMAlphabet {
    static final char[][] grcAlphabetRemapping = new char[][]{{'\u0386', 'A'}, {'\u0388', 'E'}, {'\u0389', 'H'}, {'\u038a', 'I'}, {'\u038c', 'O'}, {'\u038e', 'Y'}, {'\u038f', '\u03a9'}, {'\u0390', 'I'}, {'\u0391', 'A'}, {'\u0392', 'B'}, {'\u0393', '\u0393'}, {'\u0394', '\u0394'}, {'\u0395', 'E'}, {'\u0396', 'Z'}, {'\u0397', 'H'}, {'\u0398', '\u0398'}, {'\u0399', 'I'}, {'\u039a', 'K'}, {'\u039b', '\u039b'}, {'\u039c', 'M'}, {'\u039d', 'N'}, {'\u039e', '\u039e'}, {'\u039f', 'O'}, {'\u03a0', '\u03a0'}, {'\u03a1', 'P'}, {'\u03a3', '\u03a3'}, {'\u03a4', 'T'}, {'\u03a5', 'Y'}, {'\u03a6', '\u03a6'}, {'\u03a7', 'X'}, {'\u03a8', '\u03a8'}, {'\u03a9', '\u03a9'}, {'\u03aa', 'I'}, {'\u03ab', 'Y'}, {'\u03ac', 'A'}, {'\u03ad', 'E'}, {'\u03ae', 'H'}, {'\u03af', 'I'}, {'\u03b0', 'Y'}, {'\u03b1', 'A'}, {'\u03b2', 'B'}, {'\u03b3', '\u0393'}, {'\u03b4', '\u0394'}, {'\u03b5', 'E'}, {'\u03b6', 'Z'}, {'\u03b7', 'H'}, {'\u03b8', '\u0398'}, {'\u03b9', 'I'}, {'\u03ba', 'K'}, {'\u03bb', '\u039b'}, {'\u03bc', 'M'}, {'\u03bd', 'N'}, {'\u03be', '\u039e'}, {'\u03bf', 'O'}, {'\u03c0', '\u03a0'}, {'\u03c1', 'P'}, {'\u03c2', '\u03a3'}, {'\u03c3', '\u03a3'}, {'\u03c4', 'T'}, {'\u03c5', 'Y'}, {'\u03c6', '\u03a6'}, {'\u03c7', 'X'}, {'\u03c8', '\u03a8'}, {'\u03c9', '\u03a9'}, {'\u03ca', 'I'}, {'\u03cb', 'Y'}, {'\u03cc', 'O'}, {'\u03cd', 'Y'}, {'\u03ce', '\u03a9'}};
    static final char[] extAlphabet = new char[]{'\f', '^', '{', '}', '\\', '[', '~', ']', '|', '\u20ac'};
    static final String[] extBytes = new String[]{"1b0a", "1b14", "1b28", "1b29", "1b2f", "1b3c", "1b3d", "1b3e", "1b40", "1b65"};
    static final char[] stdAlphabet = new char[]{'@', '\u00a3', '$', '\u00a5', '\u00e8', '\u00e9', '\u00f9', '\u00ec', '\u00f2', '\u00e7', '\n', '\u00d8', '\u00f8', '\r', '\u00c5', '\u00e5', '\u0394', '_', '\u03a6', '\u0393', '\u039b', '\u03a9', '\u03a0', '\u03a8', '\u03a3', '\u0398', '\u039e', '\u00a0', '\u00c6', '\u00e6', '\u00df', '\u00c9', ' ', '!', '\"', '#', '\u00a4', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '\u00a1', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c4', '\u00d6', '\u00d1', '\u00dc', '\u00a7', '\u00bf', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00e4', '\u00f6', '\u00f1', '\u00fc', '\u00e0'};

    public static String bytesToString(byte[] bytes) {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == 27) {
                String extChar = "1b" + Integer.toHexString(bytes[++i]);
                for (int j = 0; j < extBytes.length; ++j) {
                    if (!extBytes[j].equalsIgnoreCase(extChar)) continue;
                    text.append(extAlphabet[j]);
                }
                continue;
            }
            text.append(stdAlphabet[bytes[i]]);
        }
        return text.toString();
    }

    public static int stringToBytes(String text, byte[] bytes) {
        int k = 0;
        block0: for (int i = 0; i < text.length(); ++i) {
            int j;
            char ch = text.charAt(i);
            int index = -1;
            for (j = 0; j < extAlphabet.length; ++j) {
                if (extAlphabet[j] != ch) continue;
                index = j;
                break;
            }
            if (index != -1) {
                bytes[k] = (byte)Integer.parseInt(extBytes[index].substring(0, 2), 16);
                bytes[++k] = (byte)Integer.parseInt(extBytes[index].substring(2, 4), 16);
                ++k;
                continue;
            }
            index = -1;
            for (j = 0; j < stdAlphabet.length; ++j) {
                if (stdAlphabet[j] != ch) continue;
                index = j;
                bytes[k] = (byte)j;
                ++k;
                break;
            }
            if (index != -1) continue;
            for (j = 0; j < grcAlphabetRemapping.length; ++j) {
                if (grcAlphabetRemapping[j][0] != ch) continue;
                index = j;
                ch = grcAlphabetRemapping[j][1];
                break;
            }
            if (index != -1) {
                for (j = 0; j < stdAlphabet.length; ++j) {
                    if (stdAlphabet[j] != ch) continue;
                    index = j;
                    bytes[k] = (byte)j;
                    ++k;
                    continue block0;
                }
                continue;
            }
            bytes[k] = 32;
            ++k;
        }
        return k;
    }

    public static String textToPDU(String txt) {
        int j;
        int i;
        String pdu = "";
        byte[] txtBytes = new byte[txt.length() * 2];
        int txtBytesLen = GSMAlphabet.stringToBytes(txt, txtBytes);
        BitSet bits = new BitSet();
        for (i = 0; i < txtBytesLen; ++i) {
            for (j = 0; j < 7; ++j) {
                if ((txtBytes[i] & 1 << j) == 0) continue;
                bits.set(i * 7 + j);
            }
        }
        int txtSeptetsLen = (int)Math.ceil((double)(txtBytesLen * 7) / 8.0);
        short[] txtSeptets = new short[txtSeptetsLen];
        for (i = 0; i < txtSeptetsLen; ++i) {
            for (j = 0; j < 8; ++j) {
                int n = i;
                txtSeptets[n] = (short)(txtSeptets[n] | (short)((bits.get(i * 8 + j) ? 1 : 0) << j));
            }
        }
        for (i = 0; i < txtSeptetsLen; ++i) {
            String c = Integer.toHexString(txtSeptets[i]);
            if (c.length() < 2) {
                c = "0" + c;
            }
            pdu = pdu + c;
        }
        return pdu;
    }

    public static int noOfChars(String txt) {
        byte[] txtBytes = new byte[txt.length() * 2];
        return GSMAlphabet.stringToBytes(txt, txtBytes);
    }

    public static void main(String[] args) {
        String txt = "Testing...";
        System.out.println(txt);
        System.out.println(GSMAlphabet.textToPDU(txt));
    }
}

