/*
 * Decompiled with CFR 0.152.
 */
package org.smslib;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.smslib.InboundMessage;
import org.smslib.Message;

public class StatusReportMessage
extends InboundMessage {
    private static final long serialVersionUID = -1219480715074817278L;
    private String recipient;
    private Date sent;
    private Date received;
    private DeliveryStatuses status;
    private String refNo;

    public StatusReportMessage(String pdu, int memIndex, String memLocation) {
        super(Message.MessageTypes.STATUSREPORT, memIndex, memLocation);
        int i = Integer.parseInt(pdu.substring(0, 2), 16);
        int index = (i + 1) * 2;
        this.refNo = "" + Integer.parseInt(pdu.substring(index += 2, index + 2), 16);
        i = Integer.parseInt(pdu.substring(index += 2, index + 2), 16);
        int j = index + 4;
        this.recipient = "";
        for (int k = 0; k < i; k += 2) {
            this.recipient = this.recipient + pdu.charAt(j + k + 1) + pdu.charAt(j + k);
        }
        this.recipient = "+" + this.recipient;
        if (this.recipient.charAt(this.recipient.length() - 1) == 'F') {
            this.recipient = this.recipient.substring(0, this.recipient.length() - 1);
            ++i;
        }
        index = j + i;
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        String dateOctect = pdu.substring(index, index + 12);
        StringBuffer dateOk = new StringBuffer();
        for (int x = 0; x < 12; x += 2) {
            dateOk.append(new char[]{dateOctect.charAt(x + 1), dateOctect.charAt(x)});
        }
        try {
            this.sent = sdf.parse(dateOk.toString());
        }
        catch (ParseException e) {
            this.sent = null;
        }
        dateOctect = pdu.substring(index += 14, index + 12);
        dateOk = new StringBuffer();
        for (int x = 0; x < 12; x += 2) {
            dateOk.append(new char[]{dateOctect.charAt(x + 1), dateOctect.charAt(x)});
        }
        try {
            this.received = sdf.parse(dateOk.toString());
        }
        catch (ParseException e) {
            this.received = null;
        }
        i = Integer.parseInt(pdu.substring(index += 14, index + 2), 16);
        if ((i & 0x60) == 0) {
            this.setText("00 - Succesful Delivery.");
            this.status = DeliveryStatuses.DELIVERED;
        }
        if ((i & 0x20) == 32) {
            this.setText("01 - Errors, will retry dispatch.");
            this.status = DeliveryStatuses.KEEPTRYING;
        }
        if ((i & 0x40) == 64) {
            this.setText("02 - Errors, stopped retrying dispatch.");
            this.status = DeliveryStatuses.ABORTED;
        }
        if ((i & 0x60) == 96) {
            this.setText("03 - Errors, stopped retrying dispatch.");
            this.status = DeliveryStatuses.ABORTED;
        }
        this.setDate(null);
    }

    public StatusReportMessage(String refNo, int memIndex, String memLocation, Date dateOriginal, Date dateReceived) {
        super(Message.MessageTypes.STATUSREPORT, memIndex, memLocation);
        this.refNo = refNo;
        this.sent = dateOriginal;
        this.received = dateReceived;
        this.setText("");
        this.status = DeliveryStatuses.UNKNOWN;
        this.setDate(null);
    }

    public String getRecipient() {
        return this.recipient;
    }

    public Date getReceived() {
        return new Date(this.received.getTime());
    }

    public void setReceived(Date received) {
        this.received = received;
    }

    public Date getSent() {
        return new Date(this.sent.getTime());
    }

    public void setSent(Date sent) {
        this.sent = sent;
    }

    public DeliveryStatuses getStatus() {
        return this.status;
    }

    public void setStatus(DeliveryStatuses status) {
        this.status = status;
    }

    public String getRefNo() {
        return this.refNo;
    }

    public static enum DeliveryStatuses implements Serializable
    {
        UNKNOWN,
        DELIVERED,
        KEEPTRYING,
        ABORTED;

    }
}

