/*
 * Decompiled with CFR 0.152.
 */
package org.smslib;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Date;
import org.smslib.Message;
import org.smslib.OutboundMessage;
import org.smslib.SMSLibException;

public class OutboundWapSIMessage
extends OutboundMessage {
    private static final long serialVersionUID = -4652109048225090671L;
    private static final String PDU_PATTERN = "29060603AE81EA8DCA02056A0045C6_URL1_03_URL2_00080103_TEXT_000101";
    private String siPdu = "";
    protected URL url;
    protected Date createDate;
    protected Date expireDate;
    protected WapSISignals signal;
    private static final String[][] protocolBytes = new String[][]{{"http://www.", "0D"}, {"https://www.", "0F"}, {"http://", "0C"}, {"https://", "0E"}};
    private static final String[][] domainBytes = new String[][]{{".com/", "85"}, {".edu/", "86"}, {".net/", "87"}, {".org/", "88"}};

    public OutboundWapSIMessage(String recipient, URL url, Date createDate, Date expireDate, WapSISignals signal, String text) throws SMSLibException {
        this.url = url;
        this.createDate = new Date(createDate.getTime());
        this.expireDate = new Date(expireDate.getTime());
        this.signal = signal;
        this.setText(text);
        this.setEncoding(Message.MessageEncodings.ENCUCS2);
        this.setSrcPort(9200);
        this.setDstPort(2948);
        this.setType(Message.MessageTypes.WAPSI);
        this.setRecipient(recipient);
        try {
            this.fixPdu();
        }
        catch (UnsupportedEncodingException e) {
            throw new SMSLibException(e.getMessage());
        }
    }

    public OutboundWapSIMessage(String recipient, URL url, String text) throws SMSLibException {
        this(recipient, url, new Date(), new Date(), WapSISignals.NONE, text);
    }

    public Date getCreateDate() {
        return new Date(this.createDate.getTime());
    }

    public void setCreateDate(Date createDate) {
        this.createDate = new Date(createDate.getTime());
    }

    public Date getExpireDate() {
        return new Date(this.expireDate.getTime());
    }

    public void setExpireDate(Date expireDate) {
        this.expireDate = new Date(expireDate.getTime());
    }

    public WapSISignals getSignal() {
        return this.signal;
    }

    public void setSignal(WapSISignals signal) {
        this.signal = signal;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    protected String getPDUData() {
        return this.siPdu;
    }

    private String bytesToHexStr(byte[] b) {
        if (b == null) {
            return "";
        }
        StringBuffer strBuffer = new StringBuffer(b.length * 3);
        for (int i = 0; i < b.length; ++i) {
            strBuffer.append(Integer.toHexString(b[i] & 0xFF));
        }
        return strBuffer.toString();
    }

    private void fixPdu() throws UnsupportedEncodingException {
        int i;
        this.siPdu = PDU_PATTERN;
        String s = this.bytesToHexStr(this.getText().getBytes("UTF-8"));
        this.siPdu = this.siPdu.replaceAll("_TEXT_", s);
        boolean foundProtocol = false;
        String urlText = this.url.toString();
        for (i = 0; i < 4; ++i) {
            if (urlText.indexOf(protocolBytes[i][0]) != 0) continue;
            foundProtocol = true;
            this.siPdu = this.siPdu.replaceAll("_URL1_", protocolBytes[i][1]);
            urlText = urlText.replaceAll(protocolBytes[i][0], "");
            break;
        }
        if (!foundProtocol) {
            this.siPdu = this.siPdu.replaceAll("_URL1_", "0B");
        }
        s = "";
        for (i = 0; i < urlText.length(); ++i) {
            boolean foundDomain = false;
            String subUrl = urlText.substring(i);
            for (int j = 0; j < 4; ++j) {
                if (subUrl.indexOf(domainBytes[j][0]) != 0) continue;
                foundDomain = true;
                i += 4;
                s = s + "00";
                s = s + domainBytes[j][1];
                s = s + "03";
                break;
            }
            if (foundDomain) continue;
            char c = urlText.charAt(i);
            s = s + (Integer.toHexString(c).length() < 2 ? "0" + Integer.toHexString(c) : Integer.toHexString(c));
        }
        this.siPdu = this.siPdu.replaceAll("_URL2_", s);
        this.setEncodedText(this.siPdu);
    }

    public static enum WapSISignals implements Serializable
    {
        NONE,
        LOW,
        MEDIUM,
        HIGH,
        DELETE;

    }
}

