/*
 * Decompiled with CFR 0.152.
 */
package org.smslib;

import java.io.Serializable;
import java.util.Date;
import org.smslib.Message;

public class OutboundMessage
extends Message {
    private static final long serialVersionUID = 6449191177648891554L;
    protected String recipient;
    private Date dispatchDate;
    private int validityPeriod;
    private boolean statusReport;
    private boolean flashSms;
    private int srcPort;
    private int dstPort;
    private String from;
    private MessageStatuses messageStatus;
    private FailureCauses failureCause;
    private int retryCount;
    private MessagePriorities priority;
    private String refNo;
    private String UDH;
    private String UD;

    public OutboundMessage() {
        super(Message.MessageTypes.OUTBOUND, null, null);
        this.recipient = "";
        this.validityPeriod = -1;
        this.statusReport = false;
        this.flashSms = false;
        this.srcPort = -1;
        this.dstPort = -1;
        this.from = "";
        this.pid = 0;
        this.dcs = 0;
        this.dispatchDate = null;
        this.setDate(new Date());
        this.setEncoding(Message.MessageEncodings.ENC7BIT);
        this.messageStatus = MessageStatuses.UNSENT;
        this.failureCause = FailureCauses.NO_ERROR;
        this.retryCount = 0;
        this.priority = MessagePriorities.NORMAL;
        this.refNo = "";
    }

    public OutboundMessage(String recipient, String text) {
        super(Message.MessageTypes.OUTBOUND, new Date(), text);
        this.recipient = recipient;
        this.validityPeriod = -1;
        this.statusReport = false;
        this.flashSms = false;
        this.srcPort = -1;
        this.dstPort = -1;
        this.from = "";
        this.pid = 0;
        this.dcs = 0;
        this.dispatchDate = null;
        this.setDate(new Date());
        this.setEncoding(Message.MessageEncodings.ENC7BIT);
        this.messageStatus = MessageStatuses.UNSENT;
        this.failureCause = FailureCauses.NO_ERROR;
        this.retryCount = 0;
        this.priority = MessagePriorities.NORMAL;
        this.refNo = "";
    }

    public boolean isBig() {
        int messageLength = this.getEncodedText().length() / 2;
        return messageLength > this.maxSize();
    }

    public int getNoOfParts() {
        int noOfParts = 0;
        int partSize = this.maxSize() - 8;
        int messageLength = this.getEncodedText().length() / 2;
        noOfParts = messageLength / partSize;
        if (noOfParts * partSize < messageLength) {
            ++noOfParts;
        }
        return noOfParts;
    }

    int maxSize() {
        return 140;
    }

    public String getPart(int partNo, int udhLength) {
        if (partNo != 0) {
            int partSize = this.getEncoding() != Message.MessageEncodings.ENCUCS2 ? this.maxSize() - udhLength / 2 : this.maxSize() - 1 - udhLength / 2;
            if ((partSize *= 2) * (partNo - 1) + partSize > this.getEncodedText().length()) {
                return this.getEncodedText().substring(partSize * (partNo - 1));
            }
            return this.getEncodedText().substring(partSize * (partNo - 1), partSize * (partNo - 1) + partSize);
        }
        return this.getEncodedText();
    }

    String getValidityPeriodBits() {
        String bits;
        if (this.validityPeriod == -1) {
            bits = "FF";
        } else {
            int value = this.validityPeriod <= 12 ? this.validityPeriod * 12 - 1 : (this.validityPeriod <= 24 ? (this.validityPeriod - 12) * 2 + 143 : (this.validityPeriod <= 720 ? this.validityPeriod / 24 + 166 : this.validityPeriod / 168 + 192));
            bits = Integer.toHexString(value);
            if (bits.length() != 2) {
                bits = "0" + bits;
            }
            if (bits.length() > 2) {
                bits = "FF";
            }
        }
        return bits;
    }

    String toBCDFormat(String s) {
        String ss = s;
        if (ss.length() % 2 != 0) {
            ss = ss + "F";
        }
        String bcd = "";
        for (int i = 0; i < ss.length(); i += 2) {
            bcd = bcd + ss.charAt(i + 1) + ss.charAt(i);
        }
        return bcd;
    }

    public String getPDU(String smscNumber, int mpRefNo, int partNo) {
        String str2;
        String str1;
        String ud = "";
        String dataLen = "";
        String pdu = "";
        String udh = "";
        if (smscNumber != null && smscNumber.length() != 0) {
            str1 = "91" + this.toBCDFormat(smscNumber.substring(1));
            str2 = Integer.toHexString(str1.length() / 2);
            if (str2.length() != 2) {
                str2 = "0" + str2;
            }
            pdu = pdu + str2 + str1;
        } else if (smscNumber != null && smscNumber.length() == 0) {
            pdu = pdu + "00";
        }
        pdu = this.srcPort != -1 && this.dstPort != -1 || this.isBig() ? (this.statusReport ? pdu + "71" : pdu + "51") : (this.statusReport ? pdu + "31" : pdu + "11");
        pdu = pdu + "00";
        str1 = this.getRecipient();
        if (str1.charAt(0) == '+') {
            str1 = this.toBCDFormat(str1.substring(1));
            str2 = Integer.toHexString(this.getRecipient().length() - 1);
            str1 = "91" + str1;
        } else {
            str1 = this.toBCDFormat(str1);
            str2 = Integer.toHexString(this.getRecipient().length());
            str1 = "81" + str1;
        }
        if (str2.length() != 2) {
            str2 = "0" + str2;
        }
        pdu = pdu + str2 + str1;
        String s = Integer.toHexString(this.pid);
        while (s.length() < 2) {
            s = "0" + s;
        }
        pdu = pdu + s;
        switch (this.getEncoding()) {
            case ENC7BIT: {
                if (this.flashSms) {
                    pdu = pdu + "10";
                    break;
                }
                pdu = pdu + "00";
                break;
            }
            case ENC8BIT: {
                if (this.flashSms) {
                    pdu = pdu + "14";
                    break;
                }
                pdu = pdu + "04";
                break;
            }
            case ENCUCS2: {
                if (this.flashSms) {
                    pdu = pdu + "18";
                    break;
                }
                if (this.getType() == Message.MessageTypes.WAPSI) {
                    pdu = pdu + "F5";
                    break;
                }
                pdu = pdu + "08";
                break;
            }
            case ENCCUSTOM: {
                s = Integer.toHexString(this.dcs);
                while (s.length() < 2) {
                    s = "0" + s;
                }
                pdu = pdu + s;
            }
        }
        pdu = pdu + this.getValidityPeriodBits();
        if (this.srcPort != -1 && this.dstPort != -1) {
            udh = udh + "060504";
            s = Integer.toHexString(this.dstPort);
            while (s.length() < 4) {
                s = "0" + s;
            }
            udh = udh + s;
            s = Integer.toHexString(this.srcPort);
            while (s.length() < 4) {
                s = "0" + s;
            }
            udh = udh + s;
        }
        if (this.isBig()) {
            udh = this.srcPort != -1 && this.dstPort != -1 ? "0C" + udh.substring(2) + "0804" : udh + "060804";
            s = Integer.toHexString(mpRefNo);
            while (s.length() < 4) {
                s = "0" + s;
            }
            udh = udh + s;
            s = Integer.toHexString(this.getNoOfParts());
            while (s.length() < 2) {
                s = "0" + s;
            }
            udh = udh + s;
            s = Integer.toHexString(partNo);
            while (s.length() < 2) {
                s = "0" + s;
            }
            udh = udh + s;
        }
        switch (this.getEncoding()) {
            case ENC7BIT: {
                if (this.isBig()) {
                    ud = this.getPart(partNo, udh.length());
                    int ud_length = this.getText().length() % 8 == 7 ? ud.length() - 1 : ud.length();
                    dataLen = Integer.toHexString((ud_length + udh.length()) * 8 / 7 / 2);
                    break;
                }
                ud = this.getPart(partNo, udh.length());
                if (this.srcPort != -1 && this.dstPort != -1) {
                    dataLen = Integer.toHexString(this.messageCharCount + udh.length() / 2 + 1);
                    break;
                }
                dataLen = Integer.toHexString(this.messageCharCount + udh.length() / 2);
                break;
            }
            case ENC8BIT: {
                ud = this.getPart(partNo, udh.length());
                dataLen = Integer.toHexString((ud.length() + udh.length()) / 2);
                break;
            }
            case ENCUCS2: {
                ud = this.getPart(partNo, udh.length());
                dataLen = Integer.toHexString((ud.length() + udh.length()) / 2);
                break;
            }
            case ENCCUSTOM: {
                if ((this.dcs & 4) == 0) {
                    ud = this.getPart(partNo, udh.length());
                    int ud_length = this.getText().length() % 8 == 7 ? ud.length() - 1 : ud.length();
                    dataLen = Integer.toHexString((ud_length + udh.length()) * 8 / 7 / 2);
                    break;
                }
                ud = this.getPart(partNo, udh.length());
                dataLen = Integer.toHexString((ud.length() + udh.length()) / 2);
            }
        }
        if (dataLen.length() != 2) {
            dataLen = "0" + dataLen;
        }
        pdu = udh.length() != 0 ? pdu + dataLen + udh + ud : pdu + dataLen + ud;
        this.UDH = udh;
        this.UD = ud;
        return pdu.toUpperCase();
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public Date getDispatchDate() {
        if (this.dispatchDate != null) {
            return new Date(this.dispatchDate.getTime());
        }
        return null;
    }

    public void setDispatchDate(Date dispatchDate) {
        this.dispatchDate = dispatchDate;
    }

    public int getDstPort() {
        return this.dstPort;
    }

    public void setDstPort(int dstPort) {
        this.dstPort = dstPort;
    }

    public boolean getFlashSms() {
        return this.flashSms;
    }

    public void setFlashSms(boolean flashSms) {
        this.flashSms = flashSms;
    }

    public int getSrcPort() {
        return this.srcPort;
    }

    public void setSrcPort(int srcPort) {
        this.srcPort = srcPort;
    }

    public boolean getStatusReport() {
        return this.statusReport;
    }

    public void setStatusReport(boolean statusReport) {
        this.statusReport = statusReport;
    }

    public int getValidityPeriod() {
        return this.validityPeriod;
    }

    public void setValidityPeriod(int validityPeriod) {
        this.validityPeriod = validityPeriod;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    int getPid() {
        return this.pid;
    }

    void setPid(int pid) {
        this.pid = pid;
    }

    int getDcs() {
        return this.dcs;
    }

    void setDcs(int dcs) {
        this.dcs = dcs;
    }

    public MessageStatuses getMessageStatus() {
        return this.messageStatus;
    }

    public void setMessageStatus(MessageStatuses messageStatus) {
        this.messageStatus = messageStatus;
    }

    public FailureCauses getFailureCause() {
        return this.failureCause;
    }

    public void setFailureCause(FailureCauses failureCause) {
        if (failureCause != FailureCauses.NO_ERROR) {
            this.messageStatus = MessageStatuses.FAILED;
        }
        this.failureCause = failureCause;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    void incrementRetryCount() {
        ++this.retryCount;
    }

    public MessagePriorities getPriority() {
        return this.priority;
    }

    public void setPriority(MessagePriorities priority) {
        this.priority = priority;
    }

    public String getRefNo() {
        return this.refNo;
    }

    public void setRefNo(String refNo) {
        this.refNo = refNo;
    }

    public String getUDH() {
        return this.UDH;
    }

    public String getUD() {
        return this.UD;
    }

    public String toString() {
        String str = "";
        str = str + "===============================================================================";
        str = str + "\n";
        str = str + "<< OUTBOUND MESSAGE DUMP >>";
        str = str + "\n";
        str = str + "-------------------------------------------------------------------------------";
        str = str + "\n";
        str = str + " Gateway Id: " + this.getGatewayId();
        str = str + "\n";
        str = str + " Encoding: " + (this.getEncoding() == Message.MessageEncodings.ENC7BIT ? "7-bit" : (this.getEncoding() == Message.MessageEncodings.ENC8BIT ? "8-bit" : "UCS2 (Unicode)"));
        str = str + "\n";
        str = str + " Date: " + this.getDate();
        str = str + "\n";
        str = str + " Text: " + this.getText();
        str = str + "\n";
        str = str + " Encoded Text: " + this.getEncodedText();
        str = str + "\n";
        str = str + " SMSC Ref No: " + this.refNo;
        str = str + "\n";
        str = str + " Recipient: " + this.recipient;
        str = str + "\n";
        str = str + " Dispatch Date: " + this.getDispatchDate();
        str = str + "\n";
        str = str + " Message Status: " + this.getMessageStatus();
        str = str + "\n";
        str = str + " Validity Period (Hours): " + this.getValidityPeriod();
        str = str + "\n";
        str = str + " Status Report: " + this.getStatusReport();
        str = str + "\n";
        str = str + " Source / Destination Ports: " + this.getSrcPort() + " / " + this.getDstPort();
        str = str + "\n";
        str = str + " Flash SMS: " + this.getFlashSms();
        str = str + "\n";
        str = str + "===============================================================================";
        str = str + "\n";
        return str;
    }

    public static enum MessageStatuses implements Serializable
    {
        UNSENT,
        SENT,
        FAILED;

    }

    public static enum MessagePriorities implements Serializable
    {
        HIGH,
        NORMAL,
        LOW;

    }

    public static enum FailureCauses implements Serializable
    {
        NO_ERROR,
        BAD_NUMBER,
        BAD_FORMAT,
        GATEWAY_FAILURE,
        NO_CREDIT,
        GATEWAY_AUTH,
        NO_ROUTE,
        UNKNOWN;

    }
}

