/*
 * Decompiled with CFR 0.152.
 */
package org.smslib;

import java.io.Serializable;
import java.util.Date;
import org.smslib.helper.GSMAlphabet;

public class Message
implements Serializable {
    private static final long serialVersionUID = 4461754947231415569L;
    private static long messageIdSeed = 0L;
    private final long messageId = messageIdSeed++;
    private String gtwId = "";
    private MessageTypes type;
    private Date date;
    private String id;
    private String text;
    private String encodedText;
    private MessageEncodings encoding;
    protected int pid;
    protected int dcs;
    protected int messageCharCount;

    public Message(MessageTypes type, Date date, String text) {
        this.type = type;
        this.id = "";
        this.setDate(date);
        this.text = text;
        this.encoding = MessageEncodings.ENC7BIT;
        this.messageCharCount = 0;
    }

    public Date getDate() {
        return this.date == null ? null : new Date(this.date.getTime());
    }

    public void setDate(Date date) {
        this.date = date != null ? new Date(date.getTime()) : null;
    }

    public String getEncodedText() {
        return this.encodedText;
    }

    void setEncodedText(String encodedText) {
        this.encodedText = encodedText;
    }

    public MessageEncodings getEncoding() {
        return this.encoding;
    }

    public void setEncoding(MessageEncodings encoding) {
        this.encoding = encoding;
        this.encodedText = "";
        if (this.text == null || this.text.length() == 0) {
            return;
        }
        switch (encoding) {
            case ENC7BIT: {
                this.encodedText = GSMAlphabet.textToPDU(this.text);
                this.messageCharCount = GSMAlphabet.noOfChars(this.text);
                break;
            }
            case ENC8BIT: {
                byte[] bytes = this.text.getBytes();
                for (int i = 0; i < bytes.length; ++i) {
                    String s = "0" + Integer.toHexString(bytes[i]);
                    int from = s.length() - 2;
                    this.encodedText = this.encodedText + s.substring(from);
                }
                break;
            }
            case ENCUCS2: {
                for (int i = 0; i < this.text.length(); ++i) {
                    char c = this.text.charAt(i);
                    int high = c / 256;
                    int low = c % 256;
                    this.encodedText = this.encodedText + (Integer.toHexString(high).length() < 2 ? "0" + Integer.toHexString(high) : Integer.toHexString(high));
                    this.encodedText = this.encodedText + (Integer.toHexString(low).length() < 2 ? "0" + Integer.toHexString(low) : Integer.toHexString(low));
                }
                break;
            }
            case ENCCUSTOM: {
                if ((this.dcs & 4) == 0) {
                    this.encodedText = GSMAlphabet.textToPDU(this.text);
                    break;
                }
                for (int i = 0; i < this.text.length(); ++i) {
                    char c = this.text.charAt(i);
                    this.encodedText = this.encodedText + (Integer.toHexString(c).length() < 2 ? "0" + Integer.toHexString(c) : Integer.toHexString(c));
                }
                break;
            }
        }
    }

    public String getGatewayId() {
        return this.gtwId;
    }

    public void setGatewayId(String gtwId) {
        this.gtwId = gtwId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public String getText() {
        return this.text;
    }

    protected void setText(String text) {
        this.text = text;
    }

    public void addText(String addText) {
        this.text = this.text + addText;
    }

    public MessageTypes getType() {
        return this.type;
    }

    void setType(MessageTypes type) {
        this.type = type;
    }

    public static enum MessageTypes implements Serializable
    {
        INBOUND,
        OUTBOUND,
        STATUSREPORT,
        WAPSI,
        UNKNOWN;

    }

    public static enum MessageEncodings implements Serializable
    {
        ENC7BIT,
        ENC8BIT,
        ENCUCS2,
        ENCCUSTOM;

    }
}

