/*
 * Decompiled with CFR 0.152.
 */
package org.smslib;

import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import org.smslib.Message;
import org.smslib.helper.GSMAlphabet;

public class InboundMessage
extends Message {
    private static final long serialVersionUID = 5506740746605374709L;
    private String originator;
    private int memIndex;
    private String memLocation;
    private int mpRefNo;
    private int mpMaxNo;
    private int mpSeqNo;
    private String mpMemIndex;
    private String pduUserData;

    public InboundMessage(Date date, String originator, String text, int memIndex, String memLocation) {
        super(Message.MessageTypes.INBOUND, date, text);
        this.originator = originator;
        this.memIndex = memIndex;
        this.memLocation = memLocation;
        this.mpRefNo = 0;
        this.mpMaxNo = 0;
        this.mpSeqNo = 0;
        this.mpMemIndex = "";
    }

    public InboundMessage(Message.MessageTypes type, int memIndex, String memLocation) {
        super(type, null, null);
        this.originator = "";
        this.memIndex = memIndex;
        this.memLocation = memLocation;
        this.mpRefNo = 0;
        this.mpMaxNo = 0;
        this.mpSeqNo = 0;
        this.mpMemIndex = "";
    }

    public InboundMessage(String pdu, int memIndex, String memLocation) {
        super(Message.MessageTypes.INBOUND, null, null);
        String UDHData;
        int UDHLength;
        byte[] bytes;
        String str1;
        int addr;
        int k;
        this.memIndex = memIndex;
        this.memLocation = memLocation;
        this.mpRefNo = 0;
        this.mpMaxNo = 0;
        this.mpSeqNo = 0;
        this.mpMemIndex = "";
        int skipBytes = 0;
        int i = Integer.parseInt(pdu.substring(0, 2), 16);
        int index = (i + 1) * 2;
        boolean hasUDH = (Integer.parseInt(pdu.substring(index, index + 2), 16) & 0x40) != 0;
        i = Integer.parseInt(pdu.substring(index += 2, index + 2), 16);
        int j = index + 4;
        this.originator = "";
        for (k = 0; k < i; k += 2) {
            this.originator = this.originator + pdu.charAt(j + k + 1) + pdu.charAt(j + k);
        }
        this.originator = "+" + this.originator;
        if (this.originator.charAt(this.originator.length() - 1) == 'F') {
            this.originator = this.originator.substring(0, this.originator.length() - 1);
        }
        if (((addr = Integer.parseInt(pdu.substring(j - 2, j), 16)) & 0x40) != 0 && (addr & 0x20) == 0 && (addr & 0x10) != 0) {
            str1 = this.pduToText(pdu.substring(j, j + k));
            bytes = new byte[str1.length()];
            for (i = 0; i < str1.length(); ++i) {
                bytes[i] = (byte)str1.charAt(i);
            }
            this.originator = GSMAlphabet.bytesToString(bytes);
        }
        index = j + k + 2;
        str1 = "" + pdu.charAt(index) + pdu.charAt(index + 1);
        int protocol = Integer.parseInt(str1, 16);
        int year = Integer.parseInt("" + pdu.charAt((index += 2) + 1) + pdu.charAt(index));
        int month = Integer.parseInt("" + pdu.charAt((index += 2) + 1) + pdu.charAt(index));
        int day = Integer.parseInt("" + pdu.charAt((index += 2) + 1) + pdu.charAt(index));
        int hour = Integer.parseInt("" + pdu.charAt((index += 2) + 1) + pdu.charAt(index));
        int min = Integer.parseInt("" + pdu.charAt((index += 2) + 1) + pdu.charAt(index));
        int sec = Integer.parseInt("" + pdu.charAt((index += 2) + 1) + pdu.charAt(index));
        index += 4;
        Calendar cal = Calendar.getInstance();
        cal.set(1, year + 2000);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, min);
        cal.set(13, sec);
        Date date = cal.getTime();
        if (hasUDH) {
            UDHLength = Integer.parseInt(pdu.substring(index + 2, index + 2 + 2), 16);
            UDHData = pdu.substring(index + 2 + 2, index + 2 + 2 + UDHLength * 2);
            if (UDHData.substring(0, 2).equalsIgnoreCase("00")) {
                this.mpRefNo = Integer.parseInt(UDHData.substring(4, 6), 16);
                this.mpMaxNo = Integer.parseInt(UDHData.substring(6, 8), 16);
                this.mpSeqNo = Integer.parseInt(UDHData.substring(8, 10), 16);
                skipBytes = 7;
            } else if (UDHData.substring(0, 2).equalsIgnoreCase("08")) {
                this.mpRefNo = Integer.parseInt(UDHData.substring(4, 8), 16);
                this.mpMaxNo = Integer.parseInt(UDHData.substring(8, 10), 16);
                this.mpSeqNo = Integer.parseInt(UDHData.substring(10, 12), 16);
                skipBytes = 8;
            }
        } else {
            UDHLength = 0;
            UDHData = "";
        }
        switch (protocol & 0xC) {
            case 0: {
                this.setEncoding(Message.MessageEncodings.ENC7BIT);
                str1 = this.pduToText(pdu.substring(index + 2));
                this.pduUserData = pdu.substring(index + 2 + UDHLength);
                bytes = new byte[str1.length()];
                for (i = 0; i < str1.length(); ++i) {
                    bytes[i] = (byte)str1.charAt(i);
                }
                String str2 = GSMAlphabet.bytesToString(bytes);
                if (hasUDH) {
                    str1 = str2.substring(UDHLength + 2);
                    break;
                }
                str1 = str2;
                break;
            }
            case 4: {
                this.setEncoding(Message.MessageEncodings.ENC8BIT);
                index += 2;
                if (hasUDH) {
                    index += UDHLength + skipBytes;
                }
                this.pduUserData = pdu.substring(index);
                str1 = "";
                while (index < pdu.length()) {
                    i = Integer.parseInt("" + pdu.charAt(index) + pdu.charAt(index + 1), 16);
                    str1 = str1 + (char)i;
                    index += 2;
                }
                break;
            }
            case 8: {
                this.setEncoding(Message.MessageEncodings.ENCUCS2);
                index += 2;
                if (hasUDH) {
                    index += UDHLength + skipBytes;
                }
                this.pduUserData = pdu.substring(index);
                str1 = "";
                while (index < pdu.length()) {
                    i = Integer.parseInt("" + pdu.charAt(index) + pdu.charAt(index + 1), 16);
                    j = Integer.parseInt("" + pdu.charAt(index + 2) + pdu.charAt(index + 3), 16);
                    str1 = str1 + (char)(i * 256 + j);
                    index += 4;
                }
                break;
            }
        }
        this.setDate(date);
        this.setText(str1);
    }

    private String pduToText(String pdu) {
        int value2;
        int j;
        int i;
        byte[] oldBytes = new byte[pdu.length() / 2];
        for (i = 0; i < pdu.length() / 2; ++i) {
            oldBytes[i] = (byte)(Integer.parseInt(pdu.substring(i * 2, i * 2 + 1), 16) * 16);
            int n = i;
            oldBytes[n] = (byte)(oldBytes[n] + (byte)Integer.parseInt(pdu.substring(i * 2 + 1, i * 2 + 2), 16));
        }
        BitSet bitSet = new BitSet(pdu.length() / 2 * 8);
        int value1 = 0;
        for (i = 0; i < pdu.length() / 2; ++i) {
            for (j = 0; j < 8; ++j) {
                value1 = i * 8 + j;
                if ((oldBytes[i] & 1 << j) == 0) continue;
                bitSet.set(value1);
            }
        }
        if ((value2 = ++value1 / 7) == 0) {
            ++value2;
        }
        byte[] newBytes = new byte[value2];
        for (i = 0; i < value2; ++i) {
            for (j = 0; j < 7; ++j) {
                if (value1 + 1 <= i * 7 + j || !bitSet.get(i * 7 + j)) continue;
                int n = i;
                newBytes[n] = (byte)(newBytes[n] | (byte)(1 << j));
            }
        }
        String text = newBytes[value2 - 1] == 0 ? new String(newBytes, 0, value2 - 1) : new String(newBytes);
        return text;
    }

    public String getOriginator() {
        return this.originator;
    }

    void setOriginator(String originator) {
        this.originator = originator;
    }

    public int getMemIndex() {
        return this.memIndex;
    }

    public void setMemIndex(int memIndex) {
        this.memIndex = memIndex;
    }

    public String getMemLocation() {
        return this.memLocation;
    }

    public void setMemLocation(String memLocation) {
        this.memLocation = memLocation;
    }

    public int getMpMaxNo() {
        return this.mpMaxNo;
    }

    public void setMpMaxNo(int mpMaxNo) {
        this.mpMaxNo = mpMaxNo;
    }

    public String getMpMemIndex() {
        return this.mpMemIndex;
    }

    public void setMpMemIndex(int mpMemIndex) {
        this.mpMemIndex = this.mpMemIndex + (this.mpMemIndex.length() == 0 ? "" : ",") + mpMemIndex;
    }

    public int getMpRefNo() {
        return this.mpRefNo;
    }

    public void setMpRefNo(int mpRefNo) {
        this.mpRefNo = mpRefNo;
    }

    public int getMpSeqNo() {
        return this.mpSeqNo;
    }

    public void setMpSeqNo(int mpSeqNo) {
        this.mpSeqNo = mpSeqNo;
    }

    public String getPduUserData() {
        return this.pduUserData;
    }

    public void setPduUserData(String pdu) {
        this.pduUserData = pdu;
    }

    public void addPduUserData(String pdu) {
        this.pduUserData = this.pduUserData + pdu;
    }

    public String toString() {
        String str = "";
        str = str + "===============================================================================";
        str = str + "\n";
        str = str + "<< INBOUND MESSAGE DUMP >>";
        str = str + "\n";
        str = str + "-------------------------------------------------------------------------------";
        str = str + "\n";
        str = str + " Gateway Id: " + this.getGatewayId();
        str = str + "\n";
        str = str + " Encoding: " + (this.getEncoding() == Message.MessageEncodings.ENC7BIT ? "7-bit" : (this.getEncoding() == Message.MessageEncodings.ENC8BIT ? "8-bit" : "UCS2 (Unicode)"));
        str = str + "\n";
        str = str + " Date: " + this.getDate();
        str = str + "\n";
        str = str + " Text: " + this.getText();
        str = str + "\n";
        str = str + " PDU data: " + this.getPduUserData();
        str = str + "\n";
        str = str + " Originator: " + this.originator;
        str = str + "\n";
        str = str + " Memory Index: " + this.getMemIndex();
        str = str + "\n";
        str = str + " Multi-part Memory Index: " + this.getMpMemIndex();
        str = str + "\n";
        str = str + " Memory Location: " + this.getMemLocation();
        str = str + "\n";
        str = str + "===============================================================================";
        str = str + "\n";
        return str;
    }

    public static enum MessageClasses {
        READ,
        UNREAD,
        ALL;

    }
}

