/*
 * Decompiled with CFR 0.152.
 */
package br.org.indt.jms;

import java.io.InputStream;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class JMSUtil {
    private static Context jndiContext = null;

    public static ConnectionFactory geConnectionFactory(String string) throws Exception {
        return (ConnectionFactory)JMSUtil.jndiLookup(string);
    }

    public static QueueConnectionFactory getQueueConnectionFactory(String string) throws Exception {
        return (QueueConnectionFactory)JMSUtil.jndiLookup(string);
    }

    public static TopicConnectionFactory getTopicConnectionFactory(String string) throws Exception {
        return (TopicConnectionFactory)JMSUtil.jndiLookup(string);
    }

    public static Destination getDestination(String string) throws Exception {
        return (Destination)JMSUtil.jndiLookup(string);
    }

    public static Queue getQueue(String string) throws Exception {
        return (Queue)JMSUtil.jndiLookup(string);
    }

    public static Topic getTopic(String string) throws Exception {
        return (Topic)JMSUtil.jndiLookup(string);
    }

    public static Object jndiLookup(String string) throws Exception {
        Object object = null;
        if (jndiContext == null) {
            ClassLoader classLoader = JMSUtil.class.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream("m4u-util-jndi.properties");
            if (inputStream == null) {
                Logger.getLogger(JMSUtil.class).debug((Object)"N\ufffdo foi possivel encontrar o arquivo m4u-util-jndi.properties. Ser\ufffd usado jndi default.");
                jndiContext = new InitialContext();
            } else {
                Properties properties = new Properties();
                properties.load(inputStream);
                jndiContext = new InitialContext(properties);
            }
        }
        object = jndiContext.lookup(string);
        return object;
    }

    public static void closeContext() throws NamingException {
        if (jndiContext != null) {
            jndiContext.close();
        }
        jndiContext = null;
    }

    public static class DoneLatch {
        boolean done = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitTillDone() {
            DoneLatch doneLatch = this;
            synchronized (doneLatch) {
                while (!this.done) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void allDone() {
            DoneLatch doneLatch = this;
            synchronized (doneLatch) {
                this.done = true;
                this.notify();
            }
        }
    }
}

