/*
 * Decompiled with CFR 0.152.
 */
package br.org.indt.jms;

import br.org.indt.jms.JMSSenderHelperException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;

public class JMSSenderHelper
implements ExceptionListener {
    private static final String DEFAULT_JNDI_RESOURCE_NAME = "m4u-util-jndi.properties";
    private static final String DEFAULT_CONNECTION_FACTORY = "ConnectionFactory";
    private Logger logger;
    private Connection jmsConnection = null;
    private Destination jmsDestination = null;
    private String queueName;
    Session jmsSession = null;
    MessageProducer jmsProducer = null;
    Properties jndiProperties = null;
    String connectionFactory;

    public JMSSenderHelper(String string, String string2) throws JMSSenderHelperException {
        this(string, string2, DEFAULT_CONNECTION_FACTORY);
    }

    public JMSSenderHelper(String string, String string2, String string3) throws JMSSenderHelperException {
        if (string2 == null) {
            string2 = DEFAULT_JNDI_RESOURCE_NAME;
        }
        this.queueName = string;
        this.logger = Logger.getLogger(JMSSenderHelper.class);
        this.connectionFactory = string3;
        this.init(string2);
    }

    public JMSSenderHelper(String string) throws JMSSenderHelperException {
        this.queueName = string;
        this.logger = Logger.getLogger(JMSSenderHelper.class);
        this.connectionFactory = DEFAULT_CONNECTION_FACTORY;
        this.init(DEFAULT_JNDI_RESOURCE_NAME);
    }

    private void init(String string) throws JMSSenderHelperException {
        InputStream inputStream = string != null ? this.getClass().getClassLoader().getResourceAsStream(string) : null;
        try {
            if (inputStream != null) {
                this.jndiProperties = new Properties();
                this.jndiProperties.load(inputStream);
                this.logger.info((Object)("Usando as seguintes propriedades jndi: " + this.jndiProperties));
            } else {
                this.logger.info((Object)"Usando propriedades jndi default");
            }
        }
        catch (IOException iOException) {
            this.logger.error((Object)("Erro ao carregar propriedades JNDI \"" + string + '\"'), (Throwable)iOException);
        }
        this.reconnectJms();
    }

    public void destroy() {
        this.closeJms();
    }

    public void queue(Serializable serializable) throws JMSSenderHelperException {
        try {
            this.queueMessage((Message)this.createObjectMessage(serializable));
        }
        catch (JMSException jMSException) {
            throw new JMSSenderHelperException("Erro criando ObjectMessage", jMSException);
        }
    }

    public void queueText(String string) throws JMSSenderHelperException {
        try {
            this.queueMessage((Message)this.createTextMessage(string));
        }
        catch (JMSException jMSException) {
            throw new JMSSenderHelperException("Erro criando TextMessage", jMSException);
        }
    }

    public void queueMessage(Message message) throws JMSSenderHelperException {
        try {
            this.jmsProducer.send(message);
        }
        catch (JMSException jMSException) {
            throw new JMSSenderHelperException("Erro publicando mensagem", jMSException);
        }
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        return this.jmsSession.createObjectMessage(serializable);
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        return this.jmsSession.createTextMessage(string);
    }

    public synchronized void onException(JMSException jMSException) {
        this.logger.warn((Object)"Conexao jms perdida", (Throwable)jMSException);
        try {
            this.reconnectJms();
        }
        catch (Exception exception) {
            this.logger.error((Object)("Tentativa de reconnexao com jms falhou. Fila: " + this.queueName), (Throwable)exception);
        }
    }

    private synchronized void reconnectJms() throws JMSSenderHelperException {
        this.closeJms();
        Connection connection = null;
        Destination destination = null;
        try {
            InitialContext initialContext = this.jndiProperties != null ? new InitialContext(this.jndiProperties) : new InitialContext();
            ConnectionFactory connectionFactory = (ConnectionFactory)initialContext.lookup("java:ConnectionFactory");
            destination = (Destination)initialContext.lookup(this.queueName);
            connection = connectionFactory.createConnection();
            try {
                this.logger.debug((Object)"Connection created ...");
                connection.setExceptionListener((ExceptionListener)this);
                this.jmsSession = connection.createSession(false, 1);
                this.logger.debug((Object)"Session created ...");
                this.jmsProducer = this.jmsSession.createProducer(destination);
                this.logger.debug((Object)"Producer created ...");
            }
            catch (Exception exception) {
                try {
                    connection.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                throw exception;
            }
            finally {
                initialContext.close();
            }
        }
        catch (Exception exception) {
            throw new JMSSenderHelperException("Erro ao conectar na fila jms: " + this.queueName, exception);
        }
    }

    private void closeJms() {
        if (this.jmsProducer != null) {
            try {
                this.jmsProducer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.jmsProducer = null;
        }
        if (this.jmsSession != null) {
            try {
                this.jmsSession.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.jmsSession = null;
        }
        if (this.jmsConnection != null) {
            try {
                this.jmsConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.jmsConnection = null;
        }
        this.jmsDestination = null;
    }
}

