/*
 * Decompiled with CFR 0.152.
 */
package br.org.indt.jms;

import br.org.indt.jms.JMSClient;
import br.org.indt.jms.JMSUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;

public class JMSProducer
extends JMSClient {
    private static final long REPLY_TIMEOUT = 5000L;
    private Connection connection;
    private Session session;
    private Session replySession;
    private Destination destination;
    private MessageProducer producer;
    private MessageConsumer replyConsumer;
    private TemporaryQueue replyQueue;
    private String connectionFactoryName;
    private String connectionUsername;
    private String connectionPassword;
    private String destinationName;
    private int sessionMode;
    private Logger logger;

    public JMSProducer(String string, String string2, String string3, String string4, int n) throws JMSException {
        try {
            this.connectionFactoryName = string;
            this.connectionUsername = string2;
            this.connectionPassword = string3;
            this.destinationName = string4;
            this.sessionMode = n;
            this.open();
        }
        catch (JMSException jMSException) {
            throw jMSException;
        }
        catch (Exception exception) {
            JMSException jMSException = new JMSException("General exception initializing JMSConsumer. " + exception.toString() + " - " + exception.getMessage());
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.session.createObjectMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.session.createTextMessage();
    }

    public void send(Message message) throws JMSException {
        this.producer.send(message);
    }

    public void send(Destination destination, Message message, int n, int n2, int n3) throws JMSException {
        this.producer.send(destination, message, n, n2, (long)n3);
    }

    public void send(Message message, int n, int n2, int n3) throws JMSException {
        this.producer.send(message, n, n2, (long)n3);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.producer.send(destination, message);
    }

    public Message sendConfirmed(Message message) throws JMSException {
        return this.sendConfirmed(message, 0L);
    }

    public Message sendConfirmed(Message message, long l) throws JMSException {
        message.setJMSReplyTo((Destination)this.replyQueue);
        this.producer.send(message);
        if (this.session.getAcknowledgeMode() == 0) {
            this.session.commit();
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("Sending confirmed msg: ID: " + message.getJMSMessageID());
        }
        long l2 = System.currentTimeMillis();
        Message message2 = null;
        while (message2 == null || !message2.getJMSCorrelationID().equals(message.getJMSMessageID())) {
            if (l == 0L || System.currentTimeMillis() - l2 < l) {
                message2 = this.replyConsumer.receive(5000L);
                if (!this.logger.isLoggable(Level.INFO)) continue;
                if (message2 == null) {
                    this.logger.info("Reply received: NULL");
                    continue;
                }
                this.logger.info("Reply received: ID: " + message.getJMSMessageID());
                continue;
            }
            this.logger.info("REPLY_MAX_TIMEOUT reached!");
            break;
        }
        if (message2 != null) {
            return message2;
        }
        throw new JMSException("Time limit to receive reply reached");
    }

    public void commit() throws JMSException {
        this.session.commit();
    }

    public void rollback() throws JMSException {
        this.session.rollback();
    }

    public void open() throws JMSException, Exception {
        this.connection = this.getConnection(this.connectionFactoryName, this.connectionUsername, this.connectionPassword);
        this.session = this.sessionMode == 0 ? this.connection.createSession(true, 0) : this.connection.createSession(false, this.sessionMode);
        this.replySession = this.connection.createSession(false, 1);
        this.destination = JMSUtil.getDestination(this.destinationName);
        this.producer = this.session.createProducer(this.destination);
        this.replyQueue = this.replySession.createTemporaryQueue();
        this.replyConsumer = this.replySession.createConsumer((Destination)this.replyQueue);
        this.connection.start();
    }

    public void close() throws JMSException {
        this.producer.close();
        this.replyConsumer.close();
        this.replyQueue.delete();
        this.session.close();
        this.replySession.close();
        this.closeConnection(this.connectionFactoryName, this.connectionUsername);
    }

    public void onException(JMSException jMSException) {
        if (!this.autoReconnect && this.excListener != null) {
            try {
                this.excListener.onException(jMSException);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.autoReconnect) {
            this.logger.log(Level.INFO, "Connection failure detected. Attempting to reconnect...");
            for (int i = 0; this.reconnectAttempts <= 0 || i < this.reconnectAttempts; ++i) {
                try {
                    this.open();
                    this.logger.log(Level.INFO, "Reconnected successfully");
                    return;
                }
                catch (Exception exception) {
                    this.logger.log(Level.INFO, "Reconnection failed... Attempt #" + (i + 1));
                    continue;
                }
            }
            if (this.excListener != null) {
                this.excListener.onException(new JMSException("Could not reconnect after " + this.reconnectAttempts + " attempts"));
            } else {
                this.logger.log(Level.SEVERE, "Could not reconnect after " + this.reconnectAttempts + " attempts", jMSException);
            }
        }
    }
}

