/*
 * Decompiled with CFR 0.152.
 */
package br.org.indt.jms;

import br.org.indt.jms.JMSClient;
import br.org.indt.jms.JMSUtil;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;

public class JMSLightTransceiver
extends JMSClient
implements MessageListener {
    private Logger logger;
    private String connectionFactoryName;
    private String connectionUsername;
    private String connectionPassword;
    private String destinationName;
    private String messageSelector;
    private int sessionMode;
    private MessageListener listener;
    private Connection connection;
    private Session session;
    private Destination destination;
    private MessageConsumer consumer;
    private MessageProducer producer;
    private boolean msgListenerSet;
    private String syncAwaitingId;
    private Message syncReplyMessage;

    public JMSLightTransceiver(String string, String string2, String string3, String string4, String string5, int n) throws JMSException {
        try {
            this.connectionFactoryName = string;
            this.connectionUsername = string2;
            this.connectionPassword = string3;
            this.destinationName = string4;
            this.sessionMode = n;
            this.messageSelector = string5;
        }
        catch (Exception exception) {
            JMSException jMSException = new JMSException("General exception initializing JMSConsumer. " + exception.toString() + " - " + exception.getMessage());
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
    }

    public void open() throws JMSException, Exception {
        this.connection = this.getConnection(this.connectionFactoryName, this.connectionUsername, this.connectionPassword);
        this.session = this.connection.createSession(this.sessionMode == 0, this.sessionMode);
        if (this.sessionMode == 2) {
            this.session.recover();
        }
        this.destination = JMSUtil.getDestination(this.destinationName);
        this.consumer = this.session.createConsumer(this.destination, this.messageSelector, true);
        this.producer = this.session.createProducer(this.destination);
        this.consumer.setMessageListener(this.listener);
        this.connection.start();
    }

    public void close() throws JMSException {
        this.consumer.close();
        this.producer.close();
        this.session.close();
        this.closeConnection(this.connectionFactoryName, this.connectionUsername);
    }

    public Message receive() throws JMSException {
        return this.consumer.receive();
    }

    public Message receive(long l) throws JMSException {
        return this.consumer.receive(l);
    }

    public Message receiveNoWait() throws JMSException {
        return this.consumer.receiveNoWait();
    }

    public void reply(Message message, Serializable serializable) throws JMSException {
        ObjectMessage objectMessage = this.session.createObjectMessage();
        objectMessage.setJMSCorrelationID(message.getJMSMessageID());
        objectMessage.setObject(serializable);
        this.producer.send(message.getJMSReplyTo(), (Message)objectMessage);
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.session.createObjectMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.session.createTextMessage();
    }

    public void send(Message message) throws JMSException {
        this.producer.send(message);
    }

    public void send(Destination destination, Message message, int n, int n2, int n3) throws JMSException {
        this.producer.send(destination, message, n, n2, (long)n3);
    }

    public void send(Message message, int n, int n2, int n3) throws JMSException {
        this.producer.send(message, n, n2, (long)n3);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.producer.send(destination, message);
    }

    public Message sendSync(Message message) throws JMSException {
        return this.sendSync(message, 0L);
    }

    public synchronized Message sendSync(Message message, long l) throws JMSException {
        message.setJMSReplyTo(this.destination);
        this.producer.send(message);
        if (this.session.getAcknowledgeMode() == 0) {
            this.session.commit();
        }
        return this.waitForReply(message, l);
    }

    private Message waitForReply(Message message, long l) throws JMSException {
        if (!this.msgListenerSet) {
            throw new IllegalStateException("Message Listener must be set to use sync sends");
        }
        try {
            this.syncReplyMessage = null;
            this.setSyncAwaitingID(message.getJMSMessageID());
            this.wait(l);
            return this.syncReplyMessage;
        }
        catch (InterruptedException interruptedException) {
            this.logger.finest("Interrupted while waiting for reply");
            return null;
        }
    }

    private synchronized String getSyncAwaitingID() {
        return this.syncAwaitingId;
    }

    private synchronized void setSyncAwaitingID(String string) {
        this.syncAwaitingId = string;
    }

    public void setMessageListener(MessageListener messageListener) {
        this.msgListenerSet = messageListener != null;
        this.listener = messageListener;
    }

    public void commit() throws JMSException {
        this.session.commit();
    }

    public void rollback() throws JMSException {
        this.session.rollback();
    }

    public void recover() throws JMSException {
        this.session.recover();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        block7: {
            String string = this.getSyncAwaitingID();
            if (string != null) {
                try {
                    String string2 = message.getJMSCorrelationID();
                    if (string2 == null || !string2.equals(string)) break block7;
                    this.syncReplyMessage = message;
                    this.setSyncAwaitingID(null);
                    JMSLightTransceiver jMSLightTransceiver = this;
                    synchronized (jMSLightTransceiver) {
                        this.notify();
                    }
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
        }
        if (this.listener != null) {
            this.listener.onMessage(message);
        }
    }

    public void onException(JMSException jMSException) {
        if (!this.autoReconnect && this.excListener != null) {
            try {
                this.excListener.onException(jMSException);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.autoReconnect) {
            this.logger.log(Level.INFO, "Connection failure detected. Attempting to reconnect...");
            for (int i = 0; this.reconnectAttempts <= 0 || i < this.reconnectAttempts; ++i) {
                try {
                    this.open();
                    this.logger.log(Level.INFO, "Reconnected successfully");
                    return;
                }
                catch (Exception exception) {
                    this.logger.log(Level.INFO, "Reconnection failed... Attempt #" + (i + 1));
                    continue;
                }
            }
            if (this.excListener != null) {
                this.excListener.onException(new JMSException("Could not reconnect after " + this.reconnectAttempts + " attempts"));
            } else {
                this.logger.log(Level.SEVERE, "Could not reconnect after " + this.reconnectAttempts + " attempts", jMSException);
            }
        }
    }
}

