/*
 * Decompiled with CFR 0.152.
 */
package br.org.indt.jms;

import br.org.indt.jms.JMSUtil;
import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;

public class JMSDurableSubscriber {
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private Session session;
    private Topic topic;
    private MessageConsumer consumer;
    private MessageProducer replyProducer;

    public JMSDurableSubscriber(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, MessageListener messageListener, int n) throws JMSException {
        try {
            this.connectionFactory = JMSUtil.geConnectionFactory(string);
            this.connection = this.connectionFactory.createConnection(string2, string3);
            this.session = this.connection.createSession(n == 0, n);
            if (n == 2) {
                this.session.recover();
            }
            this.topic = JMSUtil.getTopic(string4);
            this.consumer = this.session.createDurableSubscriber(this.topic, string5, string6, bl);
            this.replyProducer = this.session.createProducer(null);
            this.consumer.setMessageListener(messageListener);
            this.connection.start();
        }
        catch (Exception exception) {
            JMSException jMSException = new JMSException("Unable to initialize durable subscriber. " + exception.getMessage());
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
    }

    public Message receive() throws JMSException {
        return this.consumer.receive();
    }

    public Message receive(long l) throws JMSException {
        return this.consumer.receive(l);
    }

    public Message receiveNoWait() throws JMSException {
        return this.consumer.receiveNoWait();
    }

    public void reply(Message message, Serializable serializable) throws JMSException {
        ObjectMessage objectMessage = this.session.createObjectMessage();
        objectMessage.setJMSCorrelationID(message.getJMSMessageID());
        objectMessage.setObject(serializable);
        this.replyProducer.send(message.getJMSReplyTo(), (Message)objectMessage);
    }

    public void commit() throws JMSException {
        this.session.commit();
    }

    public void rollback() throws JMSException {
        this.session.rollback();
    }

    public void recover() throws JMSException {
        this.session.recover();
    }

    public void close() throws JMSException {
        this.consumer.close();
        this.replyProducer.close();
        this.session.close();
    }
}

