/*
 * Decompiled with CFR 0.152.
 */
package br.org.indt.jms;

import br.org.indt.jms.JMSClient;
import br.org.indt.jms.JMSUtil;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;

public class JMSConsumer
extends JMSClient {
    private Connection connection;
    private Session session;
    private Session replySession;
    private Destination destination;
    private MessageConsumer consumer;
    private MessageProducer replyProducer;
    private String connectionFactoryName;
    private String connectionUsername;
    private String connectionPassword;
    private String destinationName;
    private String messageSelector;
    private MessageListener listener;
    private boolean noLocal;
    private int sessionMode;
    private Logger logger;

    public JMSConsumer(String string, String string2, String string3, String string4, String string5, boolean bl, MessageListener messageListener, int n) throws JMSException {
        try {
            this.connectionFactoryName = string;
            this.connectionUsername = string2;
            this.connectionPassword = string3;
            this.destinationName = string4;
            this.sessionMode = n;
            this.listener = messageListener;
            this.noLocal = bl;
            this.messageSelector = string5;
            this.open();
        }
        catch (JMSException jMSException) {
            throw jMSException;
        }
        catch (Exception exception) {
            JMSException jMSException = new JMSException("General exception initializing JMSConsumer.");
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
    }

    public Message receive() throws JMSException {
        return this.consumer.receive();
    }

    public Message receive(long l) throws JMSException {
        return this.consumer.receive(l);
    }

    public Message receiveNoWait() throws JMSException {
        return this.consumer.receiveNoWait();
    }

    public void reply(Message message, Serializable serializable) throws JMSException {
        if (this.logger.isLoggable(Level.FINEST) && message != null) {
            this.logger.finest("Replying to: " + message.getJMSMessageID() + " with: " + serializable);
        }
        ObjectMessage objectMessage = this.session.createObjectMessage();
        objectMessage.setJMSCorrelationID(message.getJMSMessageID());
        objectMessage.setObject(serializable);
        this.replyProducer.send(message.getJMSReplyTo(), (Message)objectMessage);
    }

    public void commit() throws JMSException {
        this.session.commit();
        this.replySession.commit();
    }

    public void rollback() throws JMSException {
        this.session.rollback();
        this.replySession.rollback();
    }

    public void recover() throws JMSException {
        this.session.recover();
    }

    public void open() throws JMSException, Exception {
        this.connection = this.getConnection(this.connectionFactoryName, this.connectionUsername, this.connectionPassword);
        this.session = this.connection.createSession(this.sessionMode == 0, this.sessionMode);
        this.replySession = this.connection.createSession(this.sessionMode == 0, this.sessionMode);
        if (this.sessionMode == 2) {
            this.session.recover();
        }
        this.destination = JMSUtil.getDestination(this.destinationName);
        this.consumer = this.session.createConsumer(this.destination, this.messageSelector, this.noLocal);
        this.replyProducer = this.replySession.createProducer(null);
        this.consumer.setMessageListener(this.listener);
        this.connection.start();
    }

    public void close() throws JMSException {
        this.consumer.close();
        this.replyProducer.close();
        this.session.close();
        this.replySession.close();
        this.closeConnection(this.connectionFactoryName, this.connectionUsername);
    }

    public void onException(JMSException jMSException) {
        if (!this.autoReconnect && this.excListener != null) {
            try {
                this.excListener.onException(jMSException);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.autoReconnect) {
            this.logger.log(Level.WARNING, "Connection failure detected. Attempting to reconnect...", jMSException);
            for (int i = 0; this.reconnectAttempts <= 0 || i < this.reconnectAttempts; ++i) {
                try {
                    this.open();
                    this.logger.log(Level.INFO, "Reconnected successfully");
                    return;
                }
                catch (Exception exception) {
                    this.logger.log(Level.INFO, "Reconnection failed... Attempt #" + (i + 1));
                    continue;
                }
            }
            if (this.excListener != null) {
                this.excListener.onException(new JMSException("Could not reconnect after " + this.reconnectAttempts + " attempts"));
            } else {
                this.logger.log(Level.SEVERE, "Could not reconnect after " + this.reconnectAttempts + " attempts", jMSException);
            }
        }
    }
}

