/*
 * Decompiled with CFR 0.152.
 */
package br.org.indt.jms;

import br.org.indt.jms.JMSUtil;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;

public abstract class JMSClient
implements ExceptionListener {
    public static final int SESSION_MODE_AUTO_ACKNOWLEDGE = 1;
    public static final int SESSION_MODE_CLIENT_ACKNOWLEDGE = 2;
    public static final int SESSION_MODE_DUPS_OK_ACKNOWLEDGE = 3;
    public static final int SESSION_MODE_TRANSACTED = 0;
    public static final int DEFAULT_RECONNECT_ATTEMPTS = 5;
    private static Hashtable connectionsTable;
    protected ExceptionListener excListener;
    protected int reconnectAttempts = 5;
    protected boolean autoReconnect = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JMSClient() {
        Class<JMSClient> clazz = JMSClient.class;
        synchronized (JMSClient.class) {
            if (connectionsTable == null) {
                connectionsTable = new Hashtable();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected synchronized Connection getConnection(String string, String string2, String string3) throws Exception {
        ConnectionHolder connectionHolder = (ConnectionHolder)connectionsTable.get(this.getConnectionId(string, string2));
        if (connectionHolder == null) {
            ConnectionFactory connectionFactory = JMSUtil.geConnectionFactory(string);
            Connection connection = connectionFactory.createConnection(string2, string3);
            connectionHolder = new ConnectionHolder(string, string2);
            connectionHolder.connection = connection;
            connection.setExceptionListener((ExceptionListener)connectionHolder);
            connectionsTable.put(this.getConnectionId(string, string2), connectionHolder);
        }
        connectionHolder.clients.add(this);
        ++connectionHolder.usageCount;
        return connectionHolder.connection;
    }

    protected synchronized void closeConnection(String string, String string2) throws JMSException {
        ConnectionHolder connectionHolder = (ConnectionHolder)connectionsTable.get(this.getConnectionId(string, string2));
        if (connectionHolder != null) {
            --connectionHolder.usageCount;
            connectionHolder.clients.remove(this);
            if (connectionHolder.usageCount == 0) {
                connectionsTable.remove(this.getConnectionId(string, string2));
                connectionHolder.connection.close();
            }
        }
    }

    private synchronized void removeConnectionHolder(String string, String string2) {
        connectionsTable.remove(this.getConnectionId(string, string2));
    }

    private String getConnectionId(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.append(string).append('_').append(string2).toString();
    }

    public static void shutdown() {
        try {
            JMSUtil.closeContext();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ExceptionListener getExcListener() {
        return this.excListener;
    }

    public void setExcListener(ExceptionListener exceptionListener) {
        this.excListener = exceptionListener;
    }

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public void setReconnectAttempts(int n) {
        this.reconnectAttempts = n;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public void setAutoReconnect(boolean bl) {
        this.autoReconnect = bl;
    }

    private class ConnectionHolder
    implements ExceptionListener {
        String connectionFactoryName;
        String connectionUsername;
        Connection connection;
        Vector clients;
        int usageCount;

        public ConnectionHolder(String string, String string2) {
            this.connectionFactoryName = string;
            this.connectionUsername = string2;
            this.clients = new Vector();
        }

        public void onException(JMSException jMSException) {
            JMSClient.this.removeConnectionHolder(this.connectionFactoryName, this.connectionUsername);
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                JMSUtil.geConnectionFactory(this.connectionFactoryName);
            }
            catch (Exception exception) {
                JMSClient.shutdown();
            }
            this.notifyException(jMSException);
        }

        private void notifyException(JMSException jMSException) {
            for (int i = 0; i < this.clients.size(); ++i) {
                try {
                    ((JMSClient)this.clients.elementAt(i)).onException(jMSException);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

