/*
 * Decompiled with CFR 0.152.
 */
package br.org.indt.smslib.http;

import br.org.indt.smslib.http.HTTPHeader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.smslib.AGateway;

public class HTTPGateway
extends AGateway {
    public HTTPGateway(String id) {
        super(id);
    }

    public List<String> HttpPost(URL url, List<HTTPHeader> requestList) throws IOException {
        String line;
        ArrayList<String> responseList = new ArrayList<String>();
        this.logInfo("HTTP POST: " + url);
        URLConnection con = url.openConnection();
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        OutputStreamWriter out = new OutputStreamWriter(con.getOutputStream());
        StringBuffer req = new StringBuffer();
        int i = 0;
        int n = requestList.size();
        while (i < n) {
            if (i != 0) {
                req.append("&");
            }
            req.append(requestList.get((int)i).key);
            req.append("=");
            if (requestList.get((int)i).unicode) {
                StringBuffer tmp = new StringBuffer(200);
                byte[] uniBytes = requestList.get((int)i).value.getBytes("UnicodeBigUnmarked");
                int j = 0;
                while (j < uniBytes.length) {
                    tmp.append(Integer.toHexString(uniBytes[j]).length() == 1 ? "0" + Integer.toHexString(uniBytes[j]) : Integer.toHexString(uniBytes[j]));
                    ++j;
                }
                req.append(tmp.toString().replaceAll("ff", ""));
            } else {
                req.append(requestList.get((int)i).value);
            }
            ++i;
        }
        out.write(req.toString());
        out.flush();
        out.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        while ((line = in.readLine()) != null) {
            responseList.add(line);
        }
        in.close();
        return responseList;
    }

    public List<String> HttpGet(URL url) throws IOException {
        String inputLine;
        ArrayList<String> responseList = new ArrayList<String>();
        this.logInfo("HTTP GET: " + url);
        URLConnection con = url.openConnection();
        con.setAllowUserInteraction(false);
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        while ((inputLine = in.readLine()) != null) {
            responseList.add(inputLine);
        }
        in.close();
        return responseList;
    }

    public String ExpandHttpHeaders(List<HTTPHeader> httpHeaderList) {
        StringBuffer buffer = new StringBuffer();
        for (HTTPHeader h : httpHeaderList) {
            buffer.append(h.key);
            buffer.append("=");
            buffer.append(h.value);
            buffer.append("&");
        }
        return buffer.toString();
    }

    public String calculateMD5(String in) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] pre_md5 = md.digest(in.getBytes("LATIN1"));
            String md5 = "";
            int i = 0;
            while (i < 16) {
                md5 = pre_md5[i] < 0 ? String.valueOf(md5) + Integer.toHexString(256 + pre_md5[i]) : (pre_md5[i] > 15 ? String.valueOf(md5) + Integer.toHexString(pre_md5[i]) : String.valueOf(md5) + "0" + Integer.toHexString(pre_md5[i]));
                ++i;
            }
            return md5;
        }
        catch (UnsupportedEncodingException ex) {
            this.logError("Unsupported encoding.", ex);
            return "";
        }
        catch (NoSuchAlgorithmException ex) {
            this.logError("No such algorithm.", ex);
            return "";
        }
    }
}

