/*
 * Decompiled with CFR 0.152.
 */
package br.org.indt.smslib.clickatell;

import br.org.indt.smslib.http.HTTPGateway;
import br.org.indt.smslib.http.HTTPHeader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.smslib.GatewayException;
import org.smslib.Message;
import org.smslib.OutboundBinaryMessage;
import org.smslib.OutboundMessage;
import org.smslib.OutboundWapSIMessage;
import org.smslib.StatusReportMessage;
import org.smslib.TimeoutException;

public class ClickatellHTTPGateway
extends HTTPGateway {
    String apiId;
    String username;
    String password;
    String sessionId;
    KeepAlive keepAlive;
    boolean secure;
    Object SYNC_Commander;
    String HTTP = "http://";
    String HTTPS = "https://";
    String URL_BALANCE = "api.clickatell.com/http/getbalance";
    String URL_COVERAGE = "api.clickatell.com/utils/routeCoverage.php";
    String URL_QUERYMSG = "api.clickatell.com/http/querymsg";
    String URL_AUTH = "api.clickatell.com/http/auth";
    String URL_PING = "api.clickatell.com/http/ping";
    String URL_SENDMSG = "api.clickatell.com/http/sendmsg";
    String URL_SENDWAPSI = "api.clickatell.com/mms/si_push";

    public ClickatellHTTPGateway(String id, String apiId, String username, String password) {
        super(id);
        this.started = false;
        this.apiId = apiId;
        this.username = username;
        this.password = password;
        this.sessionId = null;
        this.from = "";
        this.secure = false;
        this.SYNC_Commander = new Object();
        this.attributes = 93;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.logInfo("Starting gateway.");
        this.connect();
        super.startGateway();
    }

    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.logInfo("Stopping gateway.");
        super.stopGateway();
        this.sessionId = null;
        if (this.keepAlive != null) {
            this.keepAlive.interrupt();
            this.keepAlive.join();
            this.keepAlive = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float queryBalance() throws TimeoutException, GatewayException, IOException, InterruptedException {
        List<String> response;
        ArrayList<HTTPHeader> request = new ArrayList<HTTPHeader>();
        if (this.sessionId == null) {
            throw new GatewayException("Internal Clickatell Gateway error.");
        }
        URL url = new URL(String.valueOf(this.secure ? this.HTTPS : this.HTTP) + this.URL_BALANCE);
        request.add(new HTTPHeader("session_id", this.sessionId, false));
        Object object = this.SYNC_Commander;
        synchronized (object) {
            response = this.HttpPost(url, request);
        }
        if (response.get(0).indexOf("Credit:") == 0) {
            return Float.parseFloat(response.get(0).substring(response.get(0).indexOf(58) + 1));
        }
        return -1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queryCoverage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        List<String> response;
        ArrayList<HTTPHeader> request = new ArrayList<HTTPHeader>();
        if (this.sessionId == null) {
            throw new GatewayException("Internal Clickatell Gateway error.");
        }
        URL url = new URL(String.valueOf(this.secure ? this.HTTPS : this.HTTP) + this.URL_COVERAGE);
        request.add(new HTTPHeader("session_id", this.sessionId, false));
        request.add(new HTTPHeader("msisdn", msg.getRecipient().substring(1), false));
        Object object = this.SYNC_Commander;
        synchronized (object) {
            response = this.HttpPost(url, request);
        }
        return response.get(0).indexOf("OK") == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusReportMessage.DeliveryStatuses queryMessage(String refNo) throws TimeoutException, GatewayException, IOException, InterruptedException {
        List<String> response;
        ArrayList<HTTPHeader> request = new ArrayList<HTTPHeader>();
        if (this.sessionId == null) {
            throw new GatewayException("Internal Clickatell Gateway error.");
        }
        URL url = new URL(String.valueOf(this.secure ? this.HTTPS : this.HTTP) + this.URL_QUERYMSG);
        request.add(new HTTPHeader("session_id", this.sessionId, false));
        request.add(new HTTPHeader("apimsgid", refNo, false));
        Object object = this.SYNC_Commander;
        synchronized (object) {
            response = this.HttpPost(url, request);
        }
        int pos = response.get(0).indexOf("Status:");
        this.deliveryErrorCode = Integer.parseInt(response.get(0).substring(pos + 7).trim());
        switch (this.deliveryErrorCode) {
            case 1: {
                return StatusReportMessage.DeliveryStatuses.UNKNOWN;
            }
            case 2: 
            case 3: 
            case 8: 
            case 11: {
                return StatusReportMessage.DeliveryStatuses.KEEPTRYING;
            }
            case 4: {
                return StatusReportMessage.DeliveryStatuses.DELIVERED;
            }
            case 5: 
            case 6: 
            case 7: {
                return StatusReportMessage.DeliveryStatuses.ABORTED;
            }
            case 9: 
            case 10: {
                return StatusReportMessage.DeliveryStatuses.ABORTED;
            }
            case 12: {
                return StatusReportMessage.DeliveryStatuses.ABORTED;
            }
        }
        return StatusReportMessage.DeliveryStatuses.UNKNOWN;
    }

    void connect() throws GatewayException, IOException {
        try {
            if (!this.authenticate()) {
                throw new GatewayException("Cannot authenticate to Clickatell.");
            }
            this.keepAlive = new KeepAlive();
        }
        catch (MalformedURLException e) {
            throw new GatewayException("Internal Clickatell Gateway error.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean authenticate() throws IOException, MalformedURLException {
        List<String> response;
        ArrayList<HTTPHeader> request = new ArrayList<HTTPHeader>();
        this.logDebug("Authenticate().");
        URL url = new URL(String.valueOf(this.secure ? this.HTTPS : this.HTTP) + this.URL_AUTH);
        request.add(new HTTPHeader("api_id", this.apiId, false));
        request.add(new HTTPHeader("user", this.username, false));
        request.add(new HTTPHeader("password", this.password, false));
        Object object = this.SYNC_Commander;
        synchronized (object) {
            response = this.HttpPost(url, request);
        }
        if (response.get(0).indexOf("ERR:") == 0) {
            this.sessionId = null;
            return false;
        }
        this.sessionId = response.get(0).substring(4);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean ping() throws IOException, MalformedURLException {
        List<String> response;
        ArrayList<HTTPHeader> request = new ArrayList<HTTPHeader>();
        this.logDebug("Ping()");
        URL url = new URL(String.valueOf(this.secure ? this.HTTPS : this.HTTP) + this.URL_PING);
        request.add(new HTTPHeader("session_id", this.sessionId, false));
        Object object = this.SYNC_Commander;
        synchronized (object) {
            response = this.HttpPost(url, request);
        }
        return response.get(0).indexOf("ERR:") != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        URL url;
        boolean ok;
        int requestFeatures;
        ArrayList<HTTPHeader> request;
        block42: {
            request = new ArrayList<HTTPHeader>();
            requestFeatures = 0;
            ok = false;
            if (this.sessionId == null) {
                this.logError("No session defined.");
                msg.setFailureCause(OutboundMessage.FailureCauses.GATEWAY_FAILURE);
                return false;
            }
            this.logDebug("sendMessage()");
            if (msg.getType() == Message.MessageTypes.OUTBOUND) {
                url = new URL(String.valueOf(this.secure ? this.HTTPS : this.HTTP) + this.URL_SENDMSG);
                break block42;
            }
            if (msg.getType() == Message.MessageTypes.WAPSI) {
                url = new URL(String.valueOf(this.secure ? this.HTTPS : this.HTTP) + this.URL_SENDWAPSI);
                break block42;
            }
            msg.setFailureCause(OutboundMessage.FailureCauses.BAD_FORMAT);
            this.logError("Incorrect message format.");
            return false;
        }
        try {
            List<String> response;
            request.add(new HTTPHeader("session_id", this.sessionId, false));
            request.add(new HTTPHeader("to", msg.getRecipient().substring(1), false));
            request.add(new HTTPHeader("concat", "3", false));
            if (msg.getPriority() == OutboundMessage.MessagePriorities.LOW) {
                request.add(new HTTPHeader("queue", "3", false));
            } else if (msg.getPriority() == OutboundMessage.MessagePriorities.NORMAL) {
                request.add(new HTTPHeader("queue", "2", false));
            } else if (msg.getPriority() == OutboundMessage.MessagePriorities.HIGH) {
                request.add(new HTTPHeader("queue", "1", false));
            }
            if (msg.getSrcPort() != -1 || msg.getDstPort() != -1 || msg instanceof OutboundBinaryMessage) {
                msg.getPDU("", 0, 0);
                request.add(new HTTPHeader("udh", msg.getUDH(), false));
                request.add(new HTTPHeader("data", msg.getEncodedText(), false));
            } else {
                if (msg.getFrom() != null && msg.getFrom().length() != 0) {
                    request.add(new HTTPHeader("from", msg.getFrom(), false));
                } else if (this.from != null && this.from.length() != 0) {
                    request.add(new HTTPHeader("from", this.from, false));
                }
                if (msg.getFlashSms()) {
                    request.add(new HTTPHeader("msg_type", "SMS_FLASH", false));
                }
                if (msg.getType() == Message.MessageTypes.OUTBOUND) {
                    if (msg.getEncoding() == Message.MessageEncodings.ENC7BIT) {
                        request.add(new HTTPHeader("text", msg.getText(), false));
                    } else if (msg.getEncoding() == Message.MessageEncodings.ENCUCS2) {
                        request.add(new HTTPHeader("unicode", "1", false));
                        request.add(new HTTPHeader("text", msg.getText(), true));
                    }
                } else if (msg.getType() == Message.MessageTypes.WAPSI) {
                    request.add(new HTTPHeader("si_id", String.valueOf(msg.getMessageId()), false));
                    if (((OutboundWapSIMessage)msg).getCreateDate() != null) {
                        request.add(new HTTPHeader("si_created", this.formatDateUTC(((OutboundWapSIMessage)msg).getCreateDate()), false));
                    }
                    if (((OutboundWapSIMessage)msg).getExpireDate() != null) {
                        request.add(new HTTPHeader("si_expires", this.formatDateUTC(((OutboundWapSIMessage)msg).getExpireDate()), false));
                    }
                    request.add(new HTTPHeader("si_action", this.formatSignal(((OutboundWapSIMessage)msg).getSignal()), false));
                    request.add(new HTTPHeader("si_url", ((OutboundWapSIMessage)msg).getUrl().toString(), false));
                    request.add(new HTTPHeader("si_text", msg.getText(), false));
                }
                if (msg.getStatusReport()) {
                    request.add(new HTTPHeader("callback", "3", false));
                    request.add(new HTTPHeader("deliv_ack", "1", false));
                }
                if (this.from != null && this.from.length() != 0 || msg.getFrom() != null && msg.getFrom().length() != 0) {
                    requestFeatures += 48;
                }
                if (msg.getFlashSms()) {
                    requestFeatures += 512;
                }
                if (msg.getStatusReport()) {
                    requestFeatures += 8192;
                }
                request.add(new HTTPHeader("req_feat", "" + requestFeatures, false));
            }
            Object object = this.SYNC_Commander;
            synchronized (object) {
                response = this.HttpPost(url, request);
            }
            if (response.get(0).indexOf("ID:") == 0) {
                msg.setRefNo(response.get(0).substring(4));
                msg.setDispatchDate(new Date());
                msg.setGatewayId(this.gtwId);
                msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
                this.incOutboundMessageCount();
                ok = true;
            } else if (response.get(0).indexOf("ERR:") == 0) {
                switch (Integer.parseInt(response.get(0).substring(5, 8))) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        msg.setFailureCause(OutboundMessage.FailureCauses.GATEWAY_AUTH);
                        break;
                    }
                    case 101: 
                    case 102: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 112: 
                    case 116: 
                    case 120: {
                        msg.setFailureCause(OutboundMessage.FailureCauses.BAD_FORMAT);
                        break;
                    }
                    case 114: {
                        msg.setFailureCause(OutboundMessage.FailureCauses.NO_ROUTE);
                        break;
                    }
                    case 301: 
                    case 302: {
                        msg.setFailureCause(OutboundMessage.FailureCauses.NO_CREDIT);
                        break;
                    }
                    default: {
                        msg.setFailureCause(OutboundMessage.FailureCauses.UNKNOWN);
                    }
                }
                msg.setRefNo(null);
                msg.setDispatchDate(null);
                msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                ok = false;
            }
        }
        catch (MalformedURLException e) {
            this.logError("Malformed URL.", e);
        }
        catch (IOException e) {
            this.logError("I/O error.", e);
        }
        return ok;
    }

    String formatDateUTC(Date d) {
        String strDate = "";
        String tmp = "";
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        strDate = String.valueOf(cal.get(1));
        tmp = String.valueOf(cal.get(2) + 1);
        if (tmp.length() != 2) {
            tmp = "0" + tmp;
        }
        strDate = String.valueOf(strDate) + "-" + tmp;
        tmp = String.valueOf(cal.get(5));
        if (tmp.length() != 2) {
            tmp = "0" + tmp;
        }
        strDate = String.valueOf(strDate) + "-" + tmp;
        tmp = String.valueOf(cal.get(11));
        if (tmp.length() != 2) {
            tmp = "0" + tmp;
        }
        strDate = String.valueOf(strDate) + "T" + tmp;
        tmp = String.valueOf(cal.get(12));
        if (tmp.length() != 2) {
            tmp = "0" + tmp;
        }
        strDate = String.valueOf(strDate) + ":" + tmp;
        tmp = String.valueOf(cal.get(13));
        if (tmp.length() != 2) {
            tmp = "0" + tmp;
        }
        strDate = String.valueOf(strDate) + ":" + tmp + "Z";
        return strDate;
    }

    String formatSignal(OutboundWapSIMessage.WapSISignals signal) {
        if (signal == OutboundWapSIMessage.WapSISignals.NONE) {
            return "signal-none";
        }
        if (signal == OutboundWapSIMessage.WapSISignals.LOW) {
            return "signal-low";
        }
        if (signal == OutboundWapSIMessage.WapSISignals.MEDIUM) {
            return "signal-medium";
        }
        if (signal == OutboundWapSIMessage.WapSISignals.HIGH) {
            return "signal-high";
        }
        if (signal == OutboundWapSIMessage.WapSISignals.DELETE) {
            return "signal-delete";
        }
        return "signal-none";
    }

    class KeepAlive
    extends Thread {
        public KeepAlive() {
            this.setPriority(1);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClickatellHTTPGateway.this.logDebug("KeepAlive thread started.");
            block6: while (true) {
                try {
                    while (true) {
                        KeepAlive.sleep(600000L);
                        if (ClickatellHTTPGateway.this.sessionId == null) break block6;
                        ClickatellHTTPGateway.this.logDebug("** KeepAlive START **");
                        Object object = ClickatellHTTPGateway.this.SYNC_Commander;
                        synchronized (object) {
                            ClickatellHTTPGateway.this.ping();
                        }
                        ClickatellHTTPGateway.this.logDebug("** KeepAlive END **");
                    }
                }
                catch (InterruptedException e) {
                    if (ClickatellHTTPGateway.this.sessionId != null) continue;
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
            ClickatellHTTPGateway.this.logDebug("KeepAlive thread ended.");
        }
    }
}

