/*
 * Decompiled with CFR 0.152.
 */
package br.org.indt.smslib.clickatell;

import br.org.indt.smslib.SMSService;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.smslib.AGateway;
import org.smslib.IInboundMessageNotification;
import org.smslib.InboundMessage;
import org.smslib.StatusReportMessage;

public abstract class AClickatellServelt
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static String API_ID = "api_id";
    public static String FROM = "from";
    public static String TO = "to";
    public static String TIMESTAMP = "timestamp";
    public static String API_MSG_ID = "apiMsgId";
    public static String CLI_MSG_ID = "cliMsgId";
    public static String MO_MSG_ID = "moMsgId";
    public static String STATUS = "status";
    public static String CHARGE = "charge";
    public static String TEXT = "text";
    public static String CHARSET = "charset";
    public static String UDH = "udh";

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        InboundMessage msg;
        PrintWriter writer = res.getWriter();
        writer.println("INdT SMS Lib - Receiving a Inbound Message...\n");
        Enumeration params = req.getParameterNames();
        String parameter = null;
        while (params.hasMoreElements()) {
            parameter = (String)params.nextElement();
            res.getWriter().println(String.valueOf(parameter) + ": " + req.getParameter(parameter) + "\n");
        }
        String moMsgId = req.getParameter(MO_MSG_ID);
        String apiMsgId = req.getParameter(API_MSG_ID);
        String from = req.getParameter(FROM);
        String to = req.getParameter(TO);
        String timestamp = req.getParameter(TIMESTAMP);
        String apiId = req.getParameter(API_ID);
        if (moMsgId != null && !moMsgId.equals("")) {
            String text = req.getParameter(TEXT);
            String charset = req.getParameter(CHARSET);
            String udh = req.getParameter(UDH);
            InboundMessage inboundMessage = new InboundMessage(new Date(), from, text, 0, "");
            inboundMessage.setId(moMsgId);
            msg = inboundMessage;
        } else {
            String cliMsgId = req.getParameter(CLI_MSG_ID);
            String status = req.getParameter(STATUS);
            String charge = req.getParameter(CHARGE);
            StatusReportMessage reportMessage = new StatusReportMessage(apiMsgId, 0, "", new Date(), new Date());
            reportMessage.setDate(new Date());
            reportMessage.setStatus(this.getDeliveryStatus(status));
            msg = reportMessage;
        }
        SMSService service = SMSService.getSmsService();
        AGateway gateway = service.getGateway(this.getGatwayId());
        if (gateway != null && msg != null) {
            msg.setGatewayId(this.getGatwayId());
            IInboundMessageNotification notification = gateway.getInboundNotification();
            if (notification != null) {
                notification.process(this.getGatwayId(), msg.getType(), msg);
            }
        }
    }

    private StatusReportMessage.DeliveryStatuses getDeliveryStatus(String status) {
        StatusReportMessage.DeliveryStatuses result = StatusReportMessage.DeliveryStatuses.UNKNOWN;
        try {
            int s = Integer.parseInt(status);
            switch (s) {
                case 4: {
                    result = StatusReportMessage.DeliveryStatuses.DELIVERED;
                    break;
                }
                case 2: 
                case 3: 
                case 11: {
                    result = StatusReportMessage.DeliveryStatuses.KEEPTRYING;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 12: {
                    result = StatusReportMessage.DeliveryStatuses.ABORTED;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public abstract String getGatwayId();
}

