/*
 * Decompiled with CFR 0.152.
 */
package br.org.indt.ndg.server.util;

import br.org.indt.ndg.common.SystemUtils;
import br.org.indt.ndg.common.exception.MSMApplicationException;
import br.org.indt.ndg.server.survey.SurveyHandler;
import br.org.indt.ndg.server.util.Configuration;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class PropertiesUtil {
    public static String PROPERTIES_CORE_FILE = "msm-core.properties";
    public static String SETTINGS_FILE = "msm-settings.properties";
    public static String SURVEY_PROTOCOL_FILE = "survey_protocol.properties";
    public static String JNDI_PROPERTIES = "jndi.properties";
    public static String PROPERTIES_VERSION_FILE = "version.properties";
    public static String SURVEY_ROOT = "SURVEY_ROOT";
    private static Properties core_properties = null;
    private static Properties jndi_properties = null;
    private static Properties version_properties = null;
    private static Properties settings_properties = null;
    private static Properties property_protocol_survey = null;
    private static final Logger log = Logger.getLogger((String)"ndg");

    public static Properties loadFileProperty(String string) {
        Properties properties = null;
        if (core_properties == null) {
            try {
                core_properties = new Configuration(PROPERTIES_CORE_FILE);
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
                return null;
            }
        }
        if (jndi_properties == null) {
            try {
                jndi_properties = new Configuration(JNDI_PROPERTIES);
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
                return null;
            }
        }
        if (version_properties == null) {
            try {
                version_properties = new Configuration(PROPERTIES_VERSION_FILE);
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
                return null;
            }
        }
        try {
            settings_properties = new Configuration(SETTINGS_FILE);
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            return null;
        }
        if (property_protocol_survey == null) {
            try {
                property_protocol_survey = new Configuration(SURVEY_PROTOCOL_FILE);
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
                return null;
            }
        }
        if (string.equals(PROPERTIES_CORE_FILE)) {
            properties = core_properties;
        } else if (string.equals(SETTINGS_FILE)) {
            properties = settings_properties;
        } else if (string.equals(SURVEY_PROTOCOL_FILE)) {
            properties = property_protocol_survey;
        } else if (string.equals(JNDI_PROPERTIES)) {
            properties = jndi_properties;
        } else if (string.equals(PROPERTIES_VERSION_FILE)) {
            properties = version_properties;
        }
        return properties;
    }

    public static Properties loadProperty() {
        SurveyHandler surveyHandler = null;
        try {
            InitialContext initialContext = new InitialContext();
            surveyHandler = (SurveyHandler)initialContext.lookup("ndg-core/SurveyHandlerBean/remote");
            core_properties = surveyHandler.getProperties();
        }
        catch (NamingException namingException) {
            log.error((Object)"Error while loading Properties.", (Throwable)namingException);
        }
        catch (MSMApplicationException mSMApplicationException) {
            log.error((Object)"Error while loading Properties.", (Throwable)mSMApplicationException);
        }
        return core_properties;
    }

    public static String getString(String string) {
        if (core_properties == null && (core_properties = PropertiesUtil.loadProperty()) == null) {
            return null;
        }
        return core_properties.getProperty(string);
    }

    public static String[] getStringsComaSepareted(String string) {
        if (core_properties == null && (core_properties = PropertiesUtil.loadProperty()) == null) {
            return null;
        }
        String string2 = core_properties.getProperty(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSettings(Properties properties) {
        OutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(System.getProperty("jboss.server.home.dir") + SystemUtils.FILE_SEP + "conf" + SystemUtils.FILE_SEP + SETTINGS_FILE);
            properties.store(outputStream, "");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                outputStream.flush();
                ((FileOutputStream)outputStream).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

