/*
 * Decompiled with CFR 0.152.
 */
package br.org.indt.ndg.server.client;

import br.org.indt.ndg.common.Deploy;
import br.org.indt.ndg.common.ResultParser;
import br.org.indt.ndg.common.ResultXml;
import br.org.indt.ndg.common.SurveyXML;
import br.org.indt.ndg.common.exception.DeviceHasRelationshipException;
import br.org.indt.ndg.common.exception.EmailNotSentException;
import br.org.indt.ndg.common.exception.ImeiHasRelationshipException;
import br.org.indt.ndg.common.exception.ImeiLimitReachedException;
import br.org.indt.ndg.common.exception.JadDownloadException;
import br.org.indt.ndg.common.exception.MSMApplicationException;
import br.org.indt.ndg.common.exception.MSMSystemException;
import br.org.indt.ndg.common.exception.ModemException;
import br.org.indt.ndg.common.exception.ResultNotParsedException;
import br.org.indt.ndg.common.exception.SurveyFileAlreadyExistsException;
import br.org.indt.ndg.common.exception.SurveyHasRelationshipException;
import br.org.indt.ndg.common.exception.SurveyNotFoundException;
import br.org.indt.ndg.common.exception.UserEmailNotValidatedException;
import br.org.indt.ndg.common.exception.UserHasRelationshipException;
import br.org.indt.ndg.common.exception.UserLimitReachedException;
import br.org.indt.ndg.common.exception.UserNotFoundException;
import br.org.indt.ndg.common.exception.UserNullException;
import br.org.indt.ndg.common.exception.UserUnknownException;
import br.org.indt.ndg.server.authentication.UserManager;
import br.org.indt.ndg.server.client.DeviceVO;
import br.org.indt.ndg.server.client.ImeiVO;
import br.org.indt.ndg.server.client.RoleVO;
import br.org.indt.ndg.server.client.SurveyVO;
import br.org.indt.ndg.server.client.TransactionLogVO;
import br.org.indt.ndg.server.client.UserVO;
import br.org.indt.ndg.server.client.WizardVO;
import br.org.indt.ndg.server.controller.QueryInputOutputVO;
import br.org.indt.ndg.server.controller.UserBalanceVO;
import br.org.indt.ndg.server.imei.DeviceManager;
import br.org.indt.ndg.server.imei.IMEIManager;
import br.org.indt.ndg.server.mail.MessageManager;
import br.org.indt.ndg.server.mail.SendTextSms;
import br.org.indt.ndg.server.pojo.NdgUser;
import br.org.indt.ndg.server.pojo.Survey;
import br.org.indt.ndg.server.result.ResultHandler;
import br.org.indt.ndg.server.sms.SmsHandlerFactory;
import br.org.indt.ndg.server.sms.vo.SMSMessageVO;
import br.org.indt.ndg.server.survey.SurveyHandler;
import br.org.indt.ndg.server.transaction.TransactionLogManager;
import br.org.indt.ndg.server.util.FileUtil;
import br.org.indt.ndg.server.util.PropertiesUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.hibernate.exception.ConstraintViolationException;

public class MSMBusinessDelegate {
    private InitialContext initialContext;
    private UserManager userManager;
    private IMEIManager imeiManager;
    private DeviceManager deviceManager;
    private SurveyHandler surveyHandler;
    private ResultHandler resultHandler;
    private MessageManager messageManager;
    private TransactionLogManager transactionlogManager;
    private static final int EMAIL_SUBJECT_RECOVERY_PASSWORD = 0;
    private static final int EMAIL_SUBJECT_REQUEST_ACCESS = 1;
    private static final String SMS_NEW_SURVEY_NOTIFICATION = "You have to download the Survey:";
    private static final Logger log = Logger.getLogger((String)"MSMBD");

    public MSMBusinessDelegate() {
        try {
            this.initialContext = new InitialContext();
            this.userManager = (UserManager)this.initialContext.lookup("ndg-core/UserManagerBean/remote");
            this.imeiManager = (IMEIManager)this.initialContext.lookup("ndg-core/IMEIManagerBean/remote");
            this.surveyHandler = (SurveyHandler)this.initialContext.lookup("ndg-core/SurveyHandlerBean/remote");
            this.resultHandler = (ResultHandler)this.initialContext.lookup("ndg-core/ResultHandlerBean/remote");
            this.deviceManager = (DeviceManager)this.initialContext.lookup("ndg-core/DeviceManagerBean/remote");
            this.messageManager = (MessageManager)this.initialContext.lookup("ndg-core/MessageManagerBean/remote");
            this.transactionlogManager = (TransactionLogManager)this.initialContext.lookup("ndg-core/TransactionLogManagerBean/remote");
            System.out.println("InitialContext - using property file");
        }
        catch (NamingException namingException) {
            System.out.println("InitialContext Hard Coded");
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            hashtable.put("java.naming.provider.url", "localhost:1099");
            try {
                this.initialContext = new InitialContext(hashtable);
                this.userManager = (UserManager)this.initialContext.lookup("ndg-core/UserManagerBean/remote");
                this.imeiManager = (IMEIManager)this.initialContext.lookup("ndg-core/IMEIManagerBean/remote");
                this.surveyHandler = (SurveyHandler)this.initialContext.lookup("ndg-core/SurveyHandlerBean/remote");
                this.resultHandler = (ResultHandler)this.initialContext.lookup("ndg-core/ResultHandlerBean/remote");
                this.deviceManager = (DeviceManager)this.initialContext.lookup("ndg-core/DeviceManagerBean/remote");
                this.messageManager = (MessageManager)this.initialContext.lookup("ndg-core/MessageManagerBean/remote");
                this.transactionlogManager = (TransactionLogManager)this.initialContext.lookup("ndg-core/TransactionLogManagerBean/remote");
                System.err.println("InitialContext - using Hashtable");
            }
            catch (NamingException namingException2) {
                namingException2.printStackTrace();
            }
        }
        String string = this.getNDGVersion();
    }

    public Boolean isHostedMode() throws MSMApplicationException, MSMSystemException {
        String string = null;
        Properties properties = PropertiesUtil.loadFileProperty(PropertiesUtil.PROPERTIES_CORE_FILE);
        if (properties.containsKey("NDG_MODE")) {
            string = properties.getProperty("NDG_MODE");
        }
        Boolean bl = "hosted".equals(string);
        return bl;
    }

    public QueryInputOutputVO listSurveysDB(String string, QueryInputOutputVO queryInputOutputVO, Boolean bl) throws MSMApplicationException, MSMSystemException {
        log.info((Object)("listSurveyDB(): " + string));
        NdgUser ndgUser = this.findNdgUserByName(string);
        return this.surveyHandler.listSurveysDB(ndgUser, queryInputOutputVO, bl);
    }

    public Collection<SurveyVO> listSurveysByImeiDB(String string, String string2) throws MSMApplicationException, MSMSystemException {
        log.info((Object)("listSurveysByImeiDB(String imei, String status): " + string + "/" + string2));
        return this.surveyHandler.listSurveysByImeiDB(string, string2);
    }

    public QueryInputOutputVO listSurveysByImeiDBWithoutResults(String string, String string2, QueryInputOutputVO queryInputOutputVO) throws MSMApplicationException, MSMSystemException {
        log.info((Object)("listSurveysByImeiDBWithoutResults(String imei, String status): " + string + "/" + string2));
        return this.surveyHandler.listSurveysByImeiDBWithoutResults(string, string2, queryInputOutputVO);
    }

    public UserVO validateLogin(String string, String string2) throws MSMApplicationException {
        log.info((Object)("validateLogin(String username, String password): " + string));
        UserVO userVO = this.userManager.validateLogin(string, string2);
        return userVO;
    }

    public void createUser(String string, UserVO userVO) throws MSMApplicationException, MSMSystemException {
        NdgUser ndgUser = this.findNdgUserByName(string);
        if (!this.userManager.userAdminHasPositiveBalance(UserVO.USER_LIMIT, ndgUser.getUserAdmin())) {
            log.info((Object)("UserLimitReachedException: createUser(String username, UserVO vo): " + string + " / " + userVO.getUsername()));
            throw new UserLimitReachedException();
        }
        userVO.setUserAdmin(ndgUser.getUserAdmin());
        log.info((Object)("createUser(String username, UserVO vo): " + string + " / " + userVO.getUsername()));
        this.userManager.createUser(userVO);
        this.userManager.updateUserAdminBalance(UserVO.USER_LIMIT, ndgUser.getUserAdmin());
    }

    public void deleteUser(String string) throws MSMApplicationException {
        log.info((Object)("deleteUser(String _username): " + string));
        try {
            this.userManager.deleteUser(string);
        }
        catch (RuntimeException runtimeException) {
            Throwable throwable = runtimeException.getCause();
            for (int i = 0; i < 3 && throwable != null; ++i) {
                if (!((throwable = throwable.getCause()) instanceof ConstraintViolationException)) continue;
                throw new UserHasRelationshipException();
            }
            throw runtimeException;
        }
    }

    public void updateUser(UserVO userVO) throws MSMSystemException, MSMApplicationException {
        log.info((Object)("updateUser(UserVO user): " + userVO.getUsername()));
        this.userManager.updateUser(userVO);
    }

    public UserVO updatePassword(UserVO userVO) throws MSMApplicationException {
        UserVO userVO2 = this.userManager.checkValidationKey(userVO.getValidationKey());
        if (userVO2 == null) {
            throw new UserNotFoundException();
        }
        userVO2.setPassword(userVO.getPassword());
        this.userManager.updateUserPassword(userVO2);
        return userVO2;
    }

    public QueryInputOutputVO listAllUsers(String string, QueryInputOutputVO queryInputOutputVO) throws MSMApplicationException {
        QueryInputOutputVO queryInputOutputVO2 = new QueryInputOutputVO();
        if (string != null) {
            NdgUser ndgUser = this.findNdgUserByName(string);
            if (ndgUser != null) {
                queryInputOutputVO2 = this.userManager.listAllUsers(ndgUser.getUserAdmin(), queryInputOutputVO);
            }
        } else {
            throw new UserUnknownException();
        }
        return queryInputOutputVO2;
    }

    public Collection<RoleVO> listAllRoles() throws MSMApplicationException {
        return this.userManager.listAllRoles();
    }

    public void createIMEI(ImeiVO imeiVO) throws MSMApplicationException {
        NdgUser ndgUser = this.findNdgUserByName(imeiVO.getUserName());
        if (!this.userManager.userAdminHasPositiveBalance(UserVO.IMEI_LIMIT, ndgUser.getUserAdmin())) {
            throw new ImeiLimitReachedException();
        }
        this.imeiManager.createIMEI(imeiVO);
        this.sendDynamicJad(imeiVO.getMsisdn(), imeiVO.getImei());
        this.userManager.updateUserAdminBalance(UserVO.IMEI_LIMIT, ndgUser.getUserAdmin());
    }

    public void updateIMEI(ImeiVO imeiVO) throws MSMApplicationException {
        this.imeiManager.updateIMEI(imeiVO);
    }

    public void createDevice(DeviceVO deviceVO) throws MSMApplicationException {
        this.deviceManager.createDevice(deviceVO);
    }

    public void updateDevice(DeviceVO deviceVO) throws MSMApplicationException {
        this.deviceManager.updateDevice(deviceVO);
    }

    public WizardVO wizardImei(ArrayList<ImeiVO> arrayList) throws MSMApplicationException, MSMSystemException {
        Properties properties = this.getSettings();
        String string = "You are able to download NDG client here: ";
        String string2 = properties.getProperty("urlServer") + "/ndg-servlets/GetClient?to=";
        log.debug((Object)("wizardImei: " + string2));
        WizardVO wizardVO = new WizardVO();
        for (ImeiVO imeiVO : arrayList) {
            if (this.imeiManager.hasImei(imeiVO)) {
                wizardVO.addImei(imeiVO.getImei());
            }
            if (!this.imeiManager.hasMsisdn(imeiVO)) continue;
            wizardVO.addPhone(imeiVO.getMsisdn());
        }
        if (!wizardVO.isFilled()) {
            for (ImeiVO imeiVO : arrayList) {
                this.createIMEI(imeiVO);
                log.debug((Object)("newIMEI: " + imeiVO.getImei()));
            }
            log.debug((Object)("sendLinkSMS: " + string + string2));
            this.sendLinkSMS(string + string2, arrayList);
        }
        return wizardVO;
    }

    public void deleteIMEI(String string) throws MSMApplicationException {
        try {
            ImeiVO imeiVO = this.getImei(string);
            if (imeiVO.getRealImei() == 'N') {
                this.deleteJadDir(imeiVO.getMsisdn());
            }
            this.imeiManager.deleteIMEI(string);
        }
        catch (RuntimeException runtimeException) {
            Throwable throwable = runtimeException.getCause();
            for (int i = 0; i < 3 && throwable != null; ++i) {
                if (!((throwable = throwable.getCause()) instanceof ConstraintViolationException)) continue;
                throw new ImeiHasRelationshipException();
            }
            throw runtimeException;
        }
    }

    public void deleteDevice(String string) throws MSMApplicationException {
        try {
            this.deviceManager.deleteDevice(string);
        }
        catch (RuntimeException runtimeException) {
            Throwable throwable = runtimeException.getCause();
            for (int i = 0; i < 3 && throwable != null; ++i) {
                if (!((throwable = throwable.getCause()) instanceof ConstraintViolationException)) continue;
                throw new DeviceHasRelationshipException();
            }
            throw runtimeException;
        }
    }

    public QueryInputOutputVO listAllDevices(QueryInputOutputVO queryInputOutputVO) throws MSMApplicationException {
        QueryInputOutputVO queryInputOutputVO2 = this.deviceManager.listAllDevices(queryInputOutputVO);
        return queryInputOutputVO2;
    }

    public void sendSMS(SMSMessageVO sMSMessageVO) throws MSMApplicationException, MSMSystemException {
        this.messageManager.sendSMS(sMSMessageVO);
    }

    public ImeiVO findImeiByMsisdn(String string) throws MSMApplicationException {
        return this.imeiManager.findImeiByMsisdn(string);
    }

    public Properties getSettings() throws MSMApplicationException {
        return this.surveyHandler.getSettings();
    }

    public String getSpecificPropertySetting(String string) throws MSMApplicationException {
        return this.surveyHandler.getSpecificPropertySetting(string);
    }

    public void updateSettings(Properties properties) throws MSMApplicationException {
        this.surveyHandler.updateSettings(properties);
    }

    public void logTransaction(TransactionLogVO transactionLogVO) throws MSMApplicationException {
        this.transactionlogManager.logTransaction(transactionLogVO);
    }

    public ImeiVO getImei(String string) throws MSMApplicationException {
        return this.imeiManager.getIMEI(string);
    }

    public QueryInputOutputVO getImeisSentBySurvey(String string, QueryInputOutputVO queryInputOutputVO) throws MSMApplicationException {
        return this.surveyHandler.getImeisBySurvey(string, "SUCCESS", queryInputOutputVO);
    }

    public QueryInputOutputVO getImeisUnsentBySurvey(String string, QueryInputOutputVO queryInputOutputVO) throws MSMApplicationException {
        return this.surveyHandler.getImeisBySurvey(string, "PENDING", queryInputOutputVO);
    }

    public void sendTextSMS(String string, ArrayList<String> arrayList, int n, String string2) throws ModemException, MSMApplicationException {
        if (SmsHandlerFactory.getInstance().hasSmsSupport()) {
            for (int i = 0; i < arrayList.size(); ++i) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add(arrayList.toArray()[i].toString());
                if (!this.userManager.userAdminHasPositiveBalance(UserVO.ALERT_LIMIT, string2)) {
                    throw new UserLimitReachedException();
                }
                SendTextSms sendTextSms = new SendTextSms(string, arrayList2, n);
                sendTextSms.start();
                this.userManager.updateUserAdminBalance(UserVO.ALERT_LIMIT, string2);
            }
        }
    }

    public void sendLinkSMS(String string, ArrayList<ImeiVO> arrayList) throws ModemException, MSMApplicationException {
        SendTextSms sendTextSms = new SendTextSms(string, arrayList);
        sendTextSms.start();
    }

    public QueryInputOutputVO getAllImeisBySurvey(String string, QueryInputOutputVO queryInputOutputVO) throws MSMApplicationException {
        QueryInputOutputVO queryInputOutputVO2 = null;
        queryInputOutputVO2 = this.surveyHandler.getAllImeisBySurvey(string, queryInputOutputVO);
        return queryInputOutputVO2;
    }

    public QueryInputOutputVO getAllImeisSentAndUnsentBySurvey(String string) throws MSMApplicationException {
        QueryInputOutputVO queryInputOutputVO = new QueryInputOutputVO();
        queryInputOutputVO.setQueryResult(new ArrayList());
        queryInputOutputVO.getQueryResult().add(this.getImeisSentBySurvey(string, null).getQueryResult());
        queryInputOutputVO.getQueryResult().add(this.getImeisUnsentBySurvey(string, null).getQueryResult());
        queryInputOutputVO.setRecordCount(Integer.valueOf(queryInputOutputVO.getQueryResult().size()));
        return queryInputOutputVO;
    }

    public Collection<TransactionLogVO> getResultReceived(String string, String string2) throws MSMApplicationException {
        return this.transactionlogManager.findTransactionLogBySurveyId("RR", string, "SUCCESS", string2);
    }

    public QueryInputOutputVO getResultListDB(String string, String string2, QueryInputOutputVO queryInputOutputVO) throws MSMApplicationException, MSMSystemException {
        Survey survey = this.surveyHandler.getSurveyObject(string2);
        QueryInputOutputVO queryInputOutputVO2 = null;
        if (survey == null) {
            throw new SurveyNotFoundException();
        }
        queryInputOutputVO2 = this.resultHandler.getResultListDB(string2, queryInputOutputVO);
        return queryInputOutputVO2;
    }

    public ResultXml getResultDB(String string) throws MSMApplicationException, MSMSystemException {
        ResultXml resultXml = this.resultHandler.getResultDB(string);
        return resultXml;
    }

    public TransactionLogVO getSurveyReceived(String string) throws MSMApplicationException {
        Collection collection = this.transactionlogManager.findTransactionLogBySurveyId("RS", string, "SUCCESS", null);
        TransactionLogVO transactionLogVO = new TransactionLogVO();
        if (collection.iterator().hasNext()) {
            transactionLogVO = (TransactionLogVO)collection.iterator().next();
            return transactionLogVO;
        }
        return null;
    }

    public QueryInputOutputVO getImeisByUser(String string, QueryInputOutputVO queryInputOutputVO, boolean bl) throws MSMApplicationException {
        return this.imeiManager.findImeiByUser(string, queryInputOutputVO, bl);
    }

    public QueryInputOutputVO listAllImeis(String string, QueryInputOutputVO queryInputOutputVO, boolean bl) throws MSMApplicationException {
        NdgUser ndgUser = this.findNdgUserByName(string);
        QueryInputOutputVO queryInputOutputVO2 = this.imeiManager.listAllImeis(ndgUser.getUserAdmin(), queryInputOutputVO, bl);
        return queryInputOutputVO2;
    }

    public void sendSurveybySMS(String string, String string2, ArrayList<String> arrayList) throws MSMApplicationException, MSMSystemException {
        if (SmsHandlerFactory.getInstance().hasSmsSupport()) {
            NdgUser ndgUser = this.findNdgUserByName(string);
            this.surveyHandler.sendSlicedSurvey(ndgUser, string2, arrayList);
        }
    }

    public void rationSurveybyGPRS(String string, ArrayList<String> arrayList, ArrayList<String> arrayList2) throws MSMApplicationException, MSMSystemException {
        log.debug((Object)("listOfSurveys :" + arrayList.toString()));
        NdgUser ndgUser = this.findNdgUserByName(string);
        for (String string2 : arrayList) {
            log.debug((Object)(">>> Provisionando Survey: " + string2));
            ArrayList<Object> arrayList3 = new ArrayList();
            arrayList3 = this.surveyHandler.rationSurveybyGPRS(ndgUser, string2, arrayList2);
            if (arrayList3.size() <= 0) continue;
            SendTextSms sendTextSms = new SendTextSms(SMS_NEW_SURVEY_NOTIFICATION + string2, arrayList3, 0);
            sendTextSms.setName(string2);
            sendTextSms.start();
        }
    }

    public void updateStatusSendingSurvey(String string, String string2) throws MSMApplicationException, MSMSystemException {
        this.surveyHandler.updateStatusSendingSurvey(string, string2);
    }

    public boolean forgotYourPassword(String string) throws MSMApplicationException, MSMSystemException {
        boolean bl = false;
        UserVO userVO = this.userManager.validateLoginByEmail(string);
        if (userVO.getRetCode().equals("0000")) {
            if (userVO.getUserValidated() == 'n' || userVO.getUserValidated() == 'N') {
                throw new UserEmailNotValidatedException();
            }
            this.messageManager.sendTextEmail(userVO, 0);
            bl = true;
        }
        return bl;
    }

    public void requestAccess(UserVO userVO) throws MSMSystemException, MSMApplicationException {
        UserVO userVO2 = this.userManager.requestAccess(userVO);
        if (userVO2 != null) {
            try {
                this.messageManager.sendTextEmail(userVO2, 1);
            }
            catch (EmailNotSentException emailNotSentException) {
                this.userManager.deleteNotValidatedUser(userVO2.getUsername());
                throw emailNotSentException;
            }
        }
    }

    public UserVO validateLoginByEmail(String string) throws MSMSystemException, MSMApplicationException {
        UserVO userVO = this.userManager.validateLoginByEmail(string);
        if (userVO.getRetCode().equals("0000")) {
            this.messageManager.sendTextEmail(userVO, 0);
        }
        return userVO;
    }

    public UserVO checkValidationKey(String string) throws MSMSystemException, MSMApplicationException {
        UserVO userVO = new UserVO();
        userVO = this.userManager.checkValidationKey(string);
        return userVO;
    }

    public Properties getModemProperties() throws MSMApplicationException {
        return this.surveyHandler.getModemProperties();
    }

    public void postSurvey(String string, StringBuffer stringBuffer, TransactionLogVO transactionLogVO, Boolean bl) throws MSMApplicationException, MSMSystemException, SurveyFileAlreadyExistsException {
        NdgUser ndgUser = this.findNdgUserByName(string);
        if (!bl.booleanValue()) {
            if (!this.userManager.userAdminHasPositiveBalance(UserVO.SURVEY_LIMIT, ndgUser.getUserAdmin())) {
                throw new UserLimitReachedException();
            }
            this.surveyHandler.postSurvey(ndgUser, stringBuffer, transactionLogVO);
            this.userManager.updateUserAdminBalance(UserVO.SURVEY_LIMIT, ndgUser.getUserAdmin());
        } else {
            this.surveyHandler.postSurvey(ndgUser, stringBuffer, transactionLogVO);
        }
    }

    public void postResult(StringBuffer stringBuffer, TransactionLogVO transactionLogVO) throws MSMApplicationException, MSMSystemException {
        ResultParser resultParser = new ResultParser();
        ResultXml resultXml = null;
        NdgUser ndgUser = null;
        try {
            resultXml = resultParser.parseResult(stringBuffer, "UTF-8");
        }
        catch (Exception exception) {
            throw new ResultNotParsedException();
        }
        if (resultXml != null) {
            ImeiVO imeiVO = this.imeiManager.getIMEI(resultXml.getImei());
            ndgUser = this.findNdgUserByName(imeiVO.getUserName());
            if (this.userManager.userAdminHasPositiveBalance(UserVO.RESULT_LIMIT, ndgUser.getUserAdmin())) {
                this.resultHandler.postResult(stringBuffer, transactionLogVO);
                this.userManager.updateUserAdminBalance(UserVO.RESULT_LIMIT, ndgUser.getUserAdmin());
            } else {
                throw new UserLimitReachedException();
            }
        }
    }

    public NdgUser getUserByImei(String string) throws MSMApplicationException {
        NdgUser ndgUser = this.userManager.getUserByImei(string);
        return ndgUser;
    }

    public UserVO getUserByEmail(String string) throws MSMSystemException, MSMApplicationException {
        UserVO userVO = this.userManager.getUserByEmail(string);
        return userVO;
    }

    public SurveyXML loadSurvey(String string, String string2) throws MSMApplicationException, MSMSystemException {
        NdgUser ndgUser = this.findNdgUserByName(string);
        SurveyXML surveyXML = this.surveyHandler.loadSurveyAndResultsDB(ndgUser.getUserAdmin(), string2);
        return surveyXML;
    }

    public SurveyXML loadSurveyDB(String string, String string2) throws MSMApplicationException, MSMSystemException {
        NdgUser ndgUser = this.findNdgUserByName(string);
        SurveyXML surveyXML = this.surveyHandler.loadSurveyDB(ndgUser.getUserAdmin(), string2);
        return surveyXML;
    }

    public SurveyXML loadSurveyAndResultsDB(String string, String string2) throws MSMApplicationException, MSMSystemException {
        NdgUser ndgUser = this.findNdgUserByName(string);
        SurveyXML surveyXML = this.surveyHandler.loadSurveyAndResultsDB(ndgUser.getUserAdmin(), string2);
        return surveyXML;
    }

    public ArrayList<SurveyXML> loadSurveysDB(NdgUser ndgUser) throws MSMApplicationException, MSMSystemException {
        ArrayList<SurveyXML> arrayList = this.surveyHandler.loadSurveysDB(ndgUser);
        return arrayList;
    }

    public ArrayList<ResultXml> loadResultsDB(String string) throws MSMApplicationException, MSMSystemException {
        ArrayList<ResultXml> arrayList = this.surveyHandler.loadResultsDB(string);
        return arrayList;
    }

    public void copySurveyToDevice(String string, String string2, String string3, String string4) throws FileNotFoundException, IOException, SurveyNotFoundException, MSMApplicationException {
        Deploy.copySurveyToDevice((String)string, (String)string2, (String)string3, (String)string4);
    }

    public UserBalanceVO findUserBalanceByUser(String string) throws MSMApplicationException {
        return this.userManager.findUserBalanceByUser(this.findNdgUserByName(string).getUserAdmin());
    }

    public void saveSurveyFromEditorToServer(String string, String string2) throws MSMApplicationException {
        this.surveyHandler.saveSurveyFromEditorToServer(string, string2);
    }

    public String loadSurveyFromServerToEditor(String string, String string2) throws MSMApplicationException {
        String string3 = this.surveyHandler.loadSurveyFromServerToEditor(string, string2);
        return string3;
    }

    public ArrayList<String> loadSurveysFromServerToEditor(String string) {
        ArrayList<String> arrayList = new ArrayList();
        try {
            arrayList = this.surveyHandler.loadSurveysFromServerToEditor(string);
        }
        catch (MSMApplicationException mSMApplicationException) {
            mSMApplicationException.printStackTrace();
        }
        return arrayList;
    }

    public void deleteSurveyFromServer(String string) throws MSMApplicationException {
        try {
            this.surveyHandler.deleteSurveyFromServer(string);
        }
        catch (RuntimeException runtimeException) {
            Throwable throwable = runtimeException.getCause();
            for (int i = 0; i < 3 && throwable != null; ++i) {
                if (!((throwable = throwable.getCause()) instanceof ConstraintViolationException)) continue;
                throw new SurveyHasRelationshipException();
            }
            throw runtimeException;
        }
    }

    public void uploadSurveyFromEditorToServer(String string) throws MSMApplicationException {
        this.surveyHandler.uploadSurveyFromEditorToServer(string);
    }

    public void saveSettingsFromEditorToServer(String string, String string2) {
        try {
            this.userManager.saveSettingsFromEditorToServer(string, string2);
        }
        catch (MSMApplicationException mSMApplicationException) {
            mSMApplicationException.printStackTrace();
        }
    }

    public String loadSettingsFromServerToEditor(String string) {
        String string2 = "";
        try {
            string2 = this.userManager.loadSettingsFromServerToEditor(string);
        }
        catch (MSMApplicationException mSMApplicationException) {
            mSMApplicationException.printStackTrace();
        }
        return string2;
    }

    public NdgUser findNdgUserByName(String string) throws MSMApplicationException {
        if (string == null) {
            throw new UserNullException();
        }
        NdgUser ndgUser = null;
        ndgUser = this.userManager.findNdgUserByName(string);
        return ndgUser;
    }

    public void detachImeiFromSurvey(String string, String string2) throws MSMApplicationException {
        try {
            this.surveyHandler.detachImeiFromSurvey(string, string2);
        }
        catch (MSMApplicationException mSMApplicationException) {
            mSMApplicationException.printStackTrace();
        }
    }

    public void sendDynamicJad(String string, String string2) throws MSMApplicationException {
        String string3 = null;
        try {
            string3 = this.deviceManager.createDynamicJad(string);
            ArrayList<ImeiVO> arrayList = new ArrayList<ImeiVO>();
            ImeiVO imeiVO = new ImeiVO();
            imeiVO.setImei(string2);
            imeiVO.setMsisdn(string);
            arrayList.add(imeiVO);
            if (SmsHandlerFactory.getInstance().hasSmsSupport()) {
                this.sendLinkSMS(string3, arrayList);
            }
        }
        catch (MSMApplicationException mSMApplicationException) {
            mSMApplicationException.printStackTrace();
        }
    }

    public byte[] jadDownload(String string) throws MSMApplicationException {
        this.deviceManager.createDynamicJad(string);
        if (string.contains("+")) {
            string = string.replace("+", "");
        }
        String string2 = System.getProperty("jboss.server.home.dir");
        String string3 = string2 + "/deploy/ndg-ota.war/client/dyn/" + string + "/ndg.jad";
        File file = new File(string3);
        byte[] byArray = null;
        try {
            byArray = FileUtil.getBytesFromFile(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new JadDownloadException();
        }
        return byArray;
    }

    public void deleteJadDir(String string) throws MSMApplicationException {
        this.deviceManager.deleteJadDir(string);
    }

    public Survey getSurveyObject(String string) {
        return this.surveyHandler.getSurveyObject(string);
    }

    public String getNDGVersion() {
        String string = "0.0.0";
        Properties properties = PropertiesUtil.loadFileProperty(PropertiesUtil.PROPERTIES_VERSION_FILE);
        if (properties != null && properties.containsKey("version")) {
            string = properties.getProperty("version");
        }
        return string;
    }

    public boolean hasSmsSupport() {
        return SmsHandlerFactory.getInstance().hasSmsSupport();
    }

    public void registerIMEI(String string, String string2) throws MSMApplicationException {
        System.out.println("[MSMBusinessDelegate.registerIMEI] Msisdn " + string + "; Imei: " + string2);
        this.imeiManager.registerIMEI(string, string2);
        this.deleteJadDir(string);
    }
}

