/*
 * Decompiled with CFR 0.152.
 */
package br.org.indt.ndg.common;

import br.org.indt.ndg.common.Category;
import br.org.indt.ndg.common.Choice;
import br.org.indt.ndg.common.ChoiceType;
import br.org.indt.ndg.common.Field;
import br.org.indt.ndg.common.Item;
import br.org.indt.ndg.common.SurveyXML;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SurveyParser {
    private static Log logger = LogFactory.getLog(SurveyParser.class);
    private Document document;
    private TreeMap<Integer, Category> categories;
    private SurveyXML survey;
    private int keys;
    private int fieldid = 0;
    private File surveyFile = null;

    public SurveyXML parseSurvey(StringBuffer stringBuffer, String string) throws SAXException, ParserConfigurationException, IOException {
        InputSource inputSource = new InputSource(new StringReader(stringBuffer.toString()));
        inputSource.setEncoding(string);
        logger.info((Object)"parsing survey buffer");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.parse(inputSource);
        return this.processSurvey();
    }

    public SurveyXML parseSurvey(String string) throws SAXException, ParserConfigurationException, IOException {
        logger.info((Object)("parsing survey file: " + string));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.surveyFile = new File(string);
        this.document = documentBuilder.parse(this.surveyFile);
        return this.processSurvey();
    }

    private SurveyXML processSurvey() throws ParserConfigurationException, SAXException, IOException {
        this.survey = new SurveyXML();
        this.survey.setXmldoc(this.document);
        logger.info((Object)"loading survey attributes");
        NodeList nodeList = this.document.getElementsByTagName("survey");
        NamedNodeMap namedNodeMap = nodeList.item(0).getAttributes();
        this.survey.setId(namedNodeMap.getNamedItem("id").getNodeValue());
        this.survey.setDisplay(namedNodeMap.getNamedItem("display").getNodeValue());
        if (namedNodeMap.getNamedItem("title") != null) {
            this.survey.setTitle(namedNodeMap.getNamedItem("title").getNodeValue());
        } else {
            this.survey.setTitle(nodeList.item(0).getChildNodes().item(1).getTextContent());
        }
        if (namedNodeMap.getNamedItem("deployed") != null) {
            this.survey.setDeployed(namedNodeMap.getNamedItem("deployed").getNodeValue());
        }
        if (namedNodeMap.getNamedItem("checksum") != null) {
            this.survey.setChecksum(namedNodeMap.getNamedItem("checksum").getNodeValue());
        }
        logger.info((Object)"loading categories attributes");
        this.categories = new TreeMap();
        NodeList nodeList2 = this.document.getElementsByTagName("category");
        int n = nodeList2.getLength();
        for (int i = 0; i < n; ++i) {
            Category category = new Category();
            NamedNodeMap namedNodeMap2 = nodeList2.item(i).getAttributes();
            category.setId(Integer.parseInt(namedNodeMap2.getNamedItem("id").getNodeValue()));
            category.setName(namedNodeMap2.getNamedItem("name").getNodeValue());
            this.categories.put(category.getId(), category);
        }
        logger.info((Object)"loading fields attributes");
        NodeList nodeList3 = this.document.getElementsByTagName("question");
        int n2 = nodeList3.getLength();
        for (int i = 0; i < n2; ++i) {
            Object object;
            NamedNodeMap namedNodeMap3 = nodeList3.item(i).getAttributes();
            Field field = new Field();
            String string = "";
            if (namedNodeMap3.getNamedItem("direction") != null) {
                string = namedNodeMap3.getNamedItem("direction").getNodeValue();
            }
            field.setDirection(string);
            String string2 = namedNodeMap3.getNamedItem("id").getNodeValue();
            field.setId(Integer.parseInt(string2));
            String string3 = namedNodeMap3.getNamedItem("type").getNodeValue();
            field.setXmlType(string3);
            String string4 = null;
            string4 = namedNodeMap3.getNamedItem("field") != null ? namedNodeMap3.getNamedItem("field").getNodeValue() : "" + this.fieldid++;
            field.setName(string4);
            Node node = nodeList3.item(i);
            Node node2 = node.getChildNodes().item(1);
            String string5 = node2.getTextContent();
            field.setDescription(string5);
            if (field.getXmlType().equals("_choice")) {
                object = nodeList3.item(i).getChildNodes();
                Choice choice = new Choice();
                int n3 = 0;
                for (int j = 0; j < object.getLength(); ++j) {
                    Object object2;
                    if (object.item(j).getNodeName().equals("select")) {
                        object2 = object.item(j).getTextContent();
                        choice.setChoiceType(((String)object2).equals("exclusive") ? ChoiceType.EXCLUSIVE : ChoiceType.MULTIPLE);
                        continue;
                    }
                    if (object.item(j).getNodeName().equals("item")) {
                        object2 = object.item(j).getAttributes();
                        String string6 = object2.getNamedItem("otr").getNodeValue();
                        String string7 = object.item(j).getTextContent();
                        Item item = new Item();
                        item.setOtr(string6);
                        item.setValue(string7);
                        item.setIndex(n3++);
                        choice.addItem(item);
                        continue;
                    }
                    if (!object.item(j).getNodeName().equals("SkipLogic")) continue;
                }
                field.setChoice(choice);
            }
            object = nodeList3.item(i).getParentNode().getAttributes().getNamedItem("name").getNodeValue();
            int n4 = Integer.parseInt(nodeList3.item(i).getParentNode().getAttributes().getNamedItem("id").getNodeValue());
            Category category = this.categories.get(n4);
            field.setCategoryId(n4);
            category.addField(field);
            this.categories.put(n4, category);
            ++this.keys;
        }
        this.survey.setCategories(this.categories);
        return this.survey;
    }

    public int getKeys() {
        return this.keys;
    }

    public Vector<Field> getQuestions(String string) {
        Vector<Field> vector = new Vector<Field>();
        for (Category category : this.categories.values()) {
            int n = category.getFields().size();
            for (int i = 0; i < n; ++i) {
                Field field = category.getFields().get(i);
                if (!field.getDirection().equals(string)) continue;
                vector.add(field);
            }
        }
        return vector;
    }

    public SurveyXML getSurvey() {
        return this.survey;
    }

    public File getSurveyFile() {
        return this.surveyFile;
    }
}

