/*
 * Decompiled with CFR 0.152.
 */
package br.org.indt.ndg.common;

import br.org.indt.ndg.common.Category;
import br.org.indt.ndg.common.Field;
import br.org.indt.ndg.common.FieldType;
import br.org.indt.ndg.common.Item;
import br.org.indt.ndg.common.ResultXml;
import br.org.indt.ndg.common.SurveyXML;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ResultWriter {
    private SurveyXML survey;
    private ResultXml result;

    public ResultWriter(SurveyXML surveyXML, ResultXml resultXml) {
        this.survey = surveyXML;
        this.result = resultXml;
    }

    public String write() throws ParserConfigurationException, Exception {
        DOMSource dOMSource = new DOMSource(this.getDocument());
        StreamResult streamResult = new StreamResult(new StringWriter());
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "ISO-8859-1");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(dOMSource, streamResult);
        String string = streamResult.getWriter().toString();
        return string;
    }

    public Document getDocument() throws ParserConfigurationException {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        Element element = null;
        Element element2 = null;
        Element element3 = null;
        Element element4 = null;
        Element element5 = null;
        Element element6 = null;
        Element element7 = null;
        Text text = null;
        Text text2 = null;
        document = dOMImplementation.createDocument(null, "result", null);
        Element element8 = document.getDocumentElement();
        element8.setAttribute("r_id", this.result.getResultId());
        element8.setAttribute("s_id", this.result.getSurveyId());
        element8.setAttribute("u_id", this.result.getImei());
        element8.setAttribute("time", this.result.getTime());
        if (this.result.getLatitude() != null) {
            element5 = document.createElementNS(null, "latitude");
            text = document.createTextNode(this.result.getLatitude());
            element5.appendChild(text);
            element8.appendChild(element5);
        }
        if (this.result.getLongitude() != null) {
            element6 = document.createElementNS(null, "longitude");
            text = document.createTextNode(this.result.getLongitude());
            element6.appendChild(text);
            element8.appendChild(element6);
        }
        element4 = document.createElementNS(null, "title");
        text = document.createTextNode("");
        element4.appendChild(text);
        element8.appendChild(element4);
        TreeMap<Integer, Category> treeMap = this.survey.getCategories();
        for (Category category : treeMap.values()) {
            element2 = document.createElementNS(null, "category");
            element2.setAttribute("name", category.getName());
            element2.setAttribute("id", String.valueOf(category.getId()));
            element8.appendChild(element2);
            Integer n = new Integer(category.getId());
            Vector<Field> vector = category.getFields();
            for (Field field : vector) {
                element = document.createElementNS(null, "answer");
                element.setAttributeNS(null, "type", field.getXmlType());
                element.setAttributeNS(null, "id", String.valueOf(field.getId()));
                element.setAttributeNS(null, "visited", "false");
                Field field2 = this.result.getCategories().get(n).getFieldById(field.getId());
                if (field.getFieldType() == FieldType.CHOICE) {
                    ArrayList<Item> arrayList = field2.getChoice().getItems();
                    for (Item item : arrayList) {
                        if (!field2.getValue().contains(item.getIndex() + "^")) continue;
                        if (item.getOtr() == null || item.getOtr().equals("0")) {
                            if (!field2.getValue().contains(item.getIndex() + "^")) continue;
                            text2 = document.createTextNode("" + item.getIndex());
                            element3 = document.createElementNS(null, field.getElementName());
                            element3.appendChild(text2);
                            element.appendChild(element3);
                            element2.appendChild(element);
                            continue;
                        }
                        String string = field2.getValue();
                        System.out.println(string.substring(string.indexOf(95) + 1, string.lastIndexOf(95)));
                        text2 = document.createTextNode(item.getValue());
                        text2 = document.createTextNode(string.substring(string.indexOf(95) + 1, string.lastIndexOf(95)));
                        element7 = document.createElementNS(null, "other");
                        element7.setAttributeNS(null, "index", "" + item.getIndex());
                        element7.appendChild(text2);
                        element.appendChild(element7);
                        element2.appendChild(element);
                    }
                } else {
                    text2 = document.createTextNode(field2.getValue() == null ? "" : field2.getValue());
                    element3 = document.createElementNS(null, field.getElementName());
                    element3.appendChild(text2);
                    element.appendChild(element3);
                    element2.appendChild(element);
                }
                if (field.getCategoryId() != this.survey.getDisplayCategory() || field.getId() != this.survey.getDisplayQuestion()) continue;
                element8.getElementsByTagName("title").item(0).setTextContent(field2.getValue());
            }
        }
        return document;
    }
}

