/*
 * Decompiled with CFR 0.152.
 */
package br.org.indt.ndg.common;

import br.org.indt.ndg.common.Category;
import br.org.indt.ndg.common.Choice;
import br.org.indt.ndg.common.Field;
import br.org.indt.ndg.common.Item;
import br.org.indt.ndg.common.ResultXml;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ResultParser {
    private static Log logger = LogFactory.getLog(ResultParser.class);
    Document document;

    public ResultXml parseResult(StringBuffer stringBuffer, String string) throws SAXException, ParserConfigurationException, IOException {
        InputSource inputSource = new InputSource(new StringReader(stringBuffer.toString()));
        inputSource.setEncoding(string);
        logger.info((Object)"parsing result buffer");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.parse(inputSource);
        return this.processResult();
    }

    public ResultXml parseResult(String string) throws SAXException, ParserConfigurationException, IOException {
        logger.info((Object)("parsing result file: " + string));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.parse(new File(string));
        return this.processResult();
    }

    private ResultXml processResult() {
        ResultXml resultXml = new ResultXml();
        resultXml.setXmldoc(this.document);
        logger.info((Object)"loading result attributes");
        NodeList nodeList = this.document.getElementsByTagName("result");
        NamedNodeMap namedNodeMap = nodeList.item(0).getAttributes();
        resultXml.setResultId(namedNodeMap.getNamedItem("r_id").getNodeValue());
        resultXml.setSurveyId(namedNodeMap.getNamedItem("s_id").getNodeValue());
        resultXml.setImei(namedNodeMap.getNamedItem("u_id").getNodeValue());
        resultXml.setTime(namedNodeMap.getNamedItem("time").getNodeValue());
        NodeList nodeList2 = nodeList.item(0).getChildNodes();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            if (nodeList2.item(i).getNodeName().equals("title")) {
                resultXml.setTitle(nodeList2.item(i).getTextContent());
                continue;
            }
            if (nodeList2.item(i).getNodeName().equals("latitude")) {
                resultXml.setLatitude(nodeList2.item(i).getTextContent());
                continue;
            }
            if (!nodeList2.item(i).getNodeName().equals("longitude")) continue;
            resultXml.setLongitude(nodeList2.item(i).getTextContent());
        }
        logger.info((Object)"loading categories attributes");
        TreeMap<Integer, Category> treeMap = new TreeMap<Integer, Category>();
        NodeList nodeList3 = this.document.getElementsByTagName("category");
        int n = nodeList3.getLength();
        for (int i = 0; i < n; ++i) {
            Category category = new Category();
            NamedNodeMap namedNodeMap2 = nodeList3.item(i).getAttributes();
            category.setId(Integer.parseInt(namedNodeMap2.getNamedItem("id").getNodeValue()));
            category.setName(namedNodeMap2.getNamedItem("name").getNodeValue());
            treeMap.put(category.getId(), category);
        }
        logger.info((Object)"loading answers attributes");
        NodeList nodeList4 = this.document.getElementsByTagName("answer");
        int n2 = nodeList4.getLength();
        logger.info((Object)("countAnswer = " + nodeList4));
        for (int i = 0; i < n2; ++i) {
            Object object;
            Object object2;
            Object object3;
            NamedNodeMap namedNodeMap3 = nodeList4.item(i).getAttributes();
            Field field = new Field();
            String string = namedNodeMap3.getNamedItem("id").getNodeValue();
            field.setId(Integer.parseInt(string));
            String string2 = namedNodeMap3.getNamedItem("type").getNodeValue();
            field.setXmlType(string2);
            if (field.getXmlType().equals("_choice")) {
                object3 = nodeList4.item(i).getChildNodes();
                object2 = new Choice();
                for (int j = 0; j < object3.getLength(); ++j) {
                    if (object3.item(j).getNodeName().equals("item")) {
                        try {
                            int n3 = Integer.parseInt(object3.item(j).getTextContent());
                            Item item = new Item();
                            item.setIndex(n3);
                            item.setOtr("0");
                            ((Choice)object2).addItem(item);
                        }
                        catch (Exception exception) {
                            logger.error((Object)("Choice with <item></item>, must have a value " + exception));
                        }
                        continue;
                    }
                    if (!object3.item(j).getNodeName().equals("other")) continue;
                    try {
                        NamedNodeMap namedNodeMap4 = object3.item(j).getAttributes();
                        int n4 = Integer.parseInt(namedNodeMap4.getNamedItem("index").getNodeValue());
                        String string3 = object3.item(j).getTextContent();
                        Item item = new Item();
                        item.setIndex(n4);
                        item.setValue(string3);
                        item.setOtr("1");
                        ((Choice)object2).addItem(item);
                        continue;
                    }
                    catch (Exception exception) {
                        logger.error((Object)("Other with <index></index>, must have a value " + exception));
                    }
                }
                field.setChoice((Choice)object2);
            } else {
                object3 = null;
                try {
                    object2 = nodeList4.item(i);
                    if (object2 != null) {
                        object = object2.getChildNodes();
                        Node node = object.item(1);
                        object3 = node.getTextContent();
                    } else {
                        object3 = "";
                    }
                }
                catch (Exception exception) {
                    object3 = "";
                }
                field.setValue((String)object3);
                logger.info((Object)("Value = " + (String)object3));
            }
            object3 = nodeList4.item(i).getParentNode().getAttributes().getNamedItem("name").getNodeValue();
            int n5 = Integer.parseInt(nodeList4.item(i).getParentNode().getAttributes().getNamedItem("id").getNodeValue());
            logger.debug((Object)((String)object3 + " | " + string + " | " + string2));
            object = treeMap.get(n5);
            logger.debug((Object)("category name: " + ((Category)object).getName()));
            field.setCategoryId(n5);
            ((Category)object).addField(field);
            treeMap.put(n5, (Category)object);
        }
        resultXml.setCategories(treeMap);
        return resultXml;
    }
}

