/*
 * Decompiled with CFR 0.152.
 */
package br.org.indt.ndg.common;

import br.org.indt.ndg.common.ResultFileFilter;
import br.org.indt.ndg.common.SurveyFileFilter;
import java.io.File;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Resources
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SEPARATOR = System.getProperty("file.separator");
    public static final String RESULTS_STARTS_WITH = "r_";
    public static final String SURVEYS_STARTS_WITH = "survey";
    public static final String ENCODING = "ISO-8859-1";
    public static final String DEVICE_ROOT = SEPARATOR + "ndg";
    public static final String SURVEY_PATH = DEVICE_ROOT + SEPARATOR + "survey";
    public static final String SURVEY_FILE_NAME = "survey.xml";
    public static final String IMEI_FILE_NAME = "imei";
    private static final HashMap<String, String> xmlEscape = new HashMap();
    private static Resources INSTANCE;

    public static String substituteXmlEscape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (String string2 : xmlEscape.keySet()) {
            Pattern pattern = Pattern.compile(string2);
            Matcher matcher = pattern.matcher(stringBuffer);
            stringBuffer = new StringBuffer(matcher.replaceAll(xmlEscape.get(string2)));
        }
        return stringBuffer.toString();
    }

    private Resources() {
    }

    public static Resources getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Resources();
        }
        return INSTANCE;
    }

    public static String[] getResultFiles(String string) {
        File file = new File(string);
        ResultFileFilter resultFileFilter = new ResultFileFilter();
        return file.list(resultFileFilter);
    }

    public static String[] getSurveyFiles(String string) {
        File file = new File(string);
        SurveyFileFilter surveyFileFilter = new SurveyFileFilter();
        return file.list(surveyFileFilter);
    }

    public static String toDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.add(5, 1);
        String string = calendar.get(5) + "/" + calendar.get(2) + "/" + calendar.get(1);
        return string;
    }

    public static String toDate(long l) {
        Date date = new Date(l);
        return Resources.toDate(date);
    }

    static {
        xmlEscape.put("&amp;", "&");
        xmlEscape.put("&lt;", "<");
        xmlEscape.put("&gt;", ">");
        xmlEscape.put("&quot;", "\"");
        xmlEscape.put("&apos;", "'");
        INSTANCE = null;
    }
}

