/*
 * Decompiled with CFR 0.152.
 */
package br.org.indt.ndg.common;

import br.org.indt.ndg.common.Resources;
import br.org.indt.ndg.common.ResultParser;
import br.org.indt.ndg.common.ResultXml;
import br.org.indt.ndg.common.exception.ImeiFileNotFoundException;
import br.org.indt.ndg.common.exception.MSMApplicationException;
import br.org.indt.ndg.common.exception.ResultNotParsedException;
import br.org.indt.ndg.common.exception.SurveyNotFoundException;
import br.org.indt.ndg.server.client.ImeiVO;
import br.org.indt.ndg.server.client.MSMBusinessDelegate;
import br.org.indt.ndg.server.client.TransactionLogVO;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Deploy {
    public static ArrayList<ResultXml> getResultsFromDevice(String string, String string2, String string3) throws MSMApplicationException {
        String string4 = string + Resources.SURVEY_PATH.substring(1) + string3 + Resources.SEPARATOR;
        String[] stringArray = Resources.getResultFiles(string4);
        ResultParser resultParser = new ResultParser();
        ArrayList<ResultXml> arrayList = new ArrayList<ResultXml>();
        for (int i = 0; i < stringArray.length; ++i) {
            ResultXml resultXml = null;
            try {
                resultXml = resultParser.parseResult(string4 + stringArray[i]);
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
                throw new ResultNotParsedException();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
                throw new ResultNotParsedException();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new ResultNotParsedException();
            }
            arrayList.add(resultXml);
        }
        return arrayList;
    }

    public static void copySurveyToDevice(String string, String string2, String string3, String string4) throws FileNotFoundException, IOException, SurveyNotFoundException, MSMApplicationException {
        MSMBusinessDelegate mSMBusinessDelegate = new MSMBusinessDelegate();
        String string5 = mSMBusinessDelegate.getSurveyObject(string3).getSurveyXml();
        String string6 = string + Resources.SEPARATOR + Resources.SURVEY_PATH + string3 + Resources.SEPARATOR;
        if (string5 == "" || string5 == null) {
            throw new SurveyNotFoundException();
        }
        File file = new File(string6);
        if (!file.exists()) {
            file.mkdir();
        }
        Deploy.copySurveyFromDBToDevice(string5, string6 + "survey.xml");
        TransactionLogVO transactionLogVO = new TransactionLogVO();
        transactionLogVO.setTransmissionMode("CABLE");
        transactionLogVO.setTransactionType("SS");
        transactionLogVO.setStatus("SUCCESS");
        transactionLogVO.setSurveyId(string3);
        transactionLogVO.setDtLog(new Timestamp(new Date().getTime()));
        transactionLogVO.setImei(string4);
        transactionLogVO.setUser(string2);
        mSMBusinessDelegate.logTransaction(transactionLogVO);
    }

    public static void copySurveyFromDBToDevice(String string, String string2) throws FileNotFoundException, IOException {
        int n;
        File file = new File(string2);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[1024];
        while ((n = byteArrayInputStream.read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        ((InputStream)byteArrayInputStream).close();
        ((OutputStream)fileOutputStream).close();
    }

    public static boolean checkIMEI(String string, String string2) throws ImeiFileNotFoundException, IOException {
        String string3 = string + Resources.SEPARATOR + Resources.DEVICE_ROOT + Resources.SEPARATOR;
        File file = new File(string3 + "imei");
        if (!file.exists()) {
            throw new ImeiFileNotFoundException();
        }
        InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(file));
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string4 = bufferedReader.readLine();
        bufferedReader.close();
        inputStreamReader.close();
        if (string4 != null) {
            return string4.equals(string2);
        }
        return false;
    }

    public static ImeiVO getIMEIFromDeviceDrive(String string) throws ImeiFileNotFoundException, IOException {
        ImeiVO imeiVO = null;
        String string2 = string + Resources.SEPARATOR + Resources.DEVICE_ROOT + Resources.SEPARATOR;
        File file = new File(string2 + "imei");
        if (!file.exists()) {
            throw new ImeiFileNotFoundException();
        }
        InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(file));
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string3 = bufferedReader.readLine();
        bufferedReader.close();
        inputStreamReader.close();
        if (string3 != null) {
            MSMBusinessDelegate mSMBusinessDelegate = new MSMBusinessDelegate();
            try {
                imeiVO = mSMBusinessDelegate.getImei(string3);
            }
            catch (MSMApplicationException mSMApplicationException) {
                mSMApplicationException.printStackTrace();
            }
        } else {
            throw new ImeiFileNotFoundException();
        }
        return imeiVO;
    }
}

