# -*- coding: utf-8 -*-

from PyQt4.QtGui import QMainWindow, QApplication
from PyQt4.QtCore import pyqtSignature, QRect, Qt, QSettings, SIGNAL
from Ui_calc import Ui_MainWindow
    
class MainWindow(QMainWindow, Ui_MainWindow):
    def __init__(self, parent = None):
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        self.operand1=0
        self.operand2=0
        self.stackpointer=1
        self.displaystring=''
        self.operator=''
        self.error=0
        self.csign=1
        self.pointset=0
        self.memory=0
        self.lastkey='='
        self.portrait=0
        self.config=["Orange","Auto"]
        self.readConfig()
        if self.config[0]=="Orange": self.on_Orange_triggered()
        elif self.config[0]=="White":self.on_White_triggered()
        elif self.config[0]=="Red":self.on_Red_triggered()
        elif self.config[0]=="Green":self.on_Green_triggered()
        if self.config[1]=="Auto":
            self.on_actionAuto_Rotation_toggled( 1)
            self.actionAuto_Rotation.setChecked(True)
        
    
    @pyqtSignature("")
    def on_pushButton_1_pressed(self):
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'1'
            self.lcd.setText(self.displaystring)
            self.lastkey='1'

    @pyqtSignature("")
    def on_pushButton_2_pressed(self):
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'2'
            self.lcd.setText(self.displaystring)
            self.lastkey='2'
    
    @pyqtSignature("")
    def on_pushButton_3_pressed(self):
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'3'
            self.lcd.setText(self.displaystring)
            self.lastkey='3'
    
    @pyqtSignature("")
    def on_pushButton_4_pressed(self):
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'4'
            self.lcd.setText(self.displaystring)
            self.lastkey='4'
            
    @pyqtSignature("")
    def on_pushButton_5_pressed(self):
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'5'
            self.lcd.setText(self.displaystring)
            self.lastkey='5'
    
    @pyqtSignature("")
    def on_pushButton_6_pressed(self):
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'6'
            self.lcd.setText(self.displaystring)
            self.lastkey='6'
    
    @pyqtSignature("")
    def on_pushButton_7_pressed(self):
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'7'
            self.lcd.setText(self.displaystring)
            self.lastkey='7'
    
    @pyqtSignature("")
    def on_pushButton_8_pressed(self):
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'8'
            self.lcd.setText(self.displaystring)
            lastkey='8'
    
    @pyqtSignature("")
    def on_pushButton_9_pressed(self):
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'9'
            self.lcd.setText(self.displaystring)
            self.lastkey='9'
            
    @pyqtSignature("")
    def on_pushButton_0_pressed(self):
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'0'
            self.lcd.setText(self.displaystring)
            self.lastkey='0'
            
    @pyqtSignature("")
    def on_pushButton_CS_pressed(self):
        if len(self.displaystring)>0:
            if float(self.displaystring)!= 0:
           
                self.csign=self.csign*-1
                if  self.csign == -1:
                    self.displaystring='-'+self.displaystring
                if  self.csign== 1:
                    self.displaystring=self.displaystring.replace('-', '')

                self.lcd.setText(self.displaystring)
        else:
             if  self.operand2!=0:
                 self.operand2=self.operand2*-1
                 self.lcd.setText(str(self.operand2))
        self.lastkey='cs'
            
            
            
    @pyqtSignature("")
    def on_pushButton_point_pressed(self):
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        if self.pointset==0: 
             self.pointset=1
             if len(self.displaystring)==0: self.displaystring='0'
             self.displaystring=self.displaystring+'.'
             self.lcd.setText(self.displaystring)
        self.lastkey='.'
    
    @pyqtSignature("")
    def on_pushButton_mul_pressed(self):
        self.dobigsum()
        self.operator='x'
        self.lastkey='x'
        
    @pyqtSignature("")
    def on_pushButton_div_pressed(self):
        self.dobigsum()
        self.operator='/'
        self.lastkey='/'
    
    @pyqtSignature("")
    def on_pushButton_add_pressed(self):
        self.dobigsum()
        self.operator='+'
        self.lastkey='+'
    
    @pyqtSignature("")
    def on_pushButton_sub_pressed(self):
        self.dobigsum()
        self.operator='-'
        self.lastkey='-'
    
    @pyqtSignature("")
    def on_pushButton_c_pressed(self):
        self.displaystring=('')
        self.operand1=0
        self.operand2=0
        self.lcd.setText('0')
        if self.memory==0:self.lcd2.setText('')
        self.stackpointer=1
        self.csign=1
        self.pointset=0
        self.lastkey='c'
    
    @pyqtSignature("")
    def on_pushButton_m_pressed(self):
        if len(self.displaystring)>0: self.memory=float(self.displaystring)
        else :self.memory=self.operand2
        if self.memory==0:self.lcd2.setText('')
        else:self.lcd2.setText('M')
        self.lastkey='m'
        
        
     
    
    @pyqtSignature("")
    def on_pushButton_r_pressed(self):
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        self.displaystring=str(self.memory)
        self.lcd.setText(self.displaystring)
        if self.memory<0:self.csign=-1
        self.pointset=1
        self.lastkey='r'
        
        
         
    @pyqtSignature("")
    def on_pushButton_equ_pressed(self):

        self.dobigsum()
        self.operator='='
        self.lastkey='='
        
    @pyqtSignature("")
    def dodivision(self):
        """
        Handle divide by Zero errors
        """
        try : self.operand2=self.operand2/self.operand1
        except ZeroDivisionError:
         self.error=1   
    
    @pyqtSignature("")
    def dosum(self):
        """
        does the sum dependant on the operand
        """
        if self.operator=='+': self.operand2=self.operand2+self.operand1
        if self.operator=='-':  self.operand2=self.operand2-self.operand1
        if self.operator=='x': self.operand2=self.operand2*self.operand1
        if self.operator=='/':  self.dodivision()
        self.operand1=0
        if self.error==0: self.lcd.setText(str(self.operand2))
    
        else:
                 self.lcd.setText('div 0')
                 self.error=0
  
  
    @pyqtSignature("")
    def dobigsum(self):
        if len(self.displaystring)>0: self.operand1=float(self.displaystring)
        
        if self.stackpointer==1: 
                     self.operand2=self.operand1
                     self.operand1=0
                     self.lcd.setText(str(self.operand2))
        else :
                 self.dosum()
        self.displaystring=''
        self.stackpointer=2
        self.pointset=0
        self.csign=1

    @pyqtSignature("")
    def on_Red_triggered(self):
        self.lcd.setStyleSheet("""color: rgb(255,50,14); border-width:0px;background-image:none; background-image:url(:/images/transparent.png);""")
        self.config[0]="Red"
        self.writeConfig()
        
    @pyqtSignature("")
    def on_Green_triggered(self):
        self.lcd.setStyleSheet("""color: rgb(42,211,26); border-width:0px;background-image:none; background-image:url(:/images/transparent.png);""")
        self.config[0]="Green"
        self.writeConfig()
        
    @pyqtSignature("")
    def on_Orange_triggered(self):
        self.lcd.setStyleSheet("""color: rgb(238,156,14); border-width:0px;background-image:none; background-image:url(:/images/transparent.png);""")
        self.config[0]="Orange"
        self.writeConfig()
        
    
    @pyqtSignature("")
    def on_White_triggered(self):
        self.lcd.setStyleSheet("""color: rgb(255,255,255); border-width:0px;background-image:none; background-image:url(:/images/transparent.png);""")
        self.config[0]="White"
        self.writeConfig()
        
        
    @pyqtSignature("bool")
    def on_actionAuto_Rotation_toggled(self, p0):
        if p0:
            self.config[1]="Auto"
            try : 
                self.setAttribute(Qt.WA_Maemo5AutoOrientation, 1)
                self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged );
            except:print "could not autorotate on"
        else:
            self.config[1]="Landscape"
            try : 
                self.setAttribute(Qt.WA_Maemo5AutoOrientation, 0)
            except: print "could not autorotate off"
        self.writeConfig()    
    
    def orientationChanged(self):
        screenGeometry=QApplication.desktop().screenGeometry();
        if screenGeometry.width() > screenGeometry.height():
            self.portrait=1
            self.rotateDisplay()
        else:
            self.portrait=0
            self.rotateDisplay()
            

        
    @pyqtSignature("")
    def rotateDisplay(self):
        if self.portrait==0:
            self.rightFrame.hide()
            self.setPstyle()
            
            self.gridLayout.addWidget(self.pushButton_m, 0, 0)
            self.gridLayout.addWidget(self.pushButton_r, 0, 1)
            self.gridLayout.addWidget(self.pushButton_c, 0, 2)
            self.gridLayout.addWidget(self.pushButton_div, 0, 3)
            
            self.gridLayout.addWidget(self.pushButton_1, 1, 0)
            self.gridLayout.addWidget(self.pushButton_2, 1, 1)
            self.gridLayout.addWidget(self.pushButton_3, 1, 2)
            self.gridLayout.addWidget(self.pushButton_mul, 1, 3)
            
            self.gridLayout.addWidget(self.pushButton_4, 2, 0)
            self.gridLayout.addWidget(self.pushButton_5, 2, 1)
            self.gridLayout.addWidget(self.pushButton_6, 2, 2)
            self.gridLayout.addWidget(self.pushButton_sub, 2, 3)
            
            self.gridLayout.addWidget(self.pushButton_7, 3, 0)
            self.gridLayout.addWidget(self.pushButton_8, 3, 1)
            self.gridLayout.addWidget(self.pushButton_9, 3, 2)
            self.gridLayout.addWidget(self.pushButton_add, 3, 3)
            
            self.gridLayout.addWidget(self.pushButton_CS, 4, 0)
            self.gridLayout.addWidget(self.pushButton_0, 4, 1)
            self.gridLayout.addWidget(self.pushButton_point,4, 2)
            self.gridLayout.addWidget(self.pushButton_equ, 4, 3)


            self.resize(480, 800)
            self.lcdFrame.setGeometry(QRect(0, 50, 478, 71))
            self.lcd2.setGeometry(QRect(435, 10, 31, 31))
            self.centerFrame.setGeometry(QRect(0, 0, 480, 750))
            self.gridFrame.setGeometry(QRect(0, 200, 480, 500))

        else:
            self.setLstyle()
            self.gridLayout_2.addWidget(self.pushButton_mul, 0, 0, 1, 1)
            self.gridLayout_2.addWidget(self.pushButton_div, 1, 0, 1, 1)
            self.gridLayout_2.addWidget(self.pushButton_add, 2, 0, 1, 1)
            self.gridLayout_2.addWidget(self.pushButton_sub, 3, 0, 1, 1)
            
            self.gridLayout_2.addWidget(self.pushButton_c, 0, 1, 1, 1)
            self.gridLayout_2.addWidget(self.pushButton_m, 1, 1, 1, 1)
            self.gridLayout_2.addWidget(self.pushButton_r, 2, 1, 1, 1)
            self.gridLayout_2.addWidget(self.pushButton_equ, 3, 1, 1, 1)
            self.rightFrame.show()
            self.gridLayout.addWidget(self.pushButton_1, 0, 0)
            self.gridLayout.addWidget(self.pushButton_2, 0, 1)
            self.gridLayout.addWidget(self.pushButton_3, 0, 2)
            self.gridLayout.addWidget(self.pushButton_4, 1, 0)
            self.gridLayout.addWidget(self.pushButton_5, 1, 1)
            self.gridLayout.addWidget(self.pushButton_6, 1, 2)

            
            self.gridLayout.addWidget(self.pushButton_7, 2, 0)
            self.gridLayout.addWidget(self.pushButton_8, 2, 1)
            self.gridLayout.addWidget(self.pushButton_9, 2, 2)

            self.gridLayout.addWidget(self.pushButton_CS, 3, 0)
            self.gridLayout.addWidget(self.pushButton_point, 3, 1)
            self.gridLayout.addWidget(self.pushButton_0, 3, 2)

            self.resize(800, 480)
            self.lcdFrame.setGeometry(QRect(10, 0, 771, 71))
            self.lcd2.setGeometry(QRect(730, 10, 31, 31))
            self.centerFrame.setGeometry(QRect(0, 0, 800, 425))
            self.gridFrame.setGeometry(QRect(0, 70, 451, 351))
                
    
    def setPstyle(self):
     self.centerFrame.setStyleSheet("""#centerFrame{background-color: rgb(26,26,26);
border-width:1px; 
border-style:solid;
border-color:rgb(26, 26, 26);; 
}


#formFrame{background-image: url(:/images/transparent.jpg);}
#gridFrame{background-image: url(:/images/transparent.jpg);}

QPushButton{ border-radius: 10px;
                         min-width: 105px; 
                         min-height:75px;
                         border: 1px;
                        border-width:1px; 
                        border-style:solid;
                        border-color:rgb(26,26,26);; 
                        color: rgb(255, 255, 255);
}

QPushButton{ background-image: url(:/images/bt_01_off.png);}
QPushButton:pressed {background-image: url(:/images/bt_01_on.png);}


#pushButton_mul{background-image: url(:/images/bt_02_off.png);}
#pushButton_mul:pressed{background-image: url(:/images/bt_02_on.png);}

#pushButton_div{background-image: url(:/images/bt_02_off.png);}
#pushButton_div:pressed{background-image: url(:/images/bt_02_on.png);}

#pushButton_add{background-image: url(:/images/bt_02_off.png);}
#pushButton_add:pressed{background-image: url(:/images/bt_02_on.png);}

#pushButton_sub{background-image: url(:/images/bt_02_off.png);}
#pushButton_sub:pressed{background-image: url(:/images/bt_02_on.png);}

#pushButton_c{background-image: url(:/images/bt_02_off.png);}
#pushButton_c:pressed{background-image: url(:/images/bt_02_on.png);}

#pushButton_m{background-image: url(:/images/bt_02_off.png);}
#pushButton_m:pressed{background-image: url(:/images/bt_02_on.png);}
#pushButton_r{background-image: url(:/images/bt_02_off.png);}
#pushButton_r:pressed{background-image: url(:/images/bt_02_on.png);}
#pushButton_equ{background-image: url(:/images/bt_03_off.png);}
#pushButton_equ:pressed{background-image: url(:/images/bt_03_on.png);}


#pushButton_1 {image: url(:/images/bt_label_01.png);}
#pushButton_2 {image: url(:/images/bt_label_02.png);}
#pushButton_3 {image: url(:/images/bt_label_03.png); }
#pushButton_4 {image: url(:/images/bt_label_04.png); }
#pushButton_5 {image: url(:/images/bt_label_05.png);}
#pushButton_6 {image: url(:/images/bt_label_06.png);}
#pushButton_7 {image: url(:/images/bt_label_07.png); }
#pushButton_8 {image: url(:/images/bt_label_08.png); }
#pushButton_9 {image: url(:/images/bt_label_09.png);}
#pushButton_0 {image: url(:/images/bt_label_0.png);}
#pushButton_point {image: url(:/images/bt_label_dot.png);}

#pushButton_mul {image: url(:/images/bt_label_times.png);}
#pushButton_div{image: url(:/images/bt_label_div.png);}
#pushButton_add {image: url(:/images/bt_label_plus.png);}
#pushButton_sub {image: url(:/images/bt_label_minus.png);}

#pushButton_c {image: url(:/images/bt_label_clear.png);}

#pushButton_equ{image: url(:/images/bt_label_equal.png);}

""")


    def setLstyle(self):
     self.centerFrame.setStyleSheet("""#centerFrame{background-color: rgb(26,26,26);
border-width:1px; 
border-style:solid;
border-color:rgb(26, 26, 26);; 
}


#formFrame{background-image: url(:/images/transparent.jpg);}
#gridFrame{background-image: url(:/images/transparent.jpg);}

QPushButton{ border-radius: 10px;
                         min-width: 130px; 
                         min-height:75px;
                         border: 1px;
                        border-width:1px; 
                        border-style:solid;
                        border-color:rgb(26,26,26);; 
                        color: rgb(255, 255, 255);
}

QPushButton{ background-image: url(:/images/bt_01_off.png);}
QPushButton:pressed {background-image: url(:/images/bt_01_on.png);}

#pushButton_mul{background-image: url(:/images/bt_02_off.png);}
#pushButton_mul:pressed{background-image: url(:/images/bt_02_on.png);}

#pushButton_div{background-image: url(:/images/bt_02_off.png);}
#pushButton_div:pressed{background-image: url(:/images/bt_02_on.png);}

#pushButton_add{background-image: url(:/images/bt_02_off.png);}
#pushButton_add:pressed{background-image: url(:/images/bt_02_on.png);}

#pushButton_sub{background-image: url(:/images/bt_02_off.png);}
#pushButton_sub:pressed{background-image: url(:/images/bt_02_on.png);}

#pushButton_c{background-image: url(:/images/bt_02_off.png);}
#pushButton_c:pressed{background-image: url(:/images/bt_02_on.png);}

#pushButton_m{background-image: url(:/images/bt_02_off.png);}
#pushButton_m:pressed{background-image: url(:/images/bt_02_on.png);}
#pushButton_r{background-image: url(:/images/bt_02_off.png);}
#pushButton_r:pressed{background-image: url(:/images/bt_02_on.png);}
#pushButton_equ{background-image: url(:/images/bt_03_off.png);}
#pushButton_equ:pressed{background-image: url(:/images/bt_03_on.png);}


#pushButton_1 {image: url(:/images/bt_label_01.png);}
#pushButton_2 {image: url(:/images/bt_label_02.png);}
#pushButton_3 {image: url(:/images/bt_label_03.png); }
#pushButton_4 {image: url(:/images/bt_label_04.png); }
#pushButton_5 {image: url(:/images/bt_label_05.png);}
#pushButton_6 {image: url(:/images/bt_label_06.png);}
#pushButton_7 {image: url(:/images/bt_label_07.png); }
#pushButton_8 {image: url(:/images/bt_label_08.png); }
#pushButton_9 {image: url(:/images/bt_label_09.png);}
#pushButton_0 {image: url(:/images/bt_label_0.png);}
#pushButton_point {image: url(:/images/bt_label_dot.png);}

#pushButton_mul {image: url(:/images/bt_label_times.png);}
#pushButton_div{image: url(:/images/bt_label_div.png);}
#pushButton_add {image: url(:/images/bt_label_plus.png);}
#pushButton_sub {image: url(:/images/bt_label_minus.png);}

#pushButton_c {image: url(:/images/bt_label_clear.png);}

#pushButton_equ{image: url(:/images/bt_label_equal.png);}

""")


    def readConfig(self):
    #read the config file  from QSettings 
        self.settings=QSettings("AcaciaClose", "ncalc")
        if self.settings.contains("displayColour")==1:self.config[0]=self.settings.value("displayColour").toString()
        else :self.settings.setValue("displayColour", "Orange")
        if self.settings.contains("rotation")==1:self.config[1]=self.settings.value("rotation").toString()
        else:self.settings.setValue("rotation", "Auto")
        
    def writeConfig(self):
    #read the config file  into QSettings
    #print "writting theme directory", self.config[1]
        self.settings=QSettings("AcaciaClose", "ncalc")
        self.settings.setValue("displayColour", self.config[0])
        self.settings.setValue("rotation", self.config[1])
        #Note to print out a settings value we have to convert the stored Qvariant to a string
        #print "q settings value",  self.settings.value("clockType").toString()

def __init__(self, parent = None):
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
    





