# -*- coding: utf-8 -*-

"""
Module implementing MainWindow.
"""

from PyQt4.QtGui import QMainWindow
from PyQt4.QtCore import pyqtSignature

from Ui_calc import Ui_MainWindow

    
class MainWindow(QMainWindow, Ui_MainWindow):
    """
    Class documentation goes here.
    """

    def __init__(self, parent = None):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        
    operand1=0
    operand2=0
    stackpointer=1
    displaystring=''
    operator=''
    error=0
    csign=1
    pointset=0
    memory=0
   
    
    
    @pyqtSignature("")
    def on_pushButton_1_pressed(self):
        """
        The 1 key is pressed
        """
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'1'
            self.lcd.setText(self.displaystring)

    @pyqtSignature("")
    def on_pushButton_2_pressed(self):
        """
        The 2 key is pressed
        """
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'2'
            self.lcd.setText(self.displaystring)
    
    @pyqtSignature("")
    def on_pushButton_3_pressed(self):
        """
        Slot documentation goes here.
        """
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'3'
            self.lcd.setText(self.displaystring)
            print'hello'''
    
    @pyqtSignature("")
    def on_pushButton_4_pressed(self):
        """
        The 4 Key is pressed
        """
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'4'
            self.lcd.setText(self.displaystring)
    
    @pyqtSignature("")
    def on_pushButton_5_pressed(self):
        """
        The 5 Key is pressed
        """
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'5'
            self.lcd.setText(self.displaystring)
    
    @pyqtSignature("")
    def on_pushButton_6_pressed(self):
        """
        The 6 Key is pressed
        """
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'6'
            self.lcd.setText(self.displaystring)
    
    @pyqtSignature("")
    def on_pushButton_7_pressed(self):
        """
        The 7 key is pressed
        """
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'7'
            self.lcd.setText(self.displaystring)
    
    @pyqtSignature("")
    def on_pushButton_8_pressed(self):
        """
        The 8 Key is pressed
        """
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'8'
            self.lcd.setText(self.displaystring)
    
    @pyqtSignature("")
    def on_pushButton_9_pressed(self):
        """
        The 9 Key is pressed
        """
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'9'
            self.lcd.setText(self.displaystring)
            
    @pyqtSignature("")
    def on_pushButton_0_pressed(self):
        """
        The 0 Key is pressed
        """
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'0'
            self.lcd.setText(self.displaystring)
            
    @pyqtSignature("")
    def on_pushButton_CS_pressed(self):
        """
        The Change Sign Key is pressed
        """
        self.csign=self.csign*-1
        if  self.csign == -1:
             self.displaystring='-'+self.displaystring
        if  self.csign== 1:
             self.displaystring=self.displaystring.replace('-', '')
        self.lcd.setText(self.displaystring)
    
    @pyqtSignature("")
    def on_pushButton_point_pressed(self):
        """
        The Decimal point key is pressed
        """
        if self.pointset==0: 
             self.pointset=1
             self.displaystring=self.displaystring+'.'
             self.lcd.setText(self.displaystring)
             print(self.displaystring)
    
    @pyqtSignature("")
    def on_pushButton_mul_pressed(self):
        """
        The Multiply button is pressed
        """
        self.dobigsum()
        self.operator='x'
    
    @pyqtSignature("")
    def on_pushButton_div_pressed(self):
        """
        The Divide Button is pressed
        """
        self.dobigsum()
        self.operator='/'
    
    @pyqtSignature("")
    def on_pushButton_add_pressed(self):
        """
        The Plus Button is pressed
        """
        self.dobigsum()
        self.operator='+'
    
    @pyqtSignature("")
    def on_pushButton_sub_pressed(self):
        """
        The Subtract Button is pressed
        """
        self.dobigsum()
        self.operator='-'
    
    @pyqtSignature("")
    def on_pushButton_c_pressed(self):
        """
        The Cancel Button is pressed
        """
        self.displaystring=('')
        self.operand1=0
        self.operand2=0
        self.lcd.setText('0')
        self.stackpointer=1
        self.csign=1
        self.pointset=0
    
    @pyqtSignature("")
    def on_pushButton_m_pressed(self):
        """
        The Memory Button is pressed
        """
        if len(self.displaystring)>0: self.memory=float(self.displaystring)
    
    @pyqtSignature("")
    def on_pushButton_r_pressed(self):
        """
        The Memory Recall  Button is pressed
        """
        self.displaystring=str(self.memory) 
        self.lcd.setText(self.displaystring)
  
    
    @pyqtSignature("")
    def on_pushButton_equ_pressed(self):
        """
        The Equal key is Pressed
        """
        self.dobigsum()
        self.operator='='
       
    
    @pyqtSignature("")
    def dodivision(self):
        """
        Handle divide by Zero errors
        """
        try : self.operand2=self.operand2/self.operand1
        except ZeroDivisionError:
         self.error=1   
    
    @pyqtSignature("")
    def dosum(self):
        """
        does the sum dependant on the operand
        """
        if self.operator=='+': self.operand2=self.operand2+self.operand1
        if self.operator=='-':  self.operand2=self.operand2-self.operand1
        if self.operator=='x': self.operand2=self.operand2*self.operand1
        if self.operator=='/':  self.dodivision()
                                         
        self.operand1=0
        if self.error==0: self.lcd.setText(str(self.operand2))
        else:
                 self.lcd.setText('div 0')
                 self.error=0
  
  
    @pyqtSignature("")
    def dobigsum(self):
        """
        Handle maths operations on keys
        """
        if len(self.displaystring)>0: self.operand1=float(self.displaystring)
        
        if self.stackpointer==1: 
                     self.operand2=self.operand1
                     self.operand1=0
                     self.lcd.setText(str(self.operand2))
        else :
                 self.dosum()
        self.displaystring=''
        self.stackpointer=2
        self.pointset=0
        self.csign=1

    @pyqtSignature("")
    def on_Red_triggered(self):
        """
        Change the Display Colour to Red
        """
        self.lcd.setStyleSheet("""background-image: url(:/images/calculator_display.png); border-width:5px; border-style:solid;                                               border-color:rgb(73, 73, 73);; 
color: rgb(244,36,4);""")

        
    @pyqtSignature("")
    def on_Green_triggered(self):
        """
        Slot documentation goes here.
        """
        self.lcd.setStyleSheet("""background-image: url(:/images/calculator_display.png); border-width:5px; border-style:solid;                                               border-color:rgb(73, 73, 73);; 
color: rgb(42,211,26);""")
    
    @pyqtSignature("")
    def on_Orange_triggered(self):
        """
        Slot documentation goes here.
        """
        self.lcd.setStyleSheet("""background-image: url(:/images/calculator_display.png); border-width:5px; border-style:solid;                                               border-color:rgb(73, 73, 73);; 
color: rgb(238, 156, 14);""")
    
    @pyqtSignature("")
    def on_White_triggered(self):
        """
        Slot documentation goes here.
        """
        self.lcd.setStyleSheet("""background-image: url(:/images/calculator_display.png); border-width:5px; border-style:solid;                                               border-color:rgb(73, 73, 73);; 
color: rgb(255,255,255);""")







def __init__(self, parent = None):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
    





