/*
 * Decompiled with CFR 0.152.
 */
package com.google.tts;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceManager;
import android.view.Menu;
import android.view.MenuItem;
import com.google.tts.TTS;
import java.util.HashMap;

public class PrefsActivity
extends PreferenceActivity {
    private TTS myTts;
    private HashMap<String, Integer> hellos;
    private TTS.InitListener ttsInitListener = new TTS.InitListener(){

        public void onInit(int version) {
            PrefsActivity.this.addPreferencesFromResource(2130968576);
            PrefsActivity.this.loadHellos();
            Preference previewPref = PrefsActivity.this.findPreference("preview");
            previewPref.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

                public boolean onPreferenceClick(Preference preference) {
                    PrefsActivity.this.sayHello();
                    return true;
                }
            });
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setVolumeControlStream(3);
        this.myTts = new TTS((Context)this, this.ttsInitListener, true);
    }

    private void loadHellos() {
        this.hellos = new HashMap();
        this.hellos.put("af", 2131165187);
        this.hellos.put("bs", 2131165188);
        this.hellos.put("zh-yue", 2131165189);
        this.hellos.put("zh", 2131165190);
        this.hellos.put("hr", 0x7F070007);
        this.hellos.put("cz", 2131165192);
        this.hellos.put("nl", 2131165193);
        this.hellos.put("en-us", 2131165194);
        this.hellos.put("en-uk", 2131165195);
        this.hellos.put("eo", 2131165196);
        this.hellos.put("fi", 2131165197);
        this.hellos.put("fr", 2131165198);
        this.hellos.put("de", 0x7F07000F);
        this.hellos.put("el", 2131165200);
        this.hellos.put("hi", 2131165201);
        this.hellos.put("hu", 2131165202);
        this.hellos.put("is", 2131165203);
        this.hellos.put("id", 2131165204);
        this.hellos.put("it", 2131165205);
        this.hellos.put("ku", 2131165206);
        this.hellos.put("la", 2131165207);
        this.hellos.put("mk", 2131165208);
        this.hellos.put("no", 2131165209);
        this.hellos.put("pl", 2131165210);
        this.hellos.put("pt", 2131165211);
        this.hellos.put("ro", 2131165212);
        this.hellos.put("ru", 2131165213);
        this.hellos.put("sr", 2131165214);
        this.hellos.put("sk", 2131165215);
        this.hellos.put("es", 2131165216);
        this.hellos.put("es-la", 2131165217);
        this.hellos.put("sw", 2131165218);
        this.hellos.put("sv", 2131165219);
        this.hellos.put("ta", 2131165220);
        this.hellos.put("tr", 2131165221);
        this.hellos.put("vi", 2131165222);
        this.hellos.put("cy", 2131165223);
    }

    private void sayHello() {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
        String languageCode = prefs.getString("lang_pref", "en-us");
        int rate = Integer.parseInt(prefs.getString("rate_pref", "140"));
        this.myTts.setLanguage(languageCode);
        this.myTts.setSpeechRate(rate);
        String hello = this.getString(this.hellos.get(languageCode));
        this.myTts.speak(hello, 0, null);
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        menu.add(0, 2131165185, 0, 2131165185).setIcon(17301583);
        menu.add(0, 2131165186, 0, 2131165186).setIcon(17301569);
        return super.onCreateOptionsMenu(menu);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        Intent i = new Intent();
        ComponentName comp = new ComponentName("com.android.browser", "com.android.browser.BrowserActivity");
        i.setComponent(comp);
        i.setAction("android.intent.action.VIEW");
        i.addCategory("android.intent.category.BROWSABLE");
        switch (item.getItemId()) {
            case 2131165185: {
                Uri uri = Uri.parse((String)"http://eyes-free.googlecode.com/svn/trunk/documentation/tts_apps.html");
                i.setData(uri);
                this.startActivity(i);
                break;
            }
            case 2131165186: {
                Uri uri = Uri.parse((String)"http://eyes-free.googlecode.com/");
                i.setData(uri);
                this.startActivity(i);
            }
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onDestroy() {
        if (this.myTts != null) {
            this.myTts.shutdown();
        }
        super.onDestroy();
    }
}

