/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.os.Looper;
import android.os.Process;
import android.text.format.Time;
import android.util.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.acra.ACRA;
import org.acra.ACRAConfiguration;
import org.acra.ACRAConstants;
import org.acra.CrashReportDialog;
import org.acra.CrashReportFileNameParser;
import org.acra.CrashReportFinder;
import org.acra.CrashReportPersister;
import org.acra.ReportField;
import org.acra.ReportingInteractionMode;
import org.acra.SendWorker;
import org.acra.collector.ConfigurationCollector;
import org.acra.collector.CrashReportData;
import org.acra.collector.CrashReportDataFactory;
import org.acra.sender.ReportSender;
import org.acra.util.PackageManagerWrapper;
import org.acra.util.ToastSender;

public class ErrorReporter
implements Thread.UncaughtExceptionHandler {
    private boolean enabled = false;
    private final Context mContext;
    private final SharedPreferences prefs;
    private final List<ReportSender> mReportSenders = new ArrayList<ReportSender>();
    private final CrashReportDataFactory crashReportDataFactory;
    private final CrashReportFileNameParser fileNameParser = new CrashReportFileNameParser();
    private final Thread.UncaughtExceptionHandler mDfltExceptionHandler;
    private Thread brokenThread;
    private Throwable unhandledThrowable;
    private static boolean toastWaitEnded = true;

    ErrorReporter(Context context, SharedPreferences prefs, boolean enabled) {
        this.mContext = context;
        this.prefs = prefs;
        this.enabled = enabled;
        String initialConfiguration = ConfigurationCollector.collectConfiguration(this.mContext);
        Time appStartDate = new Time();
        appStartDate.setToNow();
        this.crashReportDataFactory = new CrashReportDataFactory(this.mContext, prefs, appStartDate, initialConfiguration);
        this.mDfltExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
        this.checkReportsOnApplicationStart();
    }

    public static ErrorReporter getInstance() {
        return ACRA.getErrorReporter();
    }

    @Deprecated
    public void addCustomData(String key, String value) {
        this.crashReportDataFactory.putCustomData(key, value);
    }

    public String putCustomData(String key, String value) {
        return this.crashReportDataFactory.putCustomData(key, value);
    }

    public String removeCustomData(String key) {
        return this.crashReportDataFactory.removeCustomData(key);
    }

    public String getCustomData(String key) {
        return this.crashReportDataFactory.getCustomData(key);
    }

    public void addReportSender(ReportSender sender) {
        this.mReportSenders.add(sender);
    }

    public void removeReportSender(ReportSender sender) {
        this.mReportSenders.remove(sender);
    }

    public void removeReportSenders(Class<?> senderClass) {
        if (ReportSender.class.isAssignableFrom(senderClass)) {
            for (ReportSender sender : this.mReportSenders) {
                if (!senderClass.isInstance(sender)) continue;
                this.mReportSenders.remove(sender);
            }
        }
    }

    public void removeAllReportSenders() {
        this.mReportSenders.clear();
    }

    public void setReportSender(ReportSender sender) {
        this.removeAllReportSenders();
        this.addReportSender(sender);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        block5: {
            try {
                if (!this.enabled) {
                    if (this.mDfltExceptionHandler != null) {
                        Log.e((String)ACRA.LOG_TAG, (String)("ACRA is disabled for " + this.mContext.getPackageName() + " - forwarding uncaught Exception on to default ExceptionHandler"));
                        this.mDfltExceptionHandler.uncaughtException(t, e);
                    } else {
                        Log.e((String)ACRA.LOG_TAG, (String)("ACRA is disabled for " + this.mContext.getPackageName() + " - no default ExceptionHandler"));
                    }
                    return;
                }
                this.brokenThread = t;
                this.unhandledThrowable = e;
                Log.e((String)ACRA.LOG_TAG, (String)("ACRA caught a " + e.getClass().getSimpleName() + " exception for " + this.mContext.getPackageName() + ". Building report."));
                this.handleException(e, ACRA.getConfig().mode(), false, true);
            }
            catch (Throwable fatality) {
                if (this.mDfltExceptionHandler == null) break block5;
                this.mDfltExceptionHandler.uncaughtException(t, e);
            }
        }
    }

    private void endApplication() {
        if (ACRA.getConfig().mode() == ReportingInteractionMode.SILENT || ACRA.getConfig().mode() == ReportingInteractionMode.TOAST && ACRA.getConfig().forceCloseDialogAfterToast()) {
            this.mDfltExceptionHandler.uncaughtException(this.brokenThread, this.unhandledThrowable);
        } else {
            Log.e((String)ACRA.LOG_TAG, (String)(this.mContext.getPackageName() + " fatal error : " + this.unhandledThrowable.getMessage()), (Throwable)this.unhandledThrowable);
            Process.killProcess((int)Process.myPid());
            System.exit(10);
        }
    }

    public void handleSilentException(Throwable e) {
        if (this.enabled) {
            this.handleException(e, ReportingInteractionMode.SILENT, true, false);
            Log.d((String)ACRA.LOG_TAG, (String)"ACRA sent Silent report.");
            return;
        }
        Log.d((String)ACRA.LOG_TAG, (String)"ACRA is disabled. Silent report not sent.");
    }

    public void setEnabled(boolean enabled) {
        Log.i((String)ACRA.LOG_TAG, (String)("ACRA is " + (enabled ? "enabled" : "disabled") + " for " + this.mContext.getPackageName()));
        this.enabled = enabled;
    }

    SendWorker startSendingReports(boolean onlySendSilentReports, boolean approveReportsFirst) {
        SendWorker worker = new SendWorker(this.mContext, this.mReportSenders, onlySendSilentReports, approveReportsFirst);
        worker.start();
        return worker;
    }

    void deletePendingReports() {
        this.deletePendingReports(true, true, 0);
    }

    private void checkReportsOnApplicationStart() {
        CrashReportFinder reportFinder;
        String[] filesList;
        boolean newVersion;
        long lastVersionNr = this.prefs.getInt("acra.lastVersionNr", 0);
        PackageManagerWrapper packageManagerWrapper = new PackageManagerWrapper(this.mContext);
        PackageInfo packageInfo = packageManagerWrapper.getPackageInfo();
        boolean bl = newVersion = packageInfo != null && (long)packageInfo.versionCode > lastVersionNr;
        if (newVersion) {
            if (ACRA.getConfig().deleteOldUnsentReportsOnApplicationStart()) {
                this.deletePendingReports();
            }
            SharedPreferences.Editor prefsEditor = this.prefs.edit();
            prefsEditor.putInt("acra.lastVersionNr", packageInfo.versionCode);
            prefsEditor.commit();
        }
        if ((ACRA.getConfig().mode() == ReportingInteractionMode.NOTIFICATION || ACRA.getConfig().mode() == ReportingInteractionMode.DIALOG) && ACRA.getConfig().deleteUnapprovedReportsOnApplicationStart()) {
            this.deletePendingNonApprovedReports(true);
        }
        if ((filesList = (reportFinder = new CrashReportFinder(this.mContext)).getCrashReportFiles()) != null && filesList.length > 0) {
            ReportingInteractionMode reportingInteractionMode = ACRA.getConfig().mode();
            filesList = reportFinder.getCrashReportFiles();
            boolean onlySilentOrApprovedReports = this.containsOnlySilentOrApprovedReports(filesList);
            if (reportingInteractionMode == ReportingInteractionMode.SILENT || reportingInteractionMode == ReportingInteractionMode.TOAST || onlySilentOrApprovedReports && (reportingInteractionMode == ReportingInteractionMode.NOTIFICATION || reportingInteractionMode == ReportingInteractionMode.DIALOG)) {
                if (reportingInteractionMode == ReportingInteractionMode.TOAST && !onlySilentOrApprovedReports) {
                    ToastSender.sendToast(this.mContext, ACRA.getConfig().resToastText(), 1);
                }
                Log.v((String)ACRA.LOG_TAG, (String)"About to start ReportSenderWorker from #checkReportOnApplicationStart");
                this.startSendingReports(false, false);
            } else if (ACRA.getConfig().mode() == ReportingInteractionMode.NOTIFICATION) {
                this.notifySendReport(this.getLatestNonSilentReport(filesList));
            } else if (ACRA.getConfig().mode() == ReportingInteractionMode.DIALOG) {
                this.notifyDialog(this.getLatestNonSilentReport(filesList));
            }
        }
    }

    void deletePendingNonApprovedReports(boolean keepOne) {
        int nbReportsToKeep = keepOne ? 1 : 0;
        this.deletePendingReports(false, true, nbReportsToKeep);
    }

    public void handleException(Throwable e, boolean endApplication) {
        this.handleException(e, ACRA.getConfig().mode(), false, endApplication);
    }

    public void handleException(Throwable e) {
        this.handleException(e, ACRA.getConfig().mode(), false, false);
    }

    private void handleException(Throwable e, ReportingInteractionMode reportingInteractionMode, boolean forceSilentReport, final boolean endApplication) {
        boolean shouldDisplayToast;
        if (!this.enabled) {
            return;
        }
        boolean sendOnlySilentReports = false;
        if (reportingInteractionMode == null) {
            reportingInteractionMode = ACRA.getConfig().mode();
        } else if (reportingInteractionMode == ReportingInteractionMode.SILENT && ACRA.getConfig().mode() != ReportingInteractionMode.SILENT) {
            sendOnlySilentReports = true;
        }
        if (e == null) {
            e = new Exception("Report requested by developer");
        }
        boolean bl = shouldDisplayToast = reportingInteractionMode == ReportingInteractionMode.TOAST || ACRA.getConfig().resToastText() != 0 && (reportingInteractionMode == ReportingInteractionMode.NOTIFICATION || reportingInteractionMode == ReportingInteractionMode.DIALOG);
        if (shouldDisplayToast) {
            new Thread(){

                @Override
                public void run() {
                    Looper.prepare();
                    ToastSender.sendToast(ErrorReporter.this.mContext, ACRA.getConfig().resToastText(), 1);
                    Looper.loop();
                }
            }.start();
        }
        CrashReportData crashReportData = this.crashReportDataFactory.createCrashData(e, forceSilentReport, this.brokenThread);
        final String reportFileName = this.getReportFileName(crashReportData);
        this.saveCrashReportFile(reportFileName, crashReportData);
        SendWorker sender = null;
        if (reportingInteractionMode == ReportingInteractionMode.SILENT || reportingInteractionMode == ReportingInteractionMode.TOAST || this.prefs.getBoolean("acra.alwaysaccept", false)) {
            Log.d((String)ACRA.LOG_TAG, (String)"About to start ReportSenderWorker from #handleException");
            sender = this.startSendingReports(sendOnlySilentReports, true);
        } else if (reportingInteractionMode == ReportingInteractionMode.NOTIFICATION) {
            Log.d((String)ACRA.LOG_TAG, (String)"About to send status bar notification from #handleException");
            this.notifySendReport(reportFileName);
        }
        if (shouldDisplayToast) {
            toastWaitEnded = false;
            new Thread(){

                @Override
                public void run() {
                    Time beforeWait = new Time();
                    Time currentTime = new Time();
                    beforeWait.setToNow();
                    long beforeWaitInMillis = beforeWait.toMillis(false);
                    long elapsedTimeInMillis = 0L;
                    while (elapsedTimeInMillis < 3000L) {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException e1) {
                            Log.d((String)ACRA.LOG_TAG, (String)"Interrupted while waiting for Toast to end.", (Throwable)e1);
                        }
                        currentTime.setToNow();
                        elapsedTimeInMillis = currentTime.toMillis(false) - beforeWaitInMillis;
                    }
                    toastWaitEnded = true;
                }
            }.start();
        }
        final SendWorker worker = sender;
        final boolean showDirectDialog = reportingInteractionMode == ReportingInteractionMode.DIALOG;
        new Thread(){

            @Override
            public void run() {
                Log.d((String)ACRA.LOG_TAG, (String)"Waiting for Toast + worker...");
                while (!toastWaitEnded || worker != null && worker.isAlive()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e1) {
                        Log.e((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)e1);
                    }
                }
                if (showDirectDialog) {
                    Log.d((String)ACRA.LOG_TAG, (String)"About to create DIALOG from #handleException");
                    ErrorReporter.this.notifyDialog(reportFileName);
                }
                Log.d((String)ACRA.LOG_TAG, (String)("Wait for Toast + worker ended. Kill Application ? " + endApplication));
                if (endApplication) {
                    ErrorReporter.this.endApplication();
                }
            }
        }.start();
    }

    void notifyDialog(String reportFileName) {
        Log.d((String)ACRA.LOG_TAG, (String)("Creating Dialog for " + reportFileName));
        Intent dialogIntent = new Intent(this.mContext, CrashReportDialog.class);
        dialogIntent.putExtra("REPORT_FILE_NAME", reportFileName);
        dialogIntent.setFlags(0x10000000);
        this.mContext.startActivity(dialogIntent);
    }

    private void notifySendReport(String reportFileName) {
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        ACRAConfiguration conf = ACRA.getConfig();
        int icon = conf.resNotifIcon();
        CharSequence tickerText = this.mContext.getText(conf.resNotifTickerText());
        long when = System.currentTimeMillis();
        Notification notification = new Notification(icon, tickerText, when);
        CharSequence contentTitle = this.mContext.getText(conf.resNotifTitle());
        CharSequence contentText = this.mContext.getText(conf.resNotifText());
        Intent notificationIntent = new Intent(this.mContext, CrashReportDialog.class);
        Log.d((String)ACRA.LOG_TAG, (String)("Creating Notification for " + reportFileName));
        notificationIntent.putExtra("REPORT_FILE_NAME", reportFileName);
        PendingIntent contentIntent = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)notificationIntent, (int)0x8000000);
        notification.setLatestEventInfo(this.mContext, contentTitle, contentText, contentIntent);
        notificationManager.cancelAll();
        notificationManager.notify(666, notification);
    }

    private String getReportFileName(CrashReportData crashData) {
        Time now = new Time();
        now.setToNow();
        long timestamp = now.toMillis(false);
        String isSilent = crashData.getProperty(ReportField.IS_SILENT);
        return "" + timestamp + (isSilent != null ? ACRAConstants.SILENT_SUFFIX : "") + ".stacktrace";
    }

    private void saveCrashReportFile(String fileName, CrashReportData crashData) {
        try {
            Log.d((String)ACRA.LOG_TAG, (String)("Writing crash report file " + fileName + "."));
            CrashReportPersister persister = new CrashReportPersister(this.mContext);
            persister.store(crashData, fileName);
        }
        catch (Exception e) {
            Log.e((String)ACRA.LOG_TAG, (String)"An error occurred while writing the report file...", (Throwable)e);
        }
    }

    private String getLatestNonSilentReport(String[] filesList) {
        if (filesList != null && filesList.length > 0) {
            for (int i = filesList.length - 1; i >= 0; --i) {
                if (this.fileNameParser.isSilent(filesList[i])) continue;
                return filesList[i];
            }
            return filesList[filesList.length - 1];
        }
        return null;
    }

    private void deletePendingReports(boolean deleteApprovedReports, boolean deleteNonApprovedReports, int nbOfLatestToKeep) {
        CrashReportFinder reportFinder = new CrashReportFinder(this.mContext);
        Object[] filesList = reportFinder.getCrashReportFiles();
        Arrays.sort(filesList);
        if (filesList != null) {
            for (int iFile = 0; iFile < filesList.length - nbOfLatestToKeep; ++iFile) {
                Object fileName = filesList[iFile];
                boolean isReportApproved = this.fileNameParser.isApproved((String)fileName);
                if ((!isReportApproved || !deleteApprovedReports) && (isReportApproved || !deleteNonApprovedReports)) continue;
                File fileToDelete = new File(this.mContext.getFilesDir(), (String)fileName);
                Log.d((String)ACRA.LOG_TAG, (String)("Deleting file " + (String)fileName));
                if (fileToDelete.delete()) continue;
                Log.e((String)ACRA.LOG_TAG, (String)("Could not delete report : " + fileToDelete));
            }
        }
    }

    private boolean containsOnlySilentOrApprovedReports(String[] reportFileNames) {
        for (String reportFileName : reportFileNames) {
            if (this.fileNameParser.isApproved(reportFileName)) continue;
            return false;
        }
        return true;
    }
}

